/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.source.reader;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.document.Array;
import io.debezium.relational.TableId;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.TableChanges;
import java.util.Map;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.flink.util.Collector;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.debezium.DebeziumDeserializationSchema;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.debezium.history.FlinkJsonTableChangeSerializer;
import org.apache.inlong.sort.cdc.mysql.source.metrics.MySqlSourceReaderMetrics;
import org.apache.inlong.sort.cdc.mysql.source.offset.BinlogOffset;
import org.apache.inlong.sort.cdc.mysql.source.split.MySqlSplitState;
import org.apache.inlong.sort.cdc.mysql.source.utils.RecordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySqlRecordEmitter<T>
implements RecordEmitter<SourceRecord, T, MySqlSplitState> {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlRecordEmitter.class);
    private static final FlinkJsonTableChangeSerializer TABLE_CHANGE_SERIALIZER = new FlinkJsonTableChangeSerializer();
    private final DebeziumDeserializationSchema<T> debeziumDeserializationSchema;
    private final MySqlSourceReaderMetrics sourceReaderMetrics;
    private final boolean includeSchemaChanges;
    private final OutputCollector<T> outputCollector;
    private volatile long binlogPos = 0L;
    private volatile long binlogFileNum = 0L;
    private volatile Boolean iSnapShot = false;
    private volatile long messageTimestamp = 0L;
    private volatile long fetchDelay = 0L;
    private volatile Long snapDuration;
    private volatile long snapEarliestTime = 0L;
    private volatile long snapProcessTime = 0L;

    public MySqlRecordEmitter(DebeziumDeserializationSchema<T> debeziumDeserializationSchema, MySqlSourceReaderMetrics sourceReaderMetrics, boolean includeSchemaChanges) {
        this.debeziumDeserializationSchema = debeziumDeserializationSchema;
        this.sourceReaderMetrics = sourceReaderMetrics;
        this.includeSchemaChanges = includeSchemaChanges;
        this.outputCollector = new OutputCollector();
    }

    public void emitRecord(final SourceRecord element, final SourceOutput<T> output, MySqlSplitState splitState) throws Exception {
        if (RecordUtils.isWatermarkEvent(element)) {
            BinlogOffset watermark = RecordUtils.getWatermark(element);
            if (RecordUtils.isHighWatermarkEvent(element) && splitState.isSnapshotSplitState()) {
                splitState.asSnapshotSplitState().setHighWatermark(watermark);
            }
        } else if (RecordUtils.isSchemaChangeEvent(element) && splitState.isBinlogSplitState()) {
            HistoryRecord historyRecord = RecordUtils.getHistoryRecord(element);
            Array tableChanges = historyRecord.document().getArray("tableChanges");
            TableChanges changes = TABLE_CHANGE_SERIALIZER.deserialize(tableChanges, true);
            for (TableChanges.TableChange tableChange : changes) {
                splitState.asBinlogSplitState().recordSchema(tableChange.getId(), tableChange);
            }
            if (this.includeSchemaChanges) {
                BinlogOffset position = RecordUtils.getBinlogPosition(element);
                splitState.asBinlogSplitState().setStartingOffset(position);
                this.emitElement(element, output, null);
            }
        } else if (RecordUtils.isDataChangeRecord(element)) {
            if (splitState.isBinlogSplitState()) {
                BinlogOffset position = RecordUtils.getBinlogPosition(element);
                splitState.asBinlogSplitState().setStartingOffset(position);
                this.reportPos(position);
                this.iSnapShot = false;
                this.updateMessageTimestamp(element);
            } else {
                if (splitState.isSnapshotSplitState()) {
                    this.iSnapShot = true;
                }
                this.updateMessageTimestampSnap(element);
            }
            this.fetchDelay = System.currentTimeMillis() - this.messageTimestamp;
            this.reportMetrics(element);
            Map<TableId, TableChanges.TableChange> tableSchemas = splitState.getMySQLSplit().getTableSchemas();
            TableChanges.TableChange tableSchema = tableSchemas.getOrDefault(com.ververica.cdc.connectors.mysql.source.utils.RecordUtils.getTableId(element), null);
            this.debeziumDeserializationSchema.deserialize(element, new Collector<T>(){

                public void collect(T t) {
                    Struct value = (Struct)element.value();
                    Struct source = value.getStruct("source");
                    String databaseName = source.getString("db");
                    String tableName = source.getString("table");
                    MySqlRecordEmitter.this.sourceReaderMetrics.outputMetrics(databaseName, tableName, MySqlRecordEmitter.this.iSnapShot, t);
                    output.collect(t);
                }

                public void close() {
                }
            }, tableSchema);
        } else if (RecordUtils.isHeartbeatEvent(element)) {
            this.updateStartingOffsetForSplit(splitState, element);
        } else {
            LOG.info("Meet unknown element {}, just skip.", (Object)element);
        }
    }

    private void updateStartingOffsetForSplit(MySqlSplitState splitState, SourceRecord element) {
        if (splitState.isBinlogSplitState()) {
            BinlogOffset position = RecordUtils.getBinlogPosition(element);
            splitState.asBinlogSplitState().setStartingOffset(position);
        }
    }

    private void emitElement(SourceRecord element, SourceOutput<T> output, TableChanges.TableChange tableSchema) throws Exception {
        ((OutputCollector)this.outputCollector).output = output;
        this.debeziumDeserializationSchema.deserialize(element, this.outputCollector, tableSchema);
    }

    private void reportMetrics(SourceRecord element) {
        long now = System.currentTimeMillis();
        this.sourceReaderMetrics.recordProcessTime(now);
        Long messageTimestamp = RecordUtils.getMessageTimestamp(element);
        if (messageTimestamp != null && messageTimestamp > 0L) {
            Long fetchTimestamp = RecordUtils.getFetchTimestamp(element);
            if (fetchTimestamp != null && fetchTimestamp >= messageTimestamp) {
                this.sourceReaderMetrics.recordFetchDelay(fetchTimestamp - messageTimestamp);
            }
            this.sourceReaderMetrics.recordEmitDelay(now - messageTimestamp);
        }
    }

    private void reportPos(BinlogOffset position) {
        block2: {
            try {
                this.binlogPos = position.getPosition();
                this.binlogFileNum = Long.parseLong(position.getFilename().replaceAll("\\D", ""));
            }
            catch (NumberFormatException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Can not translate binlog pos or flile name.");
            }
        }
    }

    private void updateMessageTimestamp(SourceRecord record) {
        Schema schema = record.valueSchema();
        Struct value = (Struct)record.value();
        if (schema.field("source") == null) {
            return;
        }
        Struct source = value.getStruct("source");
        if (source.schema().field("ts_ms") == null) {
            return;
        }
        Long tsMs = source.getInt64("ts_ms");
        if (tsMs != null) {
            this.messageTimestamp = tsMs;
        }
    }

    private void updateMessageTimestampSnap(SourceRecord record) {
        Schema schema = record.valueSchema();
        Struct value = (Struct)record.value();
        if (schema.field("source") == null) {
            return;
        }
        Struct source = value.getStruct("source");
        if (source.schema().field("ts_ms") == null) {
            return;
        }
        Long tsMs = source.getInt64("ts_ms");
        if (tsMs != null) {
            this.messageTimestamp = tsMs;
            if (this.snapDuration == null) {
                this.snapEarliestTime = tsMs;
                this.snapDuration = System.currentTimeMillis() - tsMs;
            }
            if (this.snapEarliestTime > tsMs) {
                this.snapEarliestTime = tsMs;
            }
            this.snapProcessTime = tsMs - this.snapEarliestTime;
        }
    }

    private static class OutputCollector<T>
    implements Collector<T> {
        private SourceOutput<T> output;

        private OutputCollector() {
        }

        public void collect(T record) {
            this.output.collect(record);
        }

        public void close() {
        }
    }
}

