/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.source.metrics;

import com.ververica.cdc.connectors.shaded.com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.metrics.MetricGroup;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.metric.MetricOption;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.metric.MetricState;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.metric.sub.SourceTableMetricData;
import org.apache.inlong.sort.cdc.mysql.source.split.MySqlMetricSplit;

public class MySqlSourceReaderMetrics {
    private final MetricGroup metricGroup;
    private volatile long processTime = 0L;
    private volatile long fetchDelay = 0L;
    private volatile long emitDelay = 0L;
    private SourceTableMetricData sourceTableMetricData;

    public MySqlSourceReaderMetrics(MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
    }

    public void registerMetrics(MetricOption metricOption) {
        if (metricOption != null) {
            this.sourceTableMetricData = new SourceTableMetricData(metricOption, this.metricGroup, Arrays.asList("database", "table"));
        }
        this.metricGroup.gauge("currentFetchEventTimeLag", this::getFetchDelay);
        this.metricGroup.gauge("currentEmitEventTimeLag", this::getEmitDelay);
        this.metricGroup.gauge("sourceIdleTime", this::getIdleTime);
    }

    public long getFetchDelay() {
        return this.fetchDelay;
    }

    public long getEmitDelay() {
        return this.emitDelay;
    }

    public long getIdleTime() {
        if (this.processTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.processTime;
    }

    public void recordProcessTime(long processTime) {
        this.processTime = processTime;
    }

    public void recordFetchDelay(long fetchDelay) {
        this.fetchDelay = fetchDelay;
    }

    public void recordEmitDelay(long emitDelay) {
        this.emitDelay = emitDelay;
    }

    public void outputMetrics(String database, String table, boolean isSnapshotRecord, Object data) {
        if (this.sourceTableMetricData != null) {
            this.sourceTableMetricData.outputMetricsWithEstimate(database, table, isSnapshotRecord, data);
        }
    }

    public void initMetrics(long rowCountSize, long rowDataSize, Map<String, Long> readPhaseMetricMap, Map<String, MySqlMetricSplit.MySqlTableMetric> tableMetricMap) {
        if (this.sourceTableMetricData != null) {
            this.sourceTableMetricData.getNumBytesIn().inc(rowDataSize);
            this.sourceTableMetricData.getNumRecordsIn().inc(rowCountSize);
            if (readPhaseMetricMap != null && tableMetricMap != null) {
                MetricState metricState = new MetricState();
                metricState.setMetrics(readPhaseMetricMap);
                HashMap<String, MetricState> subMetricStateMap = new HashMap<String, MetricState>();
                tableMetricMap.entrySet().stream().filter(v -> v.getValue() != null).forEach(entry -> {
                    MetricState subMetricState = new MetricState();
                    subMetricState.setMetrics(ImmutableMap.of("numRecordsIn", ((MySqlMetricSplit.MySqlTableMetric)entry.getValue()).getNumRecordsIn(), "numBytesIn", ((MySqlMetricSplit.MySqlTableMetric)entry.getValue()).getNumBytesIn()));
                    subMetricStateMap.put((String)entry.getKey(), subMetricState);
                });
                metricState.setSubMetricStateMap(subMetricStateMap);
                this.sourceTableMetricData.registerSubMetricsGroup(metricState);
            }
        }
    }

    public SourceTableMetricData getSourceMetricData() {
        return this.sourceTableMetricData;
    }
}

