/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.source.connection;

import com.ververica.cdc.connectors.shaded.com.zaxxer.hikari.HikariConfig;
import com.ververica.cdc.connectors.shaded.com.zaxxer.hikari.HikariDataSource;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.inlong.sort.cdc.mysql.source.config.MySqlSourceConfig;

public class PooledDataSourceFactory {
    public static final String JDBC_URL_PATTERN = "jdbc:mysql://%s:%s/?useInformationSchema=true&nullCatalogMeansCurrent=false&useUnicode=true";
    public static final String CONNECTION_POOL_PREFIX = "connection-pool-";
    public static final String SERVER_TIMEZONE_KEY = "serverTimezone";
    public static final int MINIMUM_POOL_SIZE = 1;
    private static final Properties DEFAULT_JDBC_PROPERTIES = PooledDataSourceFactory.initializeDefaultJdbcProperties();

    private PooledDataSourceFactory() {
    }

    public static HikariDataSource createPooledDataSource(MySqlSourceConfig sourceConfig) {
        HikariConfig config = new HikariConfig();
        String hostName = sourceConfig.getHostname();
        int port = sourceConfig.getPort();
        Properties jdbcProperties = sourceConfig.getJdbcProperties();
        config.setPoolName(CONNECTION_POOL_PREFIX + hostName + ":" + port);
        config.setJdbcUrl(PooledDataSourceFactory.formatJdbcUrl(hostName, port, jdbcProperties));
        config.setUsername(sourceConfig.getUsername());
        config.setPassword(sourceConfig.getPassword());
        config.setMinimumIdle(1);
        config.setMaximumPoolSize(sourceConfig.getConnectionPoolSize());
        config.setConnectionTimeout(sourceConfig.getConnectTimeout().toMillis());
        config.addDataSourceProperty(SERVER_TIMEZONE_KEY, sourceConfig.getServerTimeZone());
        config.setDriverClassName(sourceConfig.getDbzConfiguration().getString(MySqlConnectorConfig.JDBC_DRIVER));
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        return new HikariDataSource(config);
    }

    private static String formatJdbcUrl(String hostName, int port, Properties jdbcProperties) {
        Properties combinedProperties = new Properties();
        combinedProperties.putAll((Map<?, ?>)DEFAULT_JDBC_PROPERTIES);
        combinedProperties.putAll((Map<?, ?>)jdbcProperties);
        StringBuilder jdbcUrlStringBuilder = new StringBuilder(String.format(JDBC_URL_PATTERN, hostName, port));
        combinedProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> jdbcUrlStringBuilder.append("&").append(key).append("=").append(value)));
        return jdbcUrlStringBuilder.toString();
    }

    private static Properties initializeDefaultJdbcProperties() {
        Properties defaultJdbcProperties = new Properties();
        defaultJdbcProperties.setProperty("zeroDateTimeBehavior", "CONVERT_TO_NULL");
        defaultJdbcProperties.setProperty("characterEncoding", "UTF-8");
        defaultJdbcProperties.setProperty("characterSetResults", "UTF-8");
        return defaultJdbcProperties;
    }
}

