/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.source.assigners.state;

import io.debezium.relational.TableId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.inlong.sort.cdc.mysql.source.assigners.AssignerStatus;
import org.apache.inlong.sort.cdc.mysql.source.assigners.state.BinlogPendingSplitsState;
import org.apache.inlong.sort.cdc.mysql.source.assigners.state.HybridPendingSplitsState;
import org.apache.inlong.sort.cdc.mysql.source.assigners.state.PendingSplitsState;
import org.apache.inlong.sort.cdc.mysql.source.assigners.state.SnapshotPendingSplitsState;
import org.apache.inlong.sort.cdc.mysql.source.offset.BinlogOffset;
import org.apache.inlong.sort.cdc.mysql.source.split.MySqlSnapshotSplit;
import org.apache.inlong.sort.cdc.mysql.source.split.MySqlSplit;
import org.apache.inlong.sort.cdc.mysql.source.utils.SerializerUtils;

public class PendingSplitsStateSerializer
implements SimpleVersionedSerializer<PendingSplitsState> {
    private static final int VERSION = 3;
    private static final ThreadLocal<DataOutputSerializer> SERIALIZER_CACHE = ThreadLocal.withInitial(() -> new DataOutputSerializer(64));
    private static final int SNAPSHOT_PENDING_SPLITS_STATE_FLAG = 1;
    private static final int BINLOG_PENDING_SPLITS_STATE_FLAG = 2;
    private static final int HYBRID_PENDING_SPLITS_STATE_FLAG = 3;
    private final SimpleVersionedSerializer<MySqlSplit> splitSerializer;

    public PendingSplitsStateSerializer(SimpleVersionedSerializer<MySqlSplit> splitSerializer) {
        this.splitSerializer = splitSerializer;
    }

    public int getVersion() {
        return 3;
    }

    public byte[] serialize(PendingSplitsState state) throws IOException {
        if (state.serializedFormCache != null) {
            return state.serializedFormCache;
        }
        DataOutputSerializer out = SERIALIZER_CACHE.get();
        out.writeInt(this.splitSerializer.getVersion());
        if (state instanceof SnapshotPendingSplitsState) {
            out.writeInt(1);
            this.serializeSnapshotPendingSplitsState((SnapshotPendingSplitsState)state, out);
        } else if (state instanceof BinlogPendingSplitsState) {
            out.writeInt(2);
            this.serializeBinlogPendingSplitsState((BinlogPendingSplitsState)state, out);
        } else if (state instanceof HybridPendingSplitsState) {
            out.writeInt(3);
            this.serializeHybridPendingSplitsState((HybridPendingSplitsState)state, out);
        } else {
            throw new IOException("Unsupported to serialize PendingSplitsState class: " + state.getClass().getName());
        }
        byte[] result = out.getCopyOfBuffer();
        state.serializedFormCache = result;
        out.clear();
        return result;
    }

    public PendingSplitsState deserialize(int version, byte[] serialized) throws IOException {
        switch (version) {
            case 1: 
            case 2: {
                return this.deserializeLegacyPendingSplitsState(serialized);
            }
            case 3: 
            case 4: {
                return this.deserializePendingSplitsState(serialized);
            }
        }
        throw new IOException("Unknown version: " + version);
    }

    public PendingSplitsState deserializeLegacyPendingSplitsState(byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        int splitVersion = in.readInt();
        int stateFlag = in.readInt();
        if (stateFlag == 1) {
            return this.deserializeLegacySnapshotPendingSplitsState(splitVersion, in);
        }
        if (stateFlag == 3) {
            return this.deserializeLegacyHybridPendingSplitsState(splitVersion, in);
        }
        if (stateFlag == 2) {
            return this.deserializeBinlogPendingSplitsState(in);
        }
        throw new IOException("Unsupported to deserialize PendingSplitsState flag: " + stateFlag);
    }

    public PendingSplitsState deserializePendingSplitsState(byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        int splitVersion = in.readInt();
        int stateFlag = in.readInt();
        if (stateFlag == 1) {
            return this.deserializeSnapshotPendingSplitsState(splitVersion, in);
        }
        if (stateFlag == 3) {
            return this.deserializeHybridPendingSplitsState(splitVersion, in);
        }
        if (stateFlag == 2) {
            return this.deserializeBinlogPendingSplitsState(in);
        }
        throw new IOException("Unsupported to deserialize PendingSplitsState flag: " + stateFlag);
    }

    private void serializeSnapshotPendingSplitsState(SnapshotPendingSplitsState state, DataOutputSerializer out) throws IOException {
        this.writeTableIds(state.getAlreadyProcessedTables(), out);
        this.writeMySqlSplits(state.getRemainingSplits(), out);
        this.writeAssignedSnapshotSplits(state.getAssignedSplits(), out);
        this.writeFinishedOffsets(state.getSplitFinishedOffsets(), out);
        out.writeInt(state.getSnapshotAssignerStatus().getStatusCode());
        this.writeTableIds(state.getRemainingTables(), out);
        out.writeBoolean(state.isTableIdCaseSensitive());
    }

    private void serializeHybridPendingSplitsState(HybridPendingSplitsState state, DataOutputSerializer out) throws IOException {
        this.serializeSnapshotPendingSplitsState(state.getSnapshotPendingSplits(), out);
        out.writeBoolean(state.isBinlogSplitAssigned());
    }

    private void serializeBinlogPendingSplitsState(BinlogPendingSplitsState state, DataOutputSerializer out) throws IOException {
        out.writeBoolean(state.isBinlogSplitAssigned());
    }

    private SnapshotPendingSplitsState deserializeLegacySnapshotPendingSplitsState(int splitVersion, DataInputDeserializer in) throws IOException {
        List<TableId> alreadyProcessedTables = this.readTableIds(in);
        List<MySqlSnapshotSplit> remainingSplits = this.readMySqlSnapshotSplits(splitVersion, in);
        Map<String, MySqlSnapshotSplit> assignedSnapshotSplits = this.readAssignedSnapshotSplits(splitVersion, in);
        Map<String, BinlogOffset> finishedOffsets = this.readFinishedOffsets(splitVersion, in);
        boolean isAssignerFinished = in.readBoolean();
        AssignerStatus assignerStatus = isAssignerFinished ? AssignerStatus.INITIAL_ASSIGNING_FINISHED : AssignerStatus.INITIAL_ASSIGNING;
        return new SnapshotPendingSplitsState(alreadyProcessedTables, remainingSplits, assignedSnapshotSplits, finishedOffsets, assignerStatus, new ArrayList<TableId>(), false, false);
    }

    private HybridPendingSplitsState deserializeLegacyHybridPendingSplitsState(int splitVersion, DataInputDeserializer in) throws IOException {
        SnapshotPendingSplitsState snapshotPendingSplitsState = this.deserializeLegacySnapshotPendingSplitsState(splitVersion, in);
        boolean isBinlogSplitAssigned = in.readBoolean();
        return new HybridPendingSplitsState(snapshotPendingSplitsState, isBinlogSplitAssigned);
    }

    private SnapshotPendingSplitsState deserializeSnapshotPendingSplitsState(int splitVersion, DataInputDeserializer in) throws IOException {
        boolean isAssignerFinished;
        List<TableId> alreadyProcessedTables = this.readTableIds(in);
        List<MySqlSnapshotSplit> remainingSplits = this.readMySqlSnapshotSplits(splitVersion, in);
        Map<String, MySqlSnapshotSplit> assignedSnapshotSplits = this.readAssignedSnapshotSplits(splitVersion, in);
        Map<String, BinlogOffset> finishedOffsets = this.readFinishedOffsets(splitVersion, in);
        AssignerStatus assignerStatus = splitVersion < 4 ? ((isAssignerFinished = in.readBoolean()) ? AssignerStatus.INITIAL_ASSIGNING_FINISHED : AssignerStatus.INITIAL_ASSIGNING) : AssignerStatus.fromStatusCode(in.readInt());
        List<TableId> remainingTableIds = this.readTableIds(in);
        boolean isTableIdCaseSensitive = in.readBoolean();
        return new SnapshotPendingSplitsState(alreadyProcessedTables, remainingSplits, assignedSnapshotSplits, finishedOffsets, assignerStatus, remainingTableIds, isTableIdCaseSensitive, true);
    }

    private HybridPendingSplitsState deserializeHybridPendingSplitsState(int splitVersion, DataInputDeserializer in) throws IOException {
        SnapshotPendingSplitsState snapshotPendingSplitsState = this.deserializeSnapshotPendingSplitsState(splitVersion, in);
        boolean isBinlogSplitAssigned = in.readBoolean();
        return new HybridPendingSplitsState(snapshotPendingSplitsState, isBinlogSplitAssigned);
    }

    private BinlogPendingSplitsState deserializeBinlogPendingSplitsState(DataInputDeserializer in) throws IOException {
        return new BinlogPendingSplitsState(in.readBoolean());
    }

    private void writeFinishedOffsets(Map<String, BinlogOffset> splitsInfo, DataOutputSerializer out) throws IOException {
        int size = splitsInfo.size();
        out.writeInt(size);
        for (Map.Entry<String, BinlogOffset> splitInfo : splitsInfo.entrySet()) {
            out.writeUTF(splitInfo.getKey());
            SerializerUtils.writeBinlogPosition(splitInfo.getValue(), out);
        }
    }

    private Map<String, BinlogOffset> readFinishedOffsets(int offsetVersion, DataInputDeserializer in) throws IOException {
        HashMap<String, BinlogOffset> splitsInfo = new HashMap<String, BinlogOffset>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String splitId = in.readUTF();
            BinlogOffset binlogOffset = SerializerUtils.readBinlogPosition(offsetVersion, in);
            splitsInfo.put(splitId, binlogOffset);
        }
        return splitsInfo;
    }

    private void writeAssignedSnapshotSplits(Map<String, MySqlSnapshotSplit> assignedSplits, DataOutputSerializer out) throws IOException {
        int size = assignedSplits.size();
        out.writeInt(size);
        for (Map.Entry<String, MySqlSnapshotSplit> entry : assignedSplits.entrySet()) {
            out.writeUTF(entry.getKey());
            byte[] splitBytes = this.splitSerializer.serialize((Object)entry.getValue());
            out.writeInt(splitBytes.length);
            out.write(splitBytes);
        }
    }

    private Map<String, MySqlSnapshotSplit> readAssignedSnapshotSplits(int splitVersion, DataInputDeserializer in) throws IOException {
        HashMap<String, MySqlSnapshotSplit> assignedSplits = new HashMap<String, MySqlSnapshotSplit>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String splitId = in.readUTF();
            MySqlSnapshotSplit mySqlSplit = this.readMySqlSplit(splitVersion, in).asSnapshotSplit();
            assignedSplits.put(splitId, mySqlSplit);
        }
        return assignedSplits;
    }

    private <T extends MySqlSplit> void writeMySqlSplits(Collection<T> mySqlSplits, DataOutputSerializer out) throws IOException {
        int size = mySqlSplits.size();
        out.writeInt(size);
        for (MySqlSplit split : mySqlSplits) {
            byte[] splitBytes = this.splitSerializer.serialize((Object)split);
            out.writeInt(splitBytes.length);
            out.write(splitBytes);
        }
    }

    private List<MySqlSnapshotSplit> readMySqlSnapshotSplits(int splitVersion, DataInputDeserializer in) throws IOException {
        ArrayList<MySqlSnapshotSplit> mySqlSplits = new ArrayList<MySqlSnapshotSplit>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            MySqlSnapshotSplit mySqlSplit = this.readMySqlSplit(splitVersion, in).asSnapshotSplit();
            mySqlSplits.add(mySqlSplit);
        }
        return mySqlSplits;
    }

    private MySqlSplit readMySqlSplit(int splitVersion, DataInputDeserializer in) throws IOException {
        int splitBytesLen = in.readInt();
        byte[] splitBytes = new byte[splitBytesLen];
        in.read(splitBytes);
        return (MySqlSplit)this.splitSerializer.deserialize(splitVersion, splitBytes);
    }

    private void writeTableIds(Collection<TableId> tableIds, DataOutputSerializer out) throws IOException {
        int size = tableIds.size();
        out.writeInt(size);
        for (TableId tableId : tableIds) {
            out.writeUTF(tableId.toString());
        }
    }

    private List<TableId> readTableIds(DataInputDeserializer in) throws IOException {
        ArrayList<TableId> tableIds = new ArrayList<TableId>();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String tableIdStr = in.readUTF();
            tableIds.add(TableId.parse(tableIdStr));
        }
        return tableIds;
    }
}

