/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.source.assigners;

import io.debezium.jdbc.JdbcConnection;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.inlong.sort.cdc.mysql.debezium.DebeziumUtils;
import org.apache.inlong.sort.cdc.mysql.schema.MySqlSchema;
import org.apache.inlong.sort.cdc.mysql.schema.MySqlTypeUtils;
import org.apache.inlong.sort.cdc.mysql.source.assigners.ChunkRange;
import org.apache.inlong.sort.cdc.mysql.source.config.MySqlSourceConfig;
import org.apache.inlong.sort.cdc.mysql.source.split.MySqlSnapshotSplit;
import org.apache.inlong.sort.cdc.mysql.source.utils.ChunkUtils;
import org.apache.inlong.sort.cdc.mysql.source.utils.ObjectUtils;
import org.apache.inlong.sort.cdc.mysql.source.utils.StatementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ChunkSplitter {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkSplitter.class);
    private final MySqlSourceConfig sourceConfig;
    private final MySqlSchema mySqlSchema;

    public ChunkSplitter(MySqlSchema mySqlSchema, MySqlSourceConfig sourceConfig) {
        this.mySqlSchema = mySqlSchema;
        this.sourceConfig = sourceConfig;
    }

    private static boolean isEvenlySplitColumn(Column splitColumn) {
        DataType flinkType = MySqlTypeUtils.fromDbzColumn(splitColumn);
        LogicalTypeRoot typeRoot = flinkType.getLogicalType().getTypeRoot();
        return typeRoot == LogicalTypeRoot.BIGINT || typeRoot == LogicalTypeRoot.INTEGER || typeRoot == LogicalTypeRoot.DECIMAL;
    }

    private static String splitId(TableId tableId, int chunkId) {
        return tableId.toString() + ":" + chunkId;
    }

    private static void maySleep(int count, TableId tableId) {
        if (count % 10 == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            LOG.info("ChunkSplitter has split {} chunks for table {}", (Object)count, (Object)tableId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<MySqlSnapshotSplit> generateSplits(TableId tableId) {
        try (JdbcConnection jdbc = DebeziumUtils.openJdbcConnection(this.sourceConfig);){
            LOG.info("Start splitting table {} into chunks...", (Object)tableId);
            long start = System.currentTimeMillis();
            Table table = this.mySqlSchema.getTableSchema(jdbc, tableId).getTable();
            List<ChunkRange> chunks = this.getChunks(tableId, jdbc, table);
            ArrayList<MySqlSnapshotSplit> splits = new ArrayList<MySqlSnapshotSplit>();
            RowType splitType = ChunkUtils.getSplitType(this.getSplitColumn(table));
            for (int i = 0; i < chunks.size(); ++i) {
                ChunkRange chunk = chunks.get(i);
                MySqlSnapshotSplit split = this.createSnapshotSplit(jdbc, tableId, i, splitType, chunk.getChunkStart(), chunk.getChunkEnd());
                splits.add(split);
            }
            long end = System.currentTimeMillis();
            LOG.info("Split table {} into {} chunks, time cost: {}ms.", new Object[]{tableId, splits.size(), end - start});
            ArrayList<MySqlSnapshotSplit> arrayList = splits;
            return arrayList;
        }
        catch (Exception e) {
            throw new FlinkRuntimeException(String.format("Generate Splits for table %s error", tableId), (Throwable)e);
        }
    }

    private Column getSplitColumn(Table table) {
        if (table.primaryKeyColumns().isEmpty()) {
            return table.columns().get(0);
        }
        return ChunkUtils.getSplitColumn(table);
    }

    private List<ChunkRange> getChunks(TableId tableId, JdbcConnection jdbc, Table table) {
        if (table.primaryKeyColumns().isEmpty()) {
            return Collections.singletonList(ChunkRange.all());
        }
        Column splitColumn = ChunkUtils.getSplitColumn(table);
        try {
            return this.splitTableIntoChunks(jdbc, tableId, splitColumn);
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Failed to split chunks for table " + tableId, (Throwable)e);
        }
    }

    private List<ChunkRange> splitTableIntoChunks(JdbcConnection jdbc, TableId tableId, Column splitColumn) throws SQLException {
        String splitColumnName = splitColumn.name();
        Object[] minMaxOfSplitColumn = StatementUtils.queryMinMax(jdbc, tableId, splitColumnName);
        Object min = minMaxOfSplitColumn[0];
        Object max = minMaxOfSplitColumn[1];
        if (min == null || max == null || min.equals(max)) {
            return Collections.singletonList(ChunkRange.all());
        }
        int chunkSize = this.sourceConfig.getSplitSize();
        double distributionFactorUpper = this.sourceConfig.getDistributionFactorUpper();
        double distributionFactorLower = this.sourceConfig.getDistributionFactorLower();
        if (ChunkSplitter.isEvenlySplitColumn(splitColumn)) {
            boolean dataIsEvenlyDistributed;
            long approximateRowCnt = StatementUtils.queryApproximateRowCnt(jdbc, tableId);
            double distributionFactor = this.calculateDistributionFactor(tableId, min, max, approximateRowCnt);
            boolean bl = dataIsEvenlyDistributed = ObjectUtils.doubleCompare(distributionFactor, distributionFactorLower) >= 0 && ObjectUtils.doubleCompare(distributionFactor, distributionFactorUpper) <= 0;
            if (dataIsEvenlyDistributed) {
                int dynamicChunkSize = Math.max((int)(distributionFactor * (double)chunkSize), 1);
                return this.splitEvenlySizedChunks(tableId, min, max, approximateRowCnt, dynamicChunkSize);
            }
            return this.splitUnevenlySizedChunks(jdbc, tableId, splitColumnName, min, max, chunkSize);
        }
        return this.splitUnevenlySizedChunks(jdbc, tableId, splitColumnName, min, max, chunkSize);
    }

    private List<ChunkRange> splitEvenlySizedChunks(TableId tableId, Object min, Object max, long approximateRowCnt, int chunkSize) {
        LOG.info("Use evenly-sized chunk optimization for table {}, the approximate row count is {}, the chunk size is {}", new Object[]{tableId, approximateRowCnt, chunkSize});
        if (approximateRowCnt <= (long)chunkSize) {
            return Collections.singletonList(ChunkRange.all());
        }
        ArrayList<ChunkRange> splits = new ArrayList<ChunkRange>();
        Object chunkStart = null;
        Object chunkEnd = ObjectUtils.plus(min, chunkSize);
        while (ObjectUtils.compare(chunkEnd, max) <= 0) {
            splits.add(ChunkRange.of(chunkStart, chunkEnd));
            chunkStart = chunkEnd;
            chunkEnd = ObjectUtils.plus(chunkEnd, chunkSize);
        }
        splits.add(ChunkRange.of(chunkStart, null));
        return splits;
    }

    private List<ChunkRange> splitUnevenlySizedChunks(JdbcConnection jdbc, TableId tableId, String splitColumnName, Object min, Object max, int chunkSize) throws SQLException {
        LOG.info("Use unevenly-sized chunks for table {}, the chunk size is {}", (Object)tableId, (Object)chunkSize);
        ArrayList<ChunkRange> splits = new ArrayList<ChunkRange>();
        Object chunkStart = null;
        Object chunkEnd = this.nextChunkEnd(jdbc, min, tableId, splitColumnName, max, chunkSize);
        int count = 0;
        while (chunkEnd != null && ObjectUtils.compare(chunkEnd, max) <= 0) {
            splits.add(ChunkRange.of(chunkStart, chunkEnd));
            ChunkSplitter.maySleep(count++, tableId);
            chunkStart = chunkEnd;
            chunkEnd = this.nextChunkEnd(jdbc, chunkEnd, tableId, splitColumnName, max, chunkSize);
        }
        splits.add(ChunkRange.of(chunkStart, null));
        return splits;
    }

    private Object nextChunkEnd(JdbcConnection jdbc, Object previousChunkEnd, TableId tableId, String splitColumnName, Object max, int chunkSize) throws SQLException {
        Object chunkEnd = StatementUtils.queryNextChunkMax(jdbc, tableId, splitColumnName, chunkSize, previousChunkEnd);
        if (Objects.equals(previousChunkEnd, chunkEnd)) {
            chunkEnd = StatementUtils.queryMin(jdbc, tableId, splitColumnName, chunkEnd);
        }
        if (ObjectUtils.compare(chunkEnd, max) >= 0) {
            return null;
        }
        return chunkEnd;
    }

    private MySqlSnapshotSplit createSnapshotSplit(JdbcConnection jdbc, TableId tableId, int chunkId, RowType splitKeyType, Object chunkStart, Object chunkEnd) {
        Object[] objectArray;
        Object[] objectArray2;
        if (chunkStart == null) {
            objectArray2 = null;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray2 = objectArray3;
            objectArray3[0] = chunkStart;
        }
        Object[] splitStart = objectArray2;
        if (chunkEnd == null) {
            objectArray = null;
        } else {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = chunkEnd;
        }
        Object[] splitEnd = objectArray;
        HashMap<TableId, TableChanges.TableChange> schema = new HashMap<TableId, TableChanges.TableChange>();
        schema.put(tableId, this.mySqlSchema.getTableSchema(jdbc, tableId));
        return new MySqlSnapshotSplit(tableId, ChunkSplitter.splitId(tableId, chunkId), splitKeyType, splitStart, splitEnd, null, schema);
    }

    private double calculateDistributionFactor(TableId tableId, Object min, Object max, long approximateRowCnt) {
        if (!min.getClass().equals(max.getClass())) {
            throw new IllegalStateException(String.format("Unsupported operation type, the MIN value type %s is different with MAX value type %s.", min.getClass().getSimpleName(), max.getClass().getSimpleName()));
        }
        if (approximateRowCnt == 0L) {
            return Double.MAX_VALUE;
        }
        BigDecimal difference = ObjectUtils.minus(max, min);
        BigDecimal subRowCnt = difference.add(BigDecimal.valueOf(1L));
        double distributionFactor = subRowCnt.divide(new BigDecimal(approximateRowCnt), 4, 2).doubleValue();
        LOG.info("The distribution factor of table {} is {} according to the min split key {}, max split key {} and approximate row count {}", new Object[]{tableId, distributionFactor, min, max, approximateRowCnt});
        return distributionFactor;
    }
}

