/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.debezium.table;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.relational.history.TableChanges;
import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.util.Collector;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.debezium.table.MetadataConverter;

@Internal
public final class AppendMetadataCollector
implements Collector<RowData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MetadataConverter[] metadataConverters;
    public transient SourceRecord inputRecord;
    public transient Collector<RowData> outputCollector;
    private boolean migrateAll;

    public AppendMetadataCollector(MetadataConverter[] metadataConverters, boolean migrateAll) {
        this.metadataConverters = metadataConverters;
        this.migrateAll = migrateAll;
    }

    public void collect(RowData physicalRow, TableChanges.TableChange tableSchema) {
        GenericRowData metaRow = new GenericRowData(this.metadataConverters.length);
        for (int i = 0; i < this.metadataConverters.length; ++i) {
            Object meta = this.metadataConverters[i].read(this.inputRecord, tableSchema, physicalRow);
            metaRow.setField(i, meta);
        }
        if (this.migrateAll) {
            physicalRow = new GenericRowData(0);
        }
        JoinedRowData outRow = new JoinedRowData(physicalRow.getRowKind(), physicalRow, (RowData)metaRow);
        this.outputCollector.collect((Object)outRow);
    }

    public void collect(RowData record) {
        this.collect(record, null);
    }

    public void close() {
    }
}

