/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.debezium.internal;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ThreadUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.json.JsonConverter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.WorkerConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.OffsetBackingStore;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.OffsetStorageWriter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util.Callback;
import io.debezium.embedded.EmbeddedEngine;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.debezium.internal.DebeziumOffset;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.debezium.internal.DebeziumOffsetSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkOffsetBackingStore
implements OffsetBackingStore {
    public static final String OFFSET_STATE_VALUE = "offset.storage.flink.state.value";
    public static final int FLUSH_TIMEOUT_SECONDS = 10;
    private static final Logger LOG = LoggerFactory.getLogger(FlinkOffsetBackingStore.class);
    protected Map<ByteBuffer, ByteBuffer> data = new HashMap<ByteBuffer, ByteBuffer>();
    protected ExecutorService executor;

    @Override
    public void configure(WorkerConfig config) {
        DebeziumOffset debeziumOffset;
        this.start();
        Map<String, Object> conf = config.originals();
        if (!conf.containsKey(OFFSET_STATE_VALUE)) {
            return;
        }
        String stateJson = (String)conf.get(OFFSET_STATE_VALUE);
        DebeziumOffsetSerializer serializer = new DebeziumOffsetSerializer();
        try {
            debeziumOffset = serializer.deserialize(stateJson.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            LOG.error("Can't deserialize debezium offset state from JSON: " + stateJson, (Throwable)e);
            throw new RuntimeException(e);
        }
        String engineName = (String)conf.get(EmbeddedEngine.ENGINE_NAME.name());
        JsonConverter keyConverter = new JsonConverter();
        JsonConverter valueConverter = new JsonConverter();
        keyConverter.configure(config.originals(), true);
        HashMap<String, Object> valueConfigs = new HashMap<String, Object>(conf);
        valueConfigs.put("schemas.enable", false);
        valueConverter.configure(valueConfigs, true);
        OffsetStorageWriter offsetWriter = new OffsetStorageWriter(this, engineName, keyConverter, valueConverter);
        offsetWriter.offset(debeziumOffset.sourcePartition, debeziumOffset.sourceOffset);
        if (!offsetWriter.beginFlush()) {
            LOG.warn("Initialize FlinkOffsetBackingStore from empty offset state, this shouldn't happen.");
            return;
        }
        Future<Void> flushFuture = offsetWriter.doFlush((error, result) -> {
            if (error != null) {
                LOG.error("Failed to flush initial offset.", error);
            } else {
                LOG.debug("Successfully flush initial offset.");
            }
        });
        try {
            flushFuture.get(10L, TimeUnit.SECONDS);
            LOG.info("Flush offsets successfully, partition: {}, offsets: {}", debeziumOffset.sourcePartition, debeziumOffset.sourceOffset);
        }
        catch (InterruptedException e) {
            LOG.warn("Flush offsets interrupted, cancelling.", (Throwable)e);
            offsetWriter.cancelFlush();
        }
        catch (ExecutionException e) {
            LOG.error("Flush offsets threw an unexpected exception.", (Throwable)e);
            offsetWriter.cancelFlush();
        }
        catch (TimeoutException e) {
            LOG.error("Timed out waiting to flush offsets to storage.", (Throwable)e);
            offsetWriter.cancelFlush();
        }
    }

    @Override
    public void start() {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(1, ThreadUtils.createThreadFactory(this.getClass().getSimpleName() + "-%d", false));
        }
    }

    @Override
    public void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.executor.shutdownNow().isEmpty()) {
                throw new ConnectException("Failed to stop FlinkOffsetBackingStore. Exiting without cleanly shutting down pending tasks and/or callbacks.");
            }
            this.executor = null;
        }
    }

    @Override
    public Future<Map<ByteBuffer, ByteBuffer>> get(Collection<ByteBuffer> keys) {
        return this.executor.submit(() -> {
            HashMap<ByteBuffer, ByteBuffer> result = new HashMap<ByteBuffer, ByteBuffer>();
            for (ByteBuffer key : keys) {
                result.put(key, this.data.get(key));
            }
            return result;
        });
    }

    @Override
    public Future<Void> set(Map<ByteBuffer, ByteBuffer> values, Callback<Void> callback) {
        return this.executor.submit(() -> {
            for (Map.Entry entry : values.entrySet()) {
                this.data.put((ByteBuffer)entry.getKey(), (ByteBuffer)entry.getValue());
            }
            if (callback != null) {
                callback.onCompletion(null, null);
            }
            return null;
        });
    }
}

