/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.metric.sub;

import com.ververica.cdc.connectors.shaded.com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.metrics.MetricGroup;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.metric.MetricOption;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.metric.MetricState;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.metric.SinkMetricData;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.metric.sub.SinkSubMetricData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkTableMetricData
extends SinkMetricData
implements SinkSubMetricData {
    public static final Logger LOGGER = LoggerFactory.getLogger(SinkTableMetricData.class);
    private final Map<String, SinkMetricData> subSinkMetricMap = Maps.newHashMap();

    public SinkTableMetricData(MetricOption option, MetricGroup metricGroup) {
        super(option, metricGroup);
    }

    public void registerSubMetricsGroup(MetricState metricState) {
        if (metricState == null) {
            return;
        }
        if (metricState.getSubMetricStateMap() == null) {
            return;
        }
        Map<String, MetricState> subMetricStateMap = metricState.getSubMetricStateMap();
        for (Map.Entry<String, MetricState> subMetricStateEntry : subMetricStateMap.entrySet()) {
            String[] schemaInfoArray = this.parseSchemaIdentify(subMetricStateEntry.getKey());
            MetricState subMetricState = subMetricStateEntry.getValue();
            SinkMetricData subSinkMetricData = this.buildSubSinkMetricData(schemaInfoArray, subMetricState, this);
            this.subSinkMetricMap.put(subMetricStateEntry.getKey(), subSinkMetricData);
        }
        LOGGER.info("register subMetricsGroup from metricState,sub metric map size:{}", (Object)this.subSinkMetricMap.size());
    }

    private SinkMetricData buildSubSinkMetricData(String[] schemaInfoArray, SinkMetricData sinkMetricData) {
        return this.buildSubSinkMetricData(schemaInfoArray, null, sinkMetricData);
    }

    private SinkMetricData buildSubSinkMetricData(String[] schemaInfoArray, MetricState subMetricState, SinkMetricData sinkMetricData) {
        if (sinkMetricData == null || schemaInfoArray == null) {
            return null;
        }
        Map<String, String> labels = sinkMetricData.getLabels();
        String metricGroupLabels = labels.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        StringBuilder labelBuilder = new StringBuilder(metricGroupLabels);
        if (schemaInfoArray.length == 2) {
            labelBuilder.append("&").append("database").append("=").append(schemaInfoArray[0]).append("&").append("table").append("=").append(schemaInfoArray[1]);
        } else if (schemaInfoArray.length == 3) {
            labelBuilder.append("&").append("database").append("=").append(schemaInfoArray[0]).append("&").append("schema").append("=").append(schemaInfoArray[1]).append("&").append("table").append("=").append(schemaInfoArray[2]);
        }
        MetricOption metricOption = MetricOption.builder().withInitRecords(subMetricState != null ? subMetricState.getMetricValue("numRecordsOut") : 0L).withInitBytes(subMetricState != null ? subMetricState.getMetricValue("numBytesOut") : 0L).withInitDirtyRecords(subMetricState != null ? subMetricState.getMetricValue("dirtyRecordsOut") : 0L).withInitDirtyBytes(subMetricState != null ? subMetricState.getMetricValue("dirtyBytesOut") : 0L).withInlongLabels(labelBuilder.toString()).withRegisterMetric(MetricOption.RegisteredMetric.ALL).build();
        return new SinkTableMetricData(metricOption, sinkMetricData.getMetricGroup());
    }

    public String buildSchemaIdentify(String database, String schema, String table) {
        if (schema == null) {
            return database + "." + table;
        }
        return database + "." + schema + "." + table;
    }

    public String[] parseSchemaIdentify(String schemaIdentify) {
        return schemaIdentify.split("\\.");
    }

    public void outputMetricsWithEstimate(String database, String schema, String table, Object data) {
        long rowCountSize = 1L;
        long rowDataSize = 0L;
        if (data != null) {
            rowDataSize = data.toString().getBytes(StandardCharsets.UTF_8).length;
        }
        this.outputMetrics(database, schema, table, rowCountSize, rowDataSize);
    }

    public void outputMetrics(String database, String schema, String table, long rowCount, long rowSize) {
        SinkMetricData subSinkMetricData;
        if (StringUtils.isBlank((CharSequence)database) || StringUtils.isBlank((CharSequence)table)) {
            this.invoke(rowCount, rowSize);
            return;
        }
        String identify = this.buildSchemaIdentify(database, schema, table);
        if (this.subSinkMetricMap.containsKey(identify)) {
            subSinkMetricData = this.subSinkMetricMap.get(identify);
        } else {
            subSinkMetricData = this.buildSubSinkMetricData(new String[]{database, schema, table}, this);
            this.subSinkMetricMap.put(identify, subSinkMetricData);
        }
        this.invoke(rowCount, rowSize);
        subSinkMetricData.invoke(rowCount, rowSize);
    }

    public void outputDirtyMetricsWithEstimate(String database, String table, long rowCount, long rowSize) {
        SinkMetricData subSinkMetricData;
        if (StringUtils.isBlank((CharSequence)database) || StringUtils.isBlank((CharSequence)table)) {
            this.invokeDirty(rowCount, rowSize);
            return;
        }
        String identify = this.buildSchemaIdentify(database, null, table);
        if (this.subSinkMetricMap.containsKey(identify)) {
            subSinkMetricData = this.subSinkMetricMap.get(identify);
        } else {
            subSinkMetricData = this.buildSubSinkMetricData(new String[]{database, table}, this);
            this.subSinkMetricMap.put(identify, subSinkMetricData);
        }
        this.invokeDirty(rowCount, rowSize);
        subSinkMetricData.invokeDirty(rowCount, rowSize);
    }

    public void outputMetricsWithEstimate(Object data) {
        long size = data.toString().getBytes(StandardCharsets.UTF_8).length;
        this.invoke(1L, size);
    }

    public void outputDirtyMetrics(String database, String schema, String table, long rowCount, long rowSize) {
        SinkMetricData subSinkMetricData;
        if (StringUtils.isBlank((CharSequence)database) || StringUtils.isBlank((CharSequence)table)) {
            this.invokeDirty(rowCount, rowSize);
            return;
        }
        String identify = this.buildSchemaIdentify(database, schema, table);
        if (this.subSinkMetricMap.containsKey(identify)) {
            subSinkMetricData = this.subSinkMetricMap.get(identify);
        } else {
            subSinkMetricData = this.buildSubSinkMetricData(new String[]{database, schema, table}, this);
            this.subSinkMetricMap.put(identify, subSinkMetricData);
        }
        this.invokeDirty(rowCount, rowSize);
        subSinkMetricData.invokeDirty(rowCount, rowSize);
    }

    public void outputDirtyMetricsWithEstimate(String database, String schema, String table, Object data) {
        long size = data == null ? 0L : (long)data.toString().getBytes(StandardCharsets.UTF_8).length;
        this.outputDirtyMetrics(database, schema, table, 1L, size);
    }

    public void outputDirtyMetricsWithEstimate(Object data) {
        long size = data.toString().getBytes(StandardCharsets.UTF_8).length;
        this.invokeDirty(1L, size);
    }

    @Override
    public Map<String, SinkMetricData> getSubSinkMetricMap() {
        return this.subSinkMetricMap;
    }

    @Override
    public String toString() {
        return "SinkTableMetricData{" + super.toString() + ",subSinkMetricMap=" + this.subSinkMetricMap + '}';
    }
}

