/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.metric;

import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.MeterView;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.Constants;

public interface MetricData {
    public MetricGroup getMetricGroup();

    public Map<String, String> getLabels();

    default public String getGroupId() {
        return this.getLabels().get("groupId");
    }

    default public String getStreamId() {
        return this.getLabels().get("streamId");
    }

    default public String getNodeId() {
        return this.getLabels().get("nodeId");
    }

    default public Counter registerCounter(String metricName, Counter counter) {
        MetricGroup inlongMetricGroup = this.getMetricGroup();
        for (Map.Entry<String, String> label : this.getLabels().entrySet()) {
            inlongMetricGroup = inlongMetricGroup.addGroup(label.getKey(), label.getValue());
        }
        return inlongMetricGroup.counter(metricName, counter);
    }

    default public Counter registerCounter(String metricName) {
        return this.registerCounter(metricName, (Counter)new SimpleCounter());
    }

    default public Meter registerMeter(String metricName, Counter counter) {
        MetricGroup inlongMetricGroup = this.getMetricGroup();
        for (Map.Entry<String, String> label : this.getLabels().entrySet()) {
            inlongMetricGroup = inlongMetricGroup.addGroup(label.getKey(), label.getValue());
        }
        return inlongMetricGroup.meter(metricName, (Meter)new MeterView(counter, Constants.TIME_SPAN_IN_SECONDS.intValue()));
    }
}

