/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.formats.common.TimestampFormat;
import org.apache.flink.shaded.guava18.com.google.common.collect.ImmutableMap;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.RowKind;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.format.AbstractDynamicSchemaFormat;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.format.JsonToRowDataConverters;

public abstract class JsonDynamicSchemaFormat
extends AbstractDynamicSchemaFormat<JsonNode> {
    private static final Integer FIRST = 0;
    private static final int DEFAULT_DECIMAL_PRECISION = 15;
    private static final int DEFAULT_DECIMAL_SCALE = 5;
    private static final Map<Integer, LogicalType> SQL_TYPE_2_FLINK_TYPE_MAPPING = ImmutableMap.builder().put(1, new CharType()).put(12, (CharType)new VarCharType()).put(5, (CharType)new SmallIntType()).put(4, (CharType)new IntType()).put(-5, (CharType)new BigIntType()).put(7, (CharType)new FloatType()).put(8, (CharType)new DoubleType()).put(6, (CharType)new FloatType()).put(3, (CharType)new DecimalType(15, 5)).put(2, (CharType)new DecimalType(15, 5)).put(-7, (CharType)new BooleanType()).put(92, (CharType)new TimeType()).put(2013, (CharType)new TimeType()).put(2014, (CharType)new LocalZonedTimestampType()).put(93, (CharType)new TimestampType()).put(-2, (CharType)new BinaryType()).put(-3, (CharType)new VarBinaryType()).put(2004, (CharType)new VarBinaryType()).put(2005, (CharType)new VarBinaryType()).put(91, (CharType)new DateType()).put(16, (CharType)new BooleanType()).put(-16, (CharType)new VarCharType()).put(-4, (CharType)new VarCharType()).put(-1, (CharType)new VarCharType()).put(2003, (CharType)new VarCharType()).put(-15, new CharType()).put(2011, (CharType)new VarBinaryType()).put(-6, (CharType)new TinyIntType()).put(1111, (CharType)new VarCharType()).build();
    private static final Map<Integer, LogicalType> SQL_TYPE_2_SPARK_SUPPORTED_FLINK_TYPE_MAPPING = ImmutableMap.builder().put(1, new CharType()).put(12, (CharType)new VarCharType()).put(5, (CharType)new SmallIntType()).put(4, (CharType)new IntType()).put(-5, (CharType)new BigIntType()).put(7, (CharType)new FloatType()).put(8, (CharType)new DoubleType()).put(6, (CharType)new FloatType()).put(3, (CharType)new DecimalType(15, 5)).put(2, (CharType)new DecimalType(15, 5)).put(-7, (CharType)new BooleanType()).put(92, (CharType)new VarCharType()).put(2014, (CharType)new LocalZonedTimestampType()).put(93, (CharType)new LocalZonedTimestampType()).put(-2, (CharType)new BinaryType()).put(-3, (CharType)new VarBinaryType()).put(2004, (CharType)new VarBinaryType()).put(91, (CharType)new DateType()).put(16, (CharType)new BooleanType()).put(1111, (CharType)new VarCharType()).build();
    public final ObjectMapper objectMapper = new ObjectMapper();
    protected final JsonToRowDataConverters rowDataConverters;
    protected final boolean adaptSparkEngine;

    public JsonDynamicSchemaFormat(Map<String, String> properties) {
        Configuration config = Configuration.fromMap(properties);
        this.adaptSparkEngine = (Boolean)config.get(Constants.SINK_MULTIPLE_TYPE_MAP_COMPATIBLE_WITH_SPARK);
        this.rowDataConverters = new JsonToRowDataConverters(false, false, TimestampFormat.ISO_8601, this.adaptSparkEngine);
    }

    @Override
    public List<String> extractValues(JsonNode root, String ... keys) {
        if (keys == null || keys.length == 0) {
            return new ArrayList<String>();
        }
        JsonNode physicalNode = this.getPhysicalData(root);
        if (physicalNode.isArray()) {
            physicalNode = physicalNode.get(FIRST.intValue());
        }
        ArrayList<String> values = new ArrayList<String>(keys.length);
        if (physicalNode == null) {
            for (String key : keys) {
                values.add(this.extract(root, key));
            }
            return values;
        }
        for (String key : keys) {
            String value = this.extract(physicalNode, key);
            if (value == null) {
                value = this.extract(root, key);
            }
            values.add(value);
        }
        return values;
    }

    @Override
    public String extract(JsonNode jsonNode, String key) {
        if (jsonNode == null || key == null) {
            return null;
        }
        JsonNode value = jsonNode.get(key);
        if (value != null) {
            return value.asText();
        }
        int index = key.indexOf(".");
        if (index > 0 && index + 1 < key.length()) {
            return this.extract(jsonNode.get(key.substring(0, index)), key.substring(index + 1));
        }
        return null;
    }

    @Override
    public JsonNode deserialize(byte[] message) throws IOException {
        return this.objectMapper.readTree(message);
    }

    @Override
    public String parse(byte[] message, String pattern) throws IOException {
        return this.parse(this.deserialize(message), pattern);
    }

    @Override
    public String parse(JsonNode rootNode, String pattern) throws IOException {
        Matcher matcher = PATTERN.matcher(pattern);
        StringBuffer sb = new StringBuffer();
        JsonNode physicalNode = this.getPhysicalData(rootNode);
        if (physicalNode.isArray()) {
            physicalNode = physicalNode.get(FIRST.intValue());
        }
        while (matcher.find()) {
            String keyText = matcher.group(1);
            String replacement = this.extract(physicalNode, keyText);
            if (replacement == null) {
                replacement = this.extract(rootNode, keyText);
            }
            if (replacement == null) {
                throw new IOException(String.format("Can't find value for key: %s", keyText));
            }
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public JsonNode getPhysicalData(JsonNode root) {
        JsonNode physicalData = this.getUpdateAfter(root);
        if (physicalData == null) {
            physicalData = this.getUpdateBefore(root);
        }
        return physicalData;
    }

    public abstract JsonNode getUpdateAfter(JsonNode var1);

    public abstract JsonNode getUpdateBefore(JsonNode var1);

    public abstract List<RowKind> opType2RowKind(String var1);

    public abstract String getOpType(JsonNode var1);

    protected RowType extractSchemaNode(JsonNode schema, List<String> pkNames) {
        Iterator schemaFields = schema.fields();
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        while (schemaFields.hasNext()) {
            Map.Entry entry = (Map.Entry)schemaFields.next();
            String name = (String)entry.getKey();
            LogicalType type = this.sqlType2FlinkType(((JsonNode)entry.getValue()).asInt());
            if (pkNames.contains(name)) {
                type = type.copy(false);
            }
            fields.add(new RowType.RowField(name, type));
        }
        return new RowType(fields);
    }

    private LogicalType sqlType2FlinkType(int jdbcType) {
        Map<Integer, LogicalType> typeMap;
        Map<Integer, LogicalType> map = typeMap = this.adaptSparkEngine ? SQL_TYPE_2_SPARK_SUPPORTED_FLINK_TYPE_MAPPING : SQL_TYPE_2_FLINK_TYPE_MAPPING;
        if (typeMap.containsKey(jdbcType)) {
            return typeMap.get(jdbcType);
        }
        throw new IllegalArgumentException("Unsupported jdbcType: " + jdbcType);
    }

    public List<Map<String, String>> jsonNode2Map(JsonNode data) throws IOException {
        if (data == null) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> values = new ArrayList<Map<String, String>>();
        if (data.isArray()) {
            for (int i = 0; i < data.size(); ++i) {
                values.add((Map<String, String>)this.objectMapper.convertValue((Object)data.get(i), (TypeReference)new TypeReference<Map<String, String>>(){}));
            }
        } else {
            values.add((Map<String, String>)this.objectMapper.convertValue((Object)data, (TypeReference)new TypeReference<Map<String, String>>(){}));
        }
        return values;
    }
}

