/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.dirty.sink.s3;

import com.amazonaws.services.s3.AmazonS3;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.dirty.sink.s3.S3DirtySink;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.base.dirty.sink.s3.S3Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3Helper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(S3DirtySink.class);
    private static final DateTimeFormatter DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final int SEQUENCE_LENGTH = 4;
    private static final String ESCAPE_PATTERN = "[\uff0c,+=: ;()\uff08\uff09\u3002/.\uff1b]";
    private static final String FILE_NAME_SUFFIX = ".txt";
    private final Random r = new Random();
    private final AmazonS3 s3Client;
    private final S3Options s3Options;

    S3Helper(AmazonS3 s3Client, S3Options s3Options) {
        this.s3Client = s3Client;
        this.s3Options = s3Options;
    }

    public void upload(String identifier, String content) throws IOException {
        String path = this.genFileName(identifier);
        for (int i = 0; i < this.s3Options.getMaxRetries(); ++i) {
            try {
                this.s3Client.putObject(this.s3Options.getBucket(), path, content);
                break;
            }
            catch (Exception e) {
                LOG.error("s3 dirty sink error, retry times = {}", (Object)i, (Object)e);
                if (i >= this.s3Options.getMaxRetries()) {
                    throw new IOException(e);
                }
                try {
                    Thread.sleep(1000L * (long)i);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException("unable to flush; interrupted while doing another attempt", e);
                }
            }
        }
    }

    private String genFileName(String identifier) {
        return String.format("%s/%s-%s%s", this.s3Options.getKey(), identifier.replaceAll(ESCAPE_PATTERN, ""), this.generateSequence(), FILE_NAME_SUFFIX);
    }

    private String generateSequence() {
        StringBuilder sb = new StringBuilder(DATE_TIME_FORMAT.format(LocalDateTime.now()));
        for (int i = 0; i < 4; ++i) {
            sb.append(this.r.nextInt(10));
        }
        return sb.toString();
    }
}

