/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.debezium.reader;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import org.apache.flink.shaded.guava18.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.inlong.sort.cdc.mysql.debezium.reader.DebeziumReader;
import org.apache.inlong.sort.cdc.mysql.debezium.task.MySqlBinlogSplitReadTask;
import org.apache.inlong.sort.cdc.mysql.debezium.task.context.StatefulTaskContext;
import org.apache.inlong.sort.cdc.mysql.source.offset.BinlogOffset;
import org.apache.inlong.sort.cdc.mysql.source.split.FinishedSnapshotSplitInfo;
import org.apache.inlong.sort.cdc.mysql.source.split.MySqlBinlogSplit;
import org.apache.inlong.sort.cdc.mysql.source.split.MySqlSplit;
import org.apache.inlong.sort.cdc.mysql.source.utils.ChunkUtils;
import org.apache.inlong.sort.cdc.mysql.source.utils.RecordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinlogSplitReader
implements DebeziumReader<SourceRecord, MySqlSplit> {
    private static final Logger LOG = LoggerFactory.getLogger(BinlogSplitReader.class);
    private final StatefulTaskContext statefulTaskContext;
    private final ExecutorService executor;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile boolean currentTaskRunning;
    private volatile Throwable readException;
    private MySqlBinlogSplitReadTask binlogSplitReadTask;
    private MySqlBinlogSplit currentBinlogSplit;
    private Map<TableId, List<FinishedSnapshotSplitInfo>> finishedSplitsInfo;
    private Map<TableId, BinlogOffset> maxSplitHighWatermarkMap;
    private Tables.TableFilter capturedTableFilter;

    public BinlogSplitReader(StatefulTaskContext statefulTaskContext, int subTaskId) {
        this.statefulTaskContext = statefulTaskContext;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("debezium-reader-" + subTaskId).build();
        this.executor = Executors.newSingleThreadExecutor(threadFactory);
        this.currentTaskRunning = true;
    }

    @Override
    public void submitSplit(MySqlSplit mySqlSplit) {
        this.currentBinlogSplit = mySqlSplit.asBinlogSplit();
        this.configureFilter();
        this.statefulTaskContext.configure(this.currentBinlogSplit);
        this.capturedTableFilter = this.statefulTaskContext.getConnectorConfig().getTableFilters().dataCollectionFilter();
        this.queue = this.statefulTaskContext.getQueue();
        MySqlOffsetContext mySqlOffsetContext = this.statefulTaskContext.getOffsetContext();
        this.binlogSplitReadTask = new MySqlBinlogSplitReadTask(this.statefulTaskContext.getConnectorConfig(), mySqlOffsetContext, this.statefulTaskContext.getConnection(), this.statefulTaskContext.getDispatcher(), this.statefulTaskContext.getErrorHandler(), StatefulTaskContext.getClock(), this.statefulTaskContext.getTaskContext(), (MySqlStreamingChangeEventSourceMetrics)this.statefulTaskContext.getStreamingChangeEventSourceMetrics(), this.statefulTaskContext.getTopicSelector().getPrimaryTopic(), this.currentBinlogSplit);
        this.executor.submit(() -> {
            try {
                this.binlogSplitReadTask.execute(new BinlogSplitChangeEventSourceContextImpl());
            }
            catch (Exception e) {
                this.currentTaskRunning = false;
                LOG.error(String.format("Execute binlog read task for mysql split %s fail", this.currentBinlogSplit), (Throwable)e);
                this.readException = e;
            }
        });
    }

    @Override
    public boolean isFinished() {
        return this.currentBinlogSplit == null || !this.currentTaskRunning;
    }

    @Override
    @Nullable
    public Iterator<SourceRecord> pollSplitRecords() throws InterruptedException {
        this.checkReadException();
        ArrayList<SourceRecord> sourceRecords = new ArrayList<SourceRecord>();
        if (this.currentTaskRunning) {
            List<DataChangeEvent> batch = this.queue.poll();
            for (DataChangeEvent event : batch) {
                if (!this.shouldEmit(event.getRecord())) continue;
                sourceRecords.add(event.getRecord());
            }
            return sourceRecords.iterator();
        }
        return null;
    }

    private void checkReadException() {
        if (this.readException != null) {
            throw new FlinkRuntimeException(String.format("Read split %s error due to %s.", this.currentBinlogSplit, this.readException.getMessage()), this.readException);
        }
    }

    @Override
    public void close() {
        try {
            if (this.statefulTaskContext.getConnection() != null) {
                this.statefulTaskContext.getConnection().close();
            }
            if (this.statefulTaskContext.getBinaryLogClient() != null) {
                this.statefulTaskContext.getBinaryLogClient().disconnect();
            }
        }
        catch (Exception e) {
            LOG.error("Close binlog reader error", (Throwable)e);
        }
    }

    private boolean shouldEmit(SourceRecord sourceRecord) {
        if (RecordUtils.isDataChangeRecord(sourceRecord)) {
            BinlogOffset position;
            TableId tableId = RecordUtils.getTableId(sourceRecord);
            if (this.hasEnterPureBinlogPhase(tableId, position = RecordUtils.getBinlogPosition(sourceRecord)) || sourceRecord.key() == null) {
                return true;
            }
            if (this.finishedSplitsInfo.containsKey(tableId)) {
                RowType splitKeyType = ChunkUtils.getSplitType(this.statefulTaskContext.getDatabaseSchema().tableFor(tableId));
                Object[] key = RecordUtils.getSplitKey(splitKeyType, sourceRecord, this.statefulTaskContext.getSchemaNameAdjuster());
                for (FinishedSnapshotSplitInfo splitInfo : this.finishedSplitsInfo.get(tableId)) {
                    if (!RecordUtils.splitKeyRangeContains(key, splitInfo.getSplitStart(), splitInfo.getSplitEnd()) || !position.isAfter(splitInfo.getHighWatermark())) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean hasEnterPureBinlogPhase(TableId tableId, BinlogOffset position) {
        if (this.maxSplitHighWatermarkMap.containsKey(tableId) && position.isAtOrAfter(this.maxSplitHighWatermarkMap.get(tableId))) {
            return true;
        }
        return !this.maxSplitHighWatermarkMap.containsKey(tableId) && this.capturedTableFilter.isIncluded(tableId);
    }

    private void configureFilter() {
        List<FinishedSnapshotSplitInfo> finishedSplitInfos = this.currentBinlogSplit.getFinishedSnapshotSplitInfos();
        HashMap<TableId, List<FinishedSnapshotSplitInfo>> splitsInfoMap = new HashMap<TableId, List<FinishedSnapshotSplitInfo>>();
        HashMap<TableId, BinlogOffset> tableIdBinlogPositionMap = new HashMap<TableId, BinlogOffset>();
        if (finishedSplitInfos.isEmpty()) {
            for (TableId tableId : this.currentBinlogSplit.getTableSchemas().keySet()) {
                tableIdBinlogPositionMap.put(tableId, this.currentBinlogSplit.getStartingOffset());
            }
        } else {
            for (FinishedSnapshotSplitInfo finishedSplitInfo : finishedSplitInfos) {
                TableId tableId = finishedSplitInfo.getTableId();
                List list = splitsInfoMap.getOrDefault(tableId, new ArrayList());
                list.add(finishedSplitInfo);
                splitsInfoMap.put(tableId, list);
                BinlogOffset highWatermark = finishedSplitInfo.getHighWatermark();
                BinlogOffset maxHighWatermark = (BinlogOffset)tableIdBinlogPositionMap.get(tableId);
                if (maxHighWatermark != null && !highWatermark.isAfter(maxHighWatermark)) continue;
                tableIdBinlogPositionMap.put(tableId, highWatermark);
            }
        }
        this.finishedSplitsInfo = splitsInfoMap;
        this.maxSplitHighWatermarkMap = tableIdBinlogPositionMap;
    }

    public void stopBinlogReadTask() {
        this.currentTaskRunning = false;
    }

    private class BinlogSplitChangeEventSourceContextImpl
    implements ChangeEventSource.ChangeEventSourceContext {
        private BinlogSplitChangeEventSourceContextImpl() {
        }

        @Override
        public boolean isRunning() {
            return BinlogSplitReader.this.currentTaskRunning;
        }
    }
}

