/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql.debezium;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlDatabaseSchema;
import io.debezium.connector.mysql.MySqlTopicSelector;
import io.debezium.connector.mysql.MySqlValueConverters;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.inlong.sort.cdc.mysql.source.config.MySqlSourceConfig;
import org.apache.inlong.sort.cdc.mysql.source.connection.JdbcConnectionFactory;
import org.apache.inlong.sort.cdc.mysql.source.offset.BinlogOffset;
import org.apache.inlong.sort.cdc.mysql.source.utils.TableDiscoveryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebeziumUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DebeziumUtils.class);

    public static JdbcConnection openJdbcConnection(MySqlSourceConfig sourceConfig) {
        JdbcConnection jdbc = new JdbcConnection(sourceConfig.getDbzConfiguration(), new JdbcConnectionFactory(sourceConfig));
        try {
            jdbc.connect();
        }
        catch (Exception e) {
            LOG.error("Failed to open MySQL connection", (Throwable)e);
            throw new FlinkRuntimeException((Throwable)e);
        }
        return jdbc;
    }

    public static MySqlConnection createMySqlConnection(MySqlSourceConfig sourceConfig) {
        return new MySqlConnection(new MySqlConnection.MySqlConnectionConfiguration(sourceConfig.getDbzConfiguration()));
    }

    public static MySqlConnection createMySqlConnection(Configuration dbzConfiguration) {
        return new MySqlConnection(new MySqlConnection.MySqlConnectionConfiguration(dbzConfiguration));
    }

    public static BinaryLogClient createBinaryClient(Configuration dbzConfiguration) {
        MySqlConnectorConfig connectorConfig = new MySqlConnectorConfig(dbzConfiguration);
        return new BinaryLogClient(connectorConfig.hostname(), connectorConfig.port(), connectorConfig.username(), connectorConfig.password());
    }

    public static MySqlDatabaseSchema createMySqlDatabaseSchema(MySqlConnectorConfig dbzMySqlConfig, boolean isTableIdCaseSensitive) {
        TopicSelector<TableId> topicSelector = MySqlTopicSelector.defaultSelector(dbzMySqlConfig);
        SchemaNameAdjuster schemaNameAdjuster = SchemaNameAdjuster.create();
        MySqlValueConverters valueConverters = DebeziumUtils.getValueConverters(dbzMySqlConfig);
        return new MySqlDatabaseSchema(dbzMySqlConfig, valueConverters, topicSelector, schemaNameAdjuster, isTableIdCaseSensitive);
    }

    public static BinlogOffset currentBinlogOffset(JdbcConnection jdbc) {
        String showMasterStmt = "SHOW MASTER STATUS";
        try {
            return jdbc.queryAndMap("SHOW MASTER STATUS", rs -> {
                if (rs.next()) {
                    String binlogFilename = rs.getString(1);
                    long binlogPosition = rs.getLong(2);
                    String gtidSet = rs.getMetaData().getColumnCount() > 4 ? rs.getString(5) : null;
                    return new BinlogOffset(binlogFilename, binlogPosition, 0L, 0L, 0L, gtidSet, null);
                }
                throw new FlinkRuntimeException("Cannot read the binlog filename and position via 'SHOW MASTER STATUS'. Make sure your server is correctly configured");
            });
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Cannot read the binlog filename and position via 'SHOW MASTER STATUS'. Make sure your server is correctly configured", (Throwable)e);
        }
    }

    private static MySqlValueConverters getValueConverters(MySqlConnectorConfig dbzMySqlConfig) {
        TemporalPrecisionMode timePrecisionMode = dbzMySqlConfig.getTemporalPrecisionMode();
        JdbcValueConverters.DecimalMode decimalMode = dbzMySqlConfig.getDecimalMode();
        String bigIntUnsignedHandlingModeStr = dbzMySqlConfig.getConfig().getString(MySqlConnectorConfig.BIGINT_UNSIGNED_HANDLING_MODE);
        MySqlConnectorConfig.BigIntUnsignedHandlingMode bigIntUnsignedHandlingMode = MySqlConnectorConfig.BigIntUnsignedHandlingMode.parse(bigIntUnsignedHandlingModeStr);
        JdbcValueConverters.BigIntUnsignedMode bigIntUnsignedMode = bigIntUnsignedHandlingMode.asBigIntUnsignedMode();
        boolean timeAdjusterEnabled = dbzMySqlConfig.getConfig().getBoolean(MySqlConnectorConfig.ENABLE_TIME_ADJUSTER);
        return new MySqlValueConverters(decimalMode, timePrecisionMode, bigIntUnsignedMode, dbzMySqlConfig.binaryHandlingMode(), timeAdjusterEnabled ? MySqlValueConverters::adjustTemporal : x -> x, MySqlValueConverters::defaultParsingErrorHandler);
    }

    public static List<TableId> discoverCapturedTables(JdbcConnection jdbc, MySqlSourceConfig sourceConfig) {
        List<TableId> capturedTableIds;
        try {
            capturedTableIds = TableDiscoveryUtils.listTables(jdbc, sourceConfig.getTableFilters());
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Failed to discover captured tables", (Throwable)e);
        }
        if (capturedTableIds.isEmpty()) {
            throw new IllegalArgumentException(String.format("Can't find any matched tables, please check your configured database-name: %s and table-name: %s", sourceConfig.getDatabaseList(), sourceConfig.getTableList()));
        }
        return capturedTableIds;
    }

    public static boolean isTableIdCaseSensitive(JdbcConnection connection) {
        return !"0".equals(DebeziumUtils.readMySqlSystemVariables(connection).get("lower_case_table_names"));
    }

    public static Map<String, String> readMySqlSystemVariables(JdbcConnection connection) {
        return DebeziumUtils.querySystemVariables(connection, "SHOW VARIABLES");
    }

    private static Map<String, String> querySystemVariables(JdbcConnection connection, String statement) {
        HashMap<String, String> variables = new HashMap<String, String>();
        try {
            connection.query(statement, rs -> {
                while (rs.next()) {
                    String varName = rs.getString(1);
                    String value = rs.getString(2);
                    if (varName == null || value == null) continue;
                    variables.put(varName, value);
                }
            });
        }
        catch (SQLException e) {
            throw new FlinkRuntimeException("Error reading MySQL variables: " + e.getMessage(), (Throwable)e);
        }
        return variables;
    }

    public static RelationalTableFilters createTableFilters(MySqlSourceConfig configuration) {
        Configuration debeziumConfig = configuration.getDbzConfiguration();
        MySqlConnectorConfig mySqlConnectorConfig = new MySqlConnectorConfig(debeziumConfig);
        return mySqlConnectorConfig.getTableFilters();
    }
}

