/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.relational.history.TableChanges;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.util.Collector;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.debezium.DebeziumDeserializationSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeekBinlogToTimestampFilter<T>
implements DebeziumDeserializationSchema<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(SeekBinlogToTimestampFilter.class);
    private static final long serialVersionUID = -4450118969976653497L;
    private final long startupTimestampMillis;
    private final DebeziumDeserializationSchema<T> serializer;
    private transient boolean find = false;
    private transient long filtered = 0L;

    public SeekBinlogToTimestampFilter(long startupTimestampMillis, DebeziumDeserializationSchema<T> serializer) {
        this.startupTimestampMillis = startupTimestampMillis;
        this.serializer = serializer;
    }

    @Override
    public void deserialize(SourceRecord record, Collector<T> out) throws Exception {
        Struct value;
        Struct source;
        Long ts;
        if (this.find) {
            this.serializer.deserialize(record, out);
            return;
        }
        if (this.filtered == 0L) {
            LOG.info("Begin to seek binlog to the specific timestamp {}.", (Object)this.startupTimestampMillis);
        }
        if ((ts = (source = (value = (Struct)record.value()).getStruct("source")).getInt64("ts_ms")) != null && ts >= this.startupTimestampMillis) {
            this.serializer.deserialize(record, out);
            this.find = true;
            LOG.info("Successfully seek to the specific timestamp {} with filtered {} change events.", (Object)this.startupTimestampMillis, (Object)this.filtered);
        } else {
            ++this.filtered;
            if (this.filtered % 10000L == 0L) {
                LOG.info("Seeking binlog to specific timestamp with filtered {} change events.", (Object)this.filtered);
            }
        }
    }

    @Override
    public void deserialize(SourceRecord record, Collector<T> out, TableChanges.TableChange tableChange) throws Exception {
    }

    public TypeInformation<T> getProducedType() {
        return this.serializer.getProducedType();
    }
}

