/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.cdc.mysql;

import io.debezium.connector.mysql.MySqlConnector;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.cdc.debezium.DebeziumSourceFunction;
import org.apache.inlong.sort.cdc.mysql.MySqlValidator;
import org.apache.inlong.sort.cdc.mysql.SeekBinlogToTimestampFilter;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.debezium.DebeziumDeserializationSchema;
import org.apache.inlong.sort.cdc.mysql.shaded.org.apache.inlong.sort.cdc.base.debezium.internal.DebeziumOffset;
import org.apache.inlong.sort.cdc.mysql.table.StartupOptions;

@Deprecated
public class MySqlSource {
    private static final String DATABASE_SERVER_NAME = "mysql_binlog_source";

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Deprecated
    public static class Builder<T> {
        private int port = 3306;
        private String hostname;
        private String[] databaseList;
        private String username;
        private String password;
        private Integer serverId;
        private String serverTimeZone;
        private String[] tableList;
        private Properties dbzProperties;
        private StartupOptions startupOptions = StartupOptions.initial();
        private DebeziumDeserializationSchema<T> deserializer;
        private String inlongMetric;
        private String inlongAudit;
        private boolean migrateAll;

        public Builder<T> hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> databaseList(String ... databaseList) {
            this.databaseList = databaseList;
            return this;
        }

        public Builder<T> tableList(String ... tableList) {
            this.tableList = tableList;
            return this;
        }

        public Builder<T> username(String username) {
            this.username = username;
            return this;
        }

        public Builder<T> password(String password) {
            this.password = password;
            return this;
        }

        public Builder<T> serverTimeZone(String timeZone) {
            this.serverTimeZone = timeZone;
            return this;
        }

        public Builder<T> serverId(int serverId) {
            this.serverId = serverId;
            return this;
        }

        public Builder<T> debeziumProperties(Properties properties) {
            this.dbzProperties = properties;
            return this;
        }

        public Builder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public Builder<T> startupOptions(StartupOptions startupOptions) {
            this.startupOptions = startupOptions;
            return this;
        }

        public Builder<T> inlongMetric(String inlongMetric) {
            this.inlongMetric = inlongMetric;
            return this;
        }

        public Builder<T> inlongAudit(String inlongAudit) {
            this.inlongAudit = inlongAudit;
            return this;
        }

        public Builder<T> migrateAll(boolean migrateAll) {
            this.migrateAll = migrateAll;
            return this;
        }

        public DebeziumSourceFunction<T> build() {
            Properties props = new Properties();
            props.setProperty("connector.class", MySqlConnector.class.getCanonicalName());
            props.setProperty("database.server.name", MySqlSource.DATABASE_SERVER_NAME);
            props.setProperty("database.hostname", (String)Preconditions.checkNotNull((Object)this.hostname));
            props.setProperty("database.user", (String)Preconditions.checkNotNull((Object)this.username));
            props.setProperty("database.password", (String)Preconditions.checkNotNull((Object)this.password));
            props.setProperty("database.port", String.valueOf(this.port));
            props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
            props.put("bigint.unsigned.handling.mode", "precise");
            if (this.serverId != null) {
                props.setProperty("database.server.id", String.valueOf(this.serverId));
            }
            if (this.databaseList != null) {
                props.setProperty("database.whitelist", String.join((CharSequence)",", this.databaseList));
            }
            if (this.tableList != null) {
                props.setProperty("table.whitelist", String.join((CharSequence)",", this.tableList));
            }
            if (this.serverTimeZone != null) {
                props.setProperty("database.serverTimezone", this.serverTimeZone);
            }
            DebeziumOffset specificOffset = null;
            switch (this.startupOptions.startupMode) {
                case INITIAL: {
                    props.setProperty("snapshot.mode", "initial");
                    break;
                }
                case EARLIEST_OFFSET: {
                    props.setProperty("snapshot.mode", "never");
                    break;
                }
                case LATEST_OFFSET: {
                    props.setProperty("snapshot.mode", "schema_only");
                    break;
                }
                case SPECIFIC_OFFSETS: {
                    props.setProperty("snapshot.mode", "schema_only_recovery");
                    specificOffset = new DebeziumOffset();
                    HashMap<String, String> sourcePartition = new HashMap<String, String>();
                    sourcePartition.put("server", MySqlSource.DATABASE_SERVER_NAME);
                    specificOffset.setSourcePartition(sourcePartition);
                    HashMap<String, Object> sourceOffset = new HashMap<String, Object>();
                    sourceOffset.put("file", this.startupOptions.specificOffsetFile);
                    sourceOffset.put("pos", this.startupOptions.specificOffsetPos);
                    specificOffset.setSourceOffset(sourceOffset);
                    break;
                }
                case TIMESTAMP: {
                    Preconditions.checkNotNull(this.deserializer);
                    props.setProperty("snapshot.mode", "never");
                    this.deserializer = new SeekBinlogToTimestampFilter<T>(this.startupOptions.startupTimestampMillis, this.deserializer);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (this.dbzProperties != null) {
                props.putAll((Map<?, ?>)this.dbzProperties);
                if ("legacy".equals(this.dbzProperties.get("internal.implementation"))) {
                    props.put("transforms", "snapshotasinsert");
                    props.put("transforms.snapshotasinsert.type", "io.debezium.connector.mysql.transforms.ReadToInsertEvent");
                }
            }
            return new DebeziumSourceFunction<T>(this.deserializer, props, specificOffset, new MySqlValidator(props), this.inlongMetric, this.inlongAudit, this.migrateAll);
        }
    }
}

