/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.fault;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.databind.node.TextNode;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.internals.KafkaFutureImpl;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.common.Platform;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.fault.Kibosh;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.task.TaskWorker;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.task.WorkerStatusTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiboshFaultWorker
implements TaskWorker {
    private static final Logger log = LoggerFactory.getLogger(KiboshFaultWorker.class);
    private final String id;
    private final Kibosh.KiboshFaultSpec spec;
    private final String mountPath;
    private WorkerStatusTracker status;

    public KiboshFaultWorker(String id, Kibosh.KiboshFaultSpec spec, String mountPath) {
        this.id = id;
        this.spec = spec;
        this.mountPath = mountPath;
    }

    @Override
    public void start(Platform platform, WorkerStatusTracker status, KafkaFutureImpl<String> errorFuture) throws Exception {
        log.info("Activating {} {}: {}.", new Object[]{this.spec.getClass().getSimpleName(), this.id, this.spec});
        this.status = status;
        this.status.update(new TextNode("Adding fault " + this.id));
        Kibosh.INSTANCE.addFault(this.mountPath, this.spec);
        this.status.update(new TextNode("Added fault " + this.id));
    }

    @Override
    public void stop(Platform platform) throws Exception {
        log.info("Deactivating {} {}: {}.", new Object[]{this.spec.getClass().getSimpleName(), this.id, this.spec});
        this.status.update(new TextNode("Removing fault " + this.id));
        Kibosh.INSTANCE.removeFault(this.mountPath, this.spec);
        this.status.update(new TextNode("Removed fault " + this.id));
    }
}

