/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.TopicPartition;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.VoteResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class VoteResponse
extends AbstractResponse {
    public final VoteResponseData data;

    public VoteResponse(VoteResponseData data) {
        this.data = data;
    }

    public VoteResponse(Struct struct, short version) {
        this.data = new VoteResponseData(struct, version);
    }

    public VoteResponse(Struct struct) {
        short latestVersion = (short)(VoteResponseData.SCHEMAS.length - 1);
        this.data = new VoteResponseData(struct, latestVersion);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public static VoteResponseData singletonResponse(Errors topLevelError, TopicPartition topicPartition, Errors partitionLevelError, int leaderEpoch, int leaderId, boolean voteGranted) {
        return new VoteResponseData().setErrorCode(topLevelError.code()).setTopics(Collections.singletonList(new VoteResponseData.TopicData().setTopicName(topicPartition.topic()).setPartitions(Collections.singletonList(new VoteResponseData.PartitionData().setErrorCode(partitionLevelError.code()).setLeaderId(leaderId).setLeaderEpoch(leaderEpoch).setVoteGranted(voteGranted)))));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errors = new HashMap<Errors, Integer>();
        Errors topLevelError = Errors.forCode(this.data.errorCode());
        if (topLevelError != Errors.NONE) {
            errors.put(topLevelError, 1);
        }
        for (VoteResponseData.TopicData topicResponse : this.data.topics()) {
            for (VoteResponseData.PartitionData partitionResponse : topicResponse.partitions()) {
                errors.compute(Errors.forCode(partitionResponse.errorCode()), (error, count) -> count == null ? 1 : count + 1);
            }
        }
        return errors;
    }

    public static VoteResponse parse(ByteBuffer buffer, short version) {
        return new VoteResponse(ApiKeys.VOTE.responseSchema(version).read(buffer), version);
    }
}

