/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Readable;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.BaseRecords;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.record.MemoryRecords;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.ByteUtils;
import java.nio.ByteBuffer;

public class RecordsReadable
implements Readable {
    private final ByteBuffer buf;

    public RecordsReadable(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public byte readByte() {
        return this.buf.get();
    }

    @Override
    public short readShort() {
        return this.buf.getShort();
    }

    @Override
    public int readInt() {
        return this.buf.getInt();
    }

    @Override
    public long readLong() {
        return this.buf.getLong();
    }

    @Override
    public double readDouble() {
        return ByteUtils.readDouble(this.buf);
    }

    @Override
    public void readArray(byte[] arr) {
        this.buf.get(arr);
    }

    @Override
    public int readUnsignedVarint() {
        return ByteUtils.readUnsignedVarint(this.buf);
    }

    @Override
    public ByteBuffer readByteBuffer(int length) {
        ByteBuffer res = this.buf.slice();
        res.limit(length);
        this.buf.position(this.buf.position() + length);
        return res;
    }

    public BaseRecords readRecords(int length) {
        if (length < 0) {
            return null;
        }
        ByteBuffer recordsBuffer = this.readByteBuffer(length);
        return MemoryRecords.readableRecords(recordsBuffer);
    }
}

