/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.utils;

import com.ververica.cdc.connectors.mysql.debezium.dispatcher.SignalEventDispatcher;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSnapshotSplit;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.data.Envelope;
import io.debezium.document.DocumentReader;
import io.debezium.relational.TableId;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.util.SchemaNameAdjuster;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

public class RecordUtils {
    public static final String SCHEMA_CHANGE_EVENT_KEY_NAME = "io.debezium.connector.mysql.SchemaChangeKey";
    public static final String SCHEMA_HEARTBEAT_EVENT_KEY_NAME = "io.debezium.connector.common.Heartbeat";
    private static final DocumentReader DOCUMENT_READER = DocumentReader.defaultReader();

    private RecordUtils() {
    }

    public static Object[] rowToArray(ResultSet rs, int size) throws SQLException {
        Object[] row = new Object[size];
        for (int i = 0; i < size; ++i) {
            row[i] = rs.getObject(i + 1);
        }
        return row;
    }

    public static List<SourceRecord> normalizedSplitRecords(MySqlSnapshotSplit snapshotSplit, List<SourceRecord> sourceRecords, SchemaNameAdjuster nameAdjuster) {
        List<SourceRecord> normalizedRecords = new ArrayList<SourceRecord>();
        HashMap<Struct, SourceRecord> snapshotRecords = new HashMap<Struct, SourceRecord>();
        ArrayList<SourceRecord> binlogRecords = new ArrayList<SourceRecord>();
        if (!sourceRecords.isEmpty()) {
            int i;
            SourceRecord lowWatermark = sourceRecords.get(0);
            Preconditions.checkState((boolean)RecordUtils.isLowWatermarkEvent(lowWatermark), (Object)String.format("The first record should be low watermark signal event, but is %s", lowWatermark));
            SourceRecord highWatermark = null;
            for (i = 1; i < sourceRecords.size(); ++i) {
                SourceRecord sourceRecord = sourceRecords.get(i);
                if (RecordUtils.isHighWatermarkEvent(sourceRecord)) {
                    highWatermark = sourceRecord;
                    ++i;
                    break;
                }
                snapshotRecords.put((Struct)sourceRecord.key(), sourceRecord);
            }
            if (i < sourceRecords.size() - 1) {
                List<SourceRecord> allBinlogRecords = sourceRecords.subList(i, sourceRecords.size() - 1);
                for (SourceRecord binlog : allBinlogRecords) {
                    Object[] key;
                    if (!RecordUtils.isDataChangeRecord(binlog) || !RecordUtils.splitKeyRangeContains(key = RecordUtils.getSplitKey(snapshotSplit.getSplitKeyType(), binlog, nameAdjuster), snapshotSplit.getSplitStart(), snapshotSplit.getSplitEnd())) continue;
                    binlogRecords.add(binlog);
                }
            }
            Preconditions.checkState((boolean)RecordUtils.isHighWatermarkEvent(highWatermark), (Object)String.format("The last record should be high watermark signal event, but is %s", highWatermark));
            normalizedRecords = RecordUtils.upsertBinlog(lowWatermark, highWatermark, snapshotRecords, binlogRecords);
        }
        return normalizedRecords;
    }

    private static List<SourceRecord> upsertBinlog(SourceRecord lowWatermarkEvent, SourceRecord highWatermarkEvent, Map<Struct, SourceRecord> snapshotRecords, List<SourceRecord> binlogRecords) {
        if (!binlogRecords.isEmpty()) {
            for (SourceRecord binlog : binlogRecords) {
                Struct key = (Struct)binlog.key();
                Struct value = (Struct)binlog.value();
                if (value == null) continue;
                Envelope.Operation operation = Envelope.Operation.forCode(value.getString("op"));
                switch (operation) {
                    case CREATE: 
                    case UPDATE: {
                        Envelope envelope = Envelope.fromSchema(binlog.valueSchema());
                        Struct source = value.getStruct("source");
                        Struct after = value.getStruct("after");
                        Instant fetchTs = Instant.ofEpochMilli((Long)source.get("ts_ms"));
                        SourceRecord record = new SourceRecord(binlog.sourcePartition(), binlog.sourceOffset(), binlog.topic(), binlog.kafkaPartition(), binlog.keySchema(), binlog.key(), binlog.valueSchema(), envelope.read(after, source, fetchTs));
                        snapshotRecords.put(key, record);
                        break;
                    }
                    case DELETE: {
                        snapshotRecords.remove(key);
                        break;
                    }
                    case READ: {
                        throw new IllegalStateException(String.format("Binlog record shouldn't use READ operation, the the record is %s.", binlog));
                    }
                }
            }
        }
        ArrayList<SourceRecord> normalizedRecords = new ArrayList<SourceRecord>();
        normalizedRecords.add(lowWatermarkEvent);
        normalizedRecords.addAll(RecordUtils.formatMessageTimestamp(snapshotRecords.values()));
        normalizedRecords.add(highWatermarkEvent);
        return normalizedRecords;
    }

    private static List<SourceRecord> formatMessageTimestamp(Collection<SourceRecord> snapshotRecords) {
        return snapshotRecords.stream().map(record -> {
            Envelope envelope = Envelope.fromSchema(record.valueSchema());
            Struct value = (Struct)record.value();
            Struct updateAfter = value.getStruct("after");
            Struct source = value.getStruct("source");
            source.put("ts_ms", (Object)0L);
            Instant fetchTs = Instant.ofEpochMilli(value.getInt64("ts_ms"));
            SourceRecord sourceRecord = new SourceRecord(record.sourcePartition(), record.sourceOffset(), record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), record.valueSchema(), envelope.read(updateAfter, source, fetchTs));
            return sourceRecord;
        }).collect(Collectors.toList());
    }

    public static boolean isWatermarkEvent(SourceRecord record) {
        Optional<SignalEventDispatcher.WatermarkKind> watermarkKind = RecordUtils.getWatermarkKind(record);
        return watermarkKind.isPresent();
    }

    public static boolean isLowWatermarkEvent(SourceRecord record) {
        Optional<SignalEventDispatcher.WatermarkKind> watermarkKind = RecordUtils.getWatermarkKind(record);
        return watermarkKind.isPresent() && watermarkKind.get() == SignalEventDispatcher.WatermarkKind.LOW;
    }

    public static boolean isHighWatermarkEvent(SourceRecord record) {
        Optional<SignalEventDispatcher.WatermarkKind> watermarkKind = RecordUtils.getWatermarkKind(record);
        return watermarkKind.isPresent() && watermarkKind.get() == SignalEventDispatcher.WatermarkKind.HIGH;
    }

    public static boolean isEndWatermarkEvent(SourceRecord record) {
        Optional<SignalEventDispatcher.WatermarkKind> watermarkKind = RecordUtils.getWatermarkKind(record);
        return watermarkKind.isPresent() && watermarkKind.get() == SignalEventDispatcher.WatermarkKind.BINLOG_END;
    }

    public static BinlogOffset getWatermark(SourceRecord watermarkEvent) {
        return RecordUtils.getBinlogPosition(watermarkEvent.sourceOffset());
    }

    public static Long getMessageTimestamp(SourceRecord record) {
        Schema schema = record.valueSchema();
        Struct value = (Struct)record.value();
        if (schema.field("source") == null) {
            return null;
        }
        Struct source = value.getStruct("source");
        if (source.schema().field("ts_ms") == null) {
            return null;
        }
        return source.getInt64("ts_ms");
    }

    public static Long getFetchTimestamp(SourceRecord record) {
        Schema schema = record.valueSchema();
        Struct value = (Struct)record.value();
        if (schema.field("ts_ms") == null) {
            return null;
        }
        return value.getInt64("ts_ms");
    }

    public static boolean isSchemaChangeEvent(SourceRecord sourceRecord) {
        Schema keySchema = sourceRecord.keySchema();
        return keySchema != null && SCHEMA_CHANGE_EVENT_KEY_NAME.equalsIgnoreCase(keySchema.name());
    }

    public static boolean isHeartbeatEvent(SourceRecord record) {
        Schema valueSchema = record.valueSchema();
        return valueSchema != null && SCHEMA_HEARTBEAT_EVENT_KEY_NAME.equalsIgnoreCase(valueSchema.name());
    }

    public static FinishedSnapshotSplitInfo getSnapshotSplitInfo(MySqlSnapshotSplit split, SourceRecord highWatermark) {
        Struct value = (Struct)highWatermark.value();
        String splitId = value.getString("split_id");
        return new FinishedSnapshotSplitInfo(split.getTableId(), splitId, split.getSplitStart(), split.getSplitEnd(), RecordUtils.getBinlogPosition(highWatermark.sourceOffset()));
    }

    public static BinlogOffset getStartingOffsetOfBinlogSplit(List<FinishedSnapshotSplitInfo> finishedSnapshotSplits) {
        BinlogOffset startOffset = finishedSnapshotSplits.isEmpty() ? BinlogOffset.INITIAL_OFFSET : finishedSnapshotSplits.get(0).getHighWatermark();
        for (FinishedSnapshotSplitInfo finishedSnapshotSplit : finishedSnapshotSplits) {
            if (!finishedSnapshotSplit.getHighWatermark().isBefore(startOffset)) continue;
            startOffset = finishedSnapshotSplit.getHighWatermark();
        }
        return startOffset;
    }

    public static boolean isDataChangeRecord(SourceRecord record) {
        Schema valueSchema = record.valueSchema();
        Struct value = (Struct)record.value();
        return valueSchema.field("op") != null && value.getString("op") != null;
    }

    public static TableId getTableId(SourceRecord dataRecord) {
        Struct value = (Struct)dataRecord.value();
        Struct source = value.getStruct("source");
        String dbName = source.getString("db");
        String tableName = source.getString("table");
        return new TableId(dbName, null, tableName);
    }

    public static Object[] getSplitKey(RowType splitBoundaryType, SourceRecord dataRecord, SchemaNameAdjuster nameAdjuster) {
        String splitFieldName = nameAdjuster.adjust((String)splitBoundaryType.getFieldNames().get(0));
        Struct key = (Struct)dataRecord.key();
        return new Object[]{key.get(splitFieldName)};
    }

    public static BinlogOffset getBinlogPosition(SourceRecord dataRecord) {
        return RecordUtils.getBinlogPosition(dataRecord.sourceOffset());
    }

    public static BinlogOffset getBinlogPosition(Map<String, ?> offset) {
        HashMap<String, String> offsetStrMap = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : offset.entrySet()) {
            offsetStrMap.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
        }
        return new BinlogOffset(offsetStrMap);
    }

    public static boolean splitKeyRangeContains(Object[] key, Object[] splitKeyStart, Object[] splitKeyEnd) {
        if (splitKeyStart == null && splitKeyEnd == null) {
            return true;
        }
        if (splitKeyStart == null) {
            int[] upperBoundRes = new int[key.length];
            for (int i = 0; i < key.length; ++i) {
                upperBoundRes[i] = RecordUtils.compareObjects(key[i], splitKeyEnd[i]);
            }
            return Arrays.stream(upperBoundRes).anyMatch(value -> value < 0) && Arrays.stream(upperBoundRes).allMatch(value -> value <= 0);
        }
        if (splitKeyEnd == null) {
            int[] lowerBoundRes = new int[key.length];
            for (int i = 0; i < key.length; ++i) {
                lowerBoundRes[i] = RecordUtils.compareObjects(key[i], splitKeyStart[i]);
            }
            return Arrays.stream(lowerBoundRes).allMatch(value -> value >= 0);
        }
        int[] lowerBoundRes = new int[key.length];
        int[] upperBoundRes = new int[key.length];
        for (int i = 0; i < key.length; ++i) {
            lowerBoundRes[i] = RecordUtils.compareObjects(key[i], splitKeyStart[i]);
            upperBoundRes[i] = RecordUtils.compareObjects(key[i], splitKeyEnd[i]);
        }
        return Arrays.stream(lowerBoundRes).anyMatch(value -> value >= 0) && Arrays.stream(upperBoundRes).anyMatch(value -> value < 0) && Arrays.stream(upperBoundRes).allMatch(value -> value <= 0);
    }

    private static int compareObjects(Object o1, Object o2) {
        if (o1 instanceof Comparable && o1.getClass().equals(o2.getClass())) {
            return ((Comparable)o1).compareTo(o2);
        }
        return o1.toString().compareTo(o2.toString());
    }

    public static HistoryRecord getHistoryRecord(SourceRecord schemaRecord) throws IOException {
        Struct value = (Struct)schemaRecord.value();
        String historyRecordStr = value.getString("historyRecord");
        return new HistoryRecord(DOCUMENT_READER.read(historyRecordStr));
    }

    private static Optional<SignalEventDispatcher.WatermarkKind> getWatermarkKind(SourceRecord record) {
        if (record.valueSchema() != null && "io.debezium.connector.flink.cdc.embedded.watermark.value".equals(record.valueSchema().name())) {
            Struct value = (Struct)record.value();
            return Optional.of(SignalEventDispatcher.WatermarkKind.valueOf(value.getString("watermark_kind")));
        }
        return Optional.empty();
    }
}

