/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.reader;

import com.ververica.cdc.connectors.mysql.debezium.DebeziumUtils;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import com.ververica.cdc.connectors.mysql.source.events.BinlogSplitMetaEvent;
import com.ververica.cdc.connectors.mysql.source.events.BinlogSplitMetaRequestEvent;
import com.ververica.cdc.connectors.mysql.source.events.FinishedSnapshotSplitsAckEvent;
import com.ververica.cdc.connectors.mysql.source.events.FinishedSnapshotSplitsReportEvent;
import com.ververica.cdc.connectors.mysql.source.events.FinishedSnapshotSplitsRequestEvent;
import com.ververica.cdc.connectors.mysql.source.events.LatestFinishedSplitsSizeEvent;
import com.ververica.cdc.connectors.mysql.source.events.LatestFinishedSplitsSizeRequestEvent;
import com.ververica.cdc.connectors.mysql.source.events.SuspendBinlogReaderAckEvent;
import com.ververica.cdc.connectors.mysql.source.events.SuspendBinlogReaderEvent;
import com.ververica.cdc.connectors.mysql.source.events.WakeupReaderEvent;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.reader.MySqlSourceReaderContext;
import com.ververica.cdc.connectors.mysql.source.reader.MySqlSplitReader;
import com.ververica.cdc.connectors.mysql.source.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlBinlogSplitState;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSnapshotSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSnapshotSplitState;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplitState;
import com.ververica.cdc.connectors.mysql.source.utils.ChunkUtils;
import com.ververica.cdc.connectors.mysql.source.utils.TableDiscoveryUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import io.debezium.connector.mysql.MySqlConnection;
import io.debezium.relational.TableId;
import io.debezium.relational.history.TableChanges;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.SingleThreadMultiplexSourceReaderBase;
import org.apache.flink.connector.base.source.reader.fetcher.SingleThreadFetcherManager;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSourceReader<T>
extends SingleThreadMultiplexSourceReaderBase<SourceRecord, T, MySqlSplit, MySqlSplitState> {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlSourceReader.class);
    private final MySqlSourceConfig sourceConfig;
    private final Map<String, MySqlSnapshotSplit> finishedUnackedSplits;
    private final Map<String, MySqlBinlogSplit> uncompletedBinlogSplits;
    private final int subtaskId;
    private final MySqlSourceReaderContext mySqlSourceReaderContext;
    private MySqlBinlogSplit suspendedBinlogSplit;

    public MySqlSourceReader(FutureCompletingBlockingQueue<RecordsWithSplitIds<SourceRecord>> elementQueue, Supplier<MySqlSplitReader> splitReaderSupplier, RecordEmitter<SourceRecord, T, MySqlSplitState> recordEmitter, Configuration config, MySqlSourceReaderContext context, MySqlSourceConfig sourceConfig) {
        super(elementQueue, new SingleThreadFetcherManager(elementQueue, splitReaderSupplier::get), recordEmitter, config, context.getSourceReaderContext());
        this.sourceConfig = sourceConfig;
        this.finishedUnackedSplits = new HashMap<String, MySqlSnapshotSplit>();
        this.uncompletedBinlogSplits = new HashMap<String, MySqlBinlogSplit>();
        this.subtaskId = context.getSourceReaderContext().getIndexOfSubtask();
        this.mySqlSourceReaderContext = context;
        this.suspendedBinlogSplit = null;
    }

    public void start() {
        if (this.getNumberOfCurrentlyAssignedSplits() == 0) {
            this.context.sendSplitRequest();
        }
    }

    protected MySqlSplitState initializedState(MySqlSplit split) {
        if (split.isSnapshotSplit()) {
            return new MySqlSnapshotSplitState(split.asSnapshotSplit());
        }
        return new MySqlBinlogSplitState(split.asBinlogSplit());
    }

    public List<MySqlSplit> snapshotState(long checkpointId) {
        List stateSplits = super.snapshotState(checkpointId);
        List<MySqlSplit> unfinishedSplits = stateSplits.stream().filter(split -> !this.finishedUnackedSplits.containsKey(split.splitId())).collect(Collectors.toList());
        unfinishedSplits.addAll(this.finishedUnackedSplits.values());
        unfinishedSplits.addAll(this.uncompletedBinlogSplits.values());
        if (this.suspendedBinlogSplit != null) {
            unfinishedSplits.add(this.suspendedBinlogSplit);
        }
        return unfinishedSplits;
    }

    protected void onSplitFinished(Map<String, MySqlSplitState> finishedSplitIds) {
        for (MySqlSplitState mySqlSplitState : finishedSplitIds.values()) {
            MySqlSplit mySqlSplit = mySqlSplitState.toMySqlSplit();
            if (mySqlSplit.isBinlogSplit()) {
                LOG.info("binlog split reader suspended due to newly added table, offset {}", (Object)mySqlSplitState.asBinlogSplitState().getStartingOffset());
                this.mySqlSourceReaderContext.resetStopBinlogSplitReader();
                this.suspendedBinlogSplit = MySqlBinlogSplit.toSuspendedBinlogSplit(mySqlSplit.asBinlogSplit());
                this.context.sendSourceEventToCoordinator((SourceEvent)new SuspendBinlogReaderAckEvent());
                continue;
            }
            this.finishedUnackedSplits.put(mySqlSplit.splitId(), mySqlSplit.asSnapshotSplit());
        }
        this.reportFinishedSnapshotSplitsIfNeed();
        this.context.sendSplitRequest();
    }

    public void addSplits(List<MySqlSplit> splits) {
        ArrayList<MySqlSplit> unfinishedSplits = new ArrayList<MySqlSplit>();
        for (MySqlSplit split : splits) {
            LOG.info("Add Split: " + split);
            if (split.isSnapshotSplit()) {
                MySqlSnapshotSplit snapshotSplit = split.asSnapshotSplit();
                if (snapshotSplit.isSnapshotReadFinished()) {
                    this.finishedUnackedSplits.put(snapshotSplit.splitId(), snapshotSplit);
                    continue;
                }
                unfinishedSplits.add(split);
                continue;
            }
            MySqlBinlogSplit binlogSplit = split.asBinlogSplit();
            if (binlogSplit.isSuspended()) {
                this.suspendedBinlogSplit = binlogSplit;
                continue;
            }
            if (!binlogSplit.isCompletedSplit()) {
                this.uncompletedBinlogSplits.put(split.splitId(), split.asBinlogSplit());
                this.requestBinlogSplitMetaIfNeeded(split.asBinlogSplit());
                continue;
            }
            this.uncompletedBinlogSplits.remove(split.splitId());
            MySqlBinlogSplit mySqlBinlogSplit = this.discoverTableSchemasForBinlogSplit(split.asBinlogSplit());
            unfinishedSplits.add(mySqlBinlogSplit);
        }
        this.reportFinishedSnapshotSplitsIfNeed();
        if (!unfinishedSplits.isEmpty()) {
            super.addSplits(unfinishedSplits);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MySqlBinlogSplit discoverTableSchemasForBinlogSplit(MySqlBinlogSplit split) {
        String splitId = split.splitId();
        if (!split.getTableSchemas().isEmpty()) {
            LOG.warn("The binlog split {} has table schemas yet, skip the table schema discovery", (Object)split);
            return split;
        }
        try (MySqlConnection jdbc = DebeziumUtils.createMySqlConnection(this.sourceConfig.getDbzConfiguration());){
            Map<TableId, TableChanges.TableChange> tableSchemas = TableDiscoveryUtils.discoverCapturedTableSchemas(this.sourceConfig, jdbc);
            LOG.info("The table schema discovery for binlog split {} success", (Object)splitId);
            MySqlBinlogSplit mySqlBinlogSplit = MySqlBinlogSplit.fillTableSchemas(split, tableSchemas);
            return mySqlBinlogSplit;
        }
        catch (SQLException e) {
            LOG.error("Failed to obtains table schemas due to {}", (Object)e.getMessage());
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public void handleSourceEvents(SourceEvent sourceEvent) {
        if (sourceEvent instanceof FinishedSnapshotSplitsAckEvent) {
            FinishedSnapshotSplitsAckEvent ackEvent = (FinishedSnapshotSplitsAckEvent)sourceEvent;
            LOG.debug("The subtask {} receives ack event for {} from enumerator.", (Object)this.subtaskId, ackEvent.getFinishedSplits());
            for (String splitId : ackEvent.getFinishedSplits()) {
                this.finishedUnackedSplits.remove(splitId);
            }
        } else if (sourceEvent instanceof FinishedSnapshotSplitsRequestEvent) {
            LOG.debug("The subtask {} receives request to report finished snapshot splits.", (Object)this.subtaskId);
            this.reportFinishedSnapshotSplitsIfNeed();
        } else if (sourceEvent instanceof BinlogSplitMetaEvent) {
            LOG.debug("The subtask {} receives binlog meta with group id {}.", (Object)this.subtaskId, (Object)((BinlogSplitMetaEvent)sourceEvent).getMetaGroupId());
            this.fillMetaDataForBinlogSplit((BinlogSplitMetaEvent)sourceEvent);
        } else if (sourceEvent instanceof SuspendBinlogReaderEvent) {
            this.mySqlSourceReaderContext.setStopBinlogSplitReader();
        } else if (sourceEvent instanceof WakeupReaderEvent) {
            WakeupReaderEvent wakeupReaderEvent = (WakeupReaderEvent)sourceEvent;
            if (wakeupReaderEvent.getTarget() == WakeupReaderEvent.WakeUpTarget.SNAPSHOT_READER) {
                this.context.sendSplitRequest();
            } else if (this.suspendedBinlogSplit != null) {
                this.context.sendSourceEventToCoordinator((SourceEvent)new LatestFinishedSplitsSizeRequestEvent());
            }
        } else if (sourceEvent instanceof LatestFinishedSplitsSizeEvent) {
            if (this.suspendedBinlogSplit != null) {
                int finishedSplitsSize = ((LatestFinishedSplitsSizeEvent)sourceEvent).getLatestFinishedSplitsSize();
                MySqlBinlogSplit binlogSplit = MySqlBinlogSplit.toNormalBinlogSplit(this.suspendedBinlogSplit, finishedSplitsSize);
                this.suspendedBinlogSplit = null;
                this.addSplits(Collections.singletonList(binlogSplit));
            }
        } else {
            super.handleSourceEvents(sourceEvent);
        }
    }

    private void reportFinishedSnapshotSplitsIfNeed() {
        if (!this.finishedUnackedSplits.isEmpty()) {
            HashMap<String, BinlogOffset> finishedOffsets = new HashMap<String, BinlogOffset>();
            for (MySqlSnapshotSplit split : this.finishedUnackedSplits.values()) {
                finishedOffsets.put(split.splitId(), split.getHighWatermark());
            }
            FinishedSnapshotSplitsReportEvent reportEvent = new FinishedSnapshotSplitsReportEvent(finishedOffsets);
            this.context.sendSourceEventToCoordinator((SourceEvent)reportEvent);
            LOG.debug("The subtask {} reports offsets of finished snapshot splits {}.", (Object)this.subtaskId, finishedOffsets);
        }
    }

    private void requestBinlogSplitMetaIfNeeded(MySqlBinlogSplit binlogSplit) {
        String splitId = binlogSplit.splitId();
        if (!binlogSplit.isCompletedSplit()) {
            int nextMetaGroupId = ChunkUtils.getNextMetaGroupId(binlogSplit.getFinishedSnapshotSplitInfos().size(), this.sourceConfig.getSplitMetaGroupSize());
            BinlogSplitMetaRequestEvent splitMetaRequestEvent = new BinlogSplitMetaRequestEvent(splitId, nextMetaGroupId);
            this.context.sendSourceEventToCoordinator((SourceEvent)splitMetaRequestEvent);
        } else {
            LOG.info("The meta of binlog split {} has been collected success", (Object)splitId);
            this.addSplits(Arrays.asList(binlogSplit));
        }
    }

    private void fillMetaDataForBinlogSplit(BinlogSplitMetaEvent metadataEvent) {
        MySqlBinlogSplit binlogSplit = this.uncompletedBinlogSplits.get(metadataEvent.getSplitId());
        if (binlogSplit != null) {
            int expectedMetaGroupId;
            int receivedMetaGroupId = metadataEvent.getMetaGroupId();
            if (receivedMetaGroupId == (expectedMetaGroupId = ChunkUtils.getNextMetaGroupId(binlogSplit.getFinishedSnapshotSplitInfos().size(), this.sourceConfig.getSplitMetaGroupSize()))) {
                List<FinishedSnapshotSplitInfo> metaDataGroup = metadataEvent.getMetaGroup().stream().map(FinishedSnapshotSplitInfo::deserialize).collect(Collectors.toList());
                this.uncompletedBinlogSplits.put(binlogSplit.splitId(), MySqlBinlogSplit.appendFinishedSplitInfos(binlogSplit, metaDataGroup));
                LOG.info("Fill meta data of group {} to binlog split", (Object)metaDataGroup.size());
            } else {
                LOG.warn("Received out of oder binlog meta event for split {}, the received meta group id is {}, but expected is {}, ignore it", new Object[]{metadataEvent.getSplitId(), receivedMetaGroupId, expectedMetaGroupId});
            }
            this.requestBinlogSplitMetaIfNeeded(binlogSplit);
        } else {
            LOG.warn("Received binlog meta event for split {}, but the uncompleted split map does not contain it", (Object)metadataEvent.getSplitId());
        }
    }

    protected MySqlSplit toSplitType(String splitId, MySqlSplitState splitState) {
        return splitState.toMySqlSplit();
    }
}

