/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.kafka.table;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.table.KafkaSinkSemantic;
import org.apache.flink.streaming.connectors.kafka.table.SinkBufferFlushMode;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.constraints.UniqueConstraint;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.Format;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.RowKind;
import org.apache.inlong.sort.kafka.KafkaDynamicSink;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.dirty.utils.DirtySinkFactoryUtils;
import org.apache.inlong.sort.kafka.table.KafkaDynamicSource;
import org.apache.inlong.sort.kafka.table.KafkaOptions;

public class UpsertKafkaDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "upsert-kafka-inlong";

    private static void validateSource(ReadableConfig tableOptions, Format keyFormat, Format valueFormat, TableSchema schema) {
        UpsertKafkaDynamicTableFactory.validateTopic(tableOptions);
        UpsertKafkaDynamicTableFactory.validateFormat(keyFormat, valueFormat, tableOptions);
        UpsertKafkaDynamicTableFactory.validatePKConstraints(schema);
    }

    private static void validateSink(ReadableConfig tableOptions, Format keyFormat, Format valueFormat, TableSchema schema) {
        UpsertKafkaDynamicTableFactory.validateTopic(tableOptions);
        UpsertKafkaDynamicTableFactory.validateFormat(keyFormat, valueFormat, tableOptions);
        UpsertKafkaDynamicTableFactory.validatePKConstraints(schema);
        UpsertKafkaDynamicTableFactory.validateSinkBufferFlush(tableOptions);
    }

    private static void validateTopic(ReadableConfig tableOptions) {
        List topic = (List)tableOptions.get(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.TOPIC);
        if (topic.size() > 1) {
            throw new ValidationException("The 'upsert-kafka' connector doesn't support topic list now. Please use single topic as the value of the parameter 'topic'.");
        }
    }

    private static void validateFormat(Format keyFormat, Format valueFormat, ReadableConfig tableOptions) {
        if (!keyFormat.getChangelogMode().containsOnly(RowKind.INSERT)) {
            String identifier = (String)tableOptions.get(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FORMAT);
            throw new ValidationException(String.format("'upsert-kafka' connector doesn't support '%s' as key format, because '%s' is not in insert-only mode.", identifier, identifier));
        }
        if (!valueFormat.getChangelogMode().containsOnly(RowKind.INSERT)) {
            String identifier = (String)tableOptions.get(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.VALUE_FORMAT);
            throw new ValidationException(String.format("'upsert-kafka' connector doesn't support '%s' as value format, because '%s' is not in insert-only mode.", identifier, identifier));
        }
    }

    private static void validatePKConstraints(TableSchema schema) {
        if (!schema.getPrimaryKey().isPresent()) {
            throw new ValidationException("'upsert-kafka' tables require to define a PRIMARY KEY constraint. The PRIMARY KEY specifies which columns should be read from or write to the Kafka message key. The PRIMARY KEY also defines records in the 'upsert-kafka' table should update or delete on which keys.");
        }
    }

    private static void validateSinkBufferFlush(ReadableConfig tableOptions) {
        int flushMaxRows = (Integer)tableOptions.get(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        long flushIntervalMs = ((Duration)tableOptions.get(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_BUFFER_FLUSH_INTERVAL)).toMillis();
        if (flushMaxRows > 0 && flushIntervalMs > 0L) {
            return;
        }
        if (flushMaxRows <= 0 && flushIntervalMs <= 0L) {
            return;
        }
        throw new ValidationException(String.format("'%s' and '%s' must be set to be greater than zero together to enable sink buffer flushing.", org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_BUFFER_FLUSH_MAX_ROWS.key(), org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_BUFFER_FLUSH_INTERVAL.key()));
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.PROPS_BOOTSTRAP_SERVERS);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.TOPIC);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FORMAT);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.VALUE_FORMAT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FIELDS_PREFIX);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.VALUE_FIELDS_INCLUDE);
        options.add(FactoryUtil.SINK_PARALLELISM);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_BUFFER_FLUSH_INTERVAL);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        options.add(KafkaOptions.KAFKA_IGNORE_ALL_CHANGELOG);
        options.add(Constants.INLONG_METRIC);
        return options;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        DecodingFormat keyDecodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FORMAT);
        DecodingFormat valueDecodingFormat = helper.discoverDecodingFormat(DeserializationFormatFactory.class, org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.VALUE_FORMAT);
        helper.validateExcept(new String[]{"properties.", "dirty."});
        TableSchema schema = context.getCatalogTable().getSchema();
        UpsertKafkaDynamicTableFactory.validateSource(tableOptions, (Format)keyDecodingFormat, (Format)valueDecodingFormat, schema);
        Tuple2<int[], int[]> keyValueProjections = this.createKeyValueProjections((CatalogTable)context.getCatalogTable());
        String keyPrefix = tableOptions.getOptional(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FIELDS_PREFIX).orElse(null);
        Properties properties = org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.getKafkaProperties(context.getCatalogTable().getOptions());
        StartupMode earliest = StartupMode.EARLIEST;
        DirtyOptions dirtyOptions = DirtyOptions.fromConfig(tableOptions);
        DirtySink<String> dirtySink = DirtySinkFactoryUtils.createDirtySink(context, dirtyOptions);
        return new KafkaDynamicSource(schema.toPhysicalRowDataType(), (DecodingFormat<DeserializationSchema<RowData>>)keyDecodingFormat, new DecodingFormatWrapper((DecodingFormat<DeserializationSchema<RowData>>)valueDecodingFormat), (int[])keyValueProjections.f0, (int[])keyValueProjections.f1, keyPrefix, org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.getSourceTopics(tableOptions), org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.getSourceTopicPattern(tableOptions), properties, earliest, Collections.emptyMap(), 0L, true, null, null, dirtyOptions, dirtySink);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.autoCompleteSchemaRegistrySubject(context));
        ReadableConfig tableOptions = helper.getOptions();
        EncodingFormat keyEncodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FORMAT);
        EncodingFormat valueEncodingFormat = helper.discoverEncodingFormat(SerializationFormatFactory.class, org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.VALUE_FORMAT);
        helper.validateExcept(new String[]{"properties.", "dirty."});
        TableSchema schema = context.getCatalogTable().getSchema();
        UpsertKafkaDynamicTableFactory.validateSink(tableOptions, (Format)keyEncodingFormat, (Format)valueEncodingFormat, schema);
        Tuple2<int[], int[]> keyValueProjections = this.createKeyValueProjections((CatalogTable)context.getCatalogTable());
        String keyPrefix = tableOptions.getOptional(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FIELDS_PREFIX).orElse(null);
        Properties properties = org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.getKafkaProperties(context.getCatalogTable().getOptions());
        Integer parallelism = (Integer)tableOptions.get(FactoryUtil.SINK_PARALLELISM);
        int batchSize = (Integer)tableOptions.get(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        Duration batchInterval = (Duration)tableOptions.get(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_BUFFER_FLUSH_INTERVAL);
        SinkBufferFlushMode flushMode = new SinkBufferFlushMode(batchSize, batchInterval.toMillis());
        String inlongMetric = tableOptions.getOptional(Constants.INLONG_METRIC).orElse(null);
        String auditHostAndPorts = tableOptions.getOptional(Constants.INLONG_AUDIT).orElse(null);
        DirtyOptions dirtyOptions = DirtyOptions.fromConfig(tableOptions);
        DirtySink<Object> dirtySink = DirtySinkFactoryUtils.createDirtySink(context, dirtyOptions);
        boolean multipleSink = tableOptions.getOptional(Constants.SINK_MULTIPLE_FORMAT).isPresent();
        return new KafkaDynamicSink(schema.toPhysicalRowDataType(), schema.toPhysicalRowDataType(), (EncodingFormat<SerializationSchema<RowData>>)keyEncodingFormat, new EncodingFormatWrapper((EncodingFormat<SerializationSchema<RowData>>)valueEncodingFormat), (int[])keyValueProjections.f0, (int[])keyValueProjections.f1, keyPrefix, (String)((List)tableOptions.get(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.TOPIC)).get(0), properties, (CatalogTable)context.getCatalogTable(), null, KafkaSinkSemantic.AT_LEAST_ONCE, true, flushMode, parallelism, inlongMetric, auditHostAndPorts, null, null, dirtyOptions, dirtySink, multipleSink);
    }

    private Tuple2<int[], int[]> createKeyValueProjections(CatalogTable catalogTable) {
        TableSchema schema = catalogTable.getSchema();
        List keyFields = ((UniqueConstraint)schema.getPrimaryKey().get()).getColumns();
        DataType physicalDataType = schema.toPhysicalRowDataType();
        Configuration tableOptions = Configuration.fromMap((Map)catalogTable.getOptions());
        tableOptions.set(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FIELDS, (Object)keyFields);
        int[] keyProjection = org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.createKeyFormatProjection((ReadableConfig)tableOptions, physicalDataType);
        int[] valueProjection = org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.createValueFormatProjection((ReadableConfig)tableOptions, physicalDataType);
        return Tuple2.of((Object)keyProjection, (Object)valueProjection);
    }

    protected static class EncodingFormatWrapper
    implements EncodingFormat<SerializationSchema<RowData>> {
        public static final ChangelogMode SINK_CHANGELOG_MODE = ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
        private final EncodingFormat<SerializationSchema<RowData>> innerEncodingFormat;

        public EncodingFormatWrapper(EncodingFormat<SerializationSchema<RowData>> innerEncodingFormat) {
            this.innerEncodingFormat = innerEncodingFormat;
        }

        public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
            return (SerializationSchema)this.innerEncodingFormat.createRuntimeEncoder(context, consumedDataType);
        }

        public ChangelogMode getChangelogMode() {
            return SINK_CHANGELOG_MODE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EncodingFormatWrapper that = (EncodingFormatWrapper)obj;
            return Objects.equals(this.innerEncodingFormat, that.innerEncodingFormat);
        }

        public int hashCode() {
            return Objects.hash(this.innerEncodingFormat);
        }
    }

    protected static class DecodingFormatWrapper
    implements DecodingFormat<DeserializationSchema<RowData>> {
        private static final ChangelogMode SOURCE_CHANGELOG_MODE = ChangelogMode.newBuilder().addContainedKind(RowKind.UPDATE_AFTER).addContainedKind(RowKind.DELETE).build();
        private final DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat;

        public DecodingFormatWrapper(DecodingFormat<DeserializationSchema<RowData>> innerDecodingFormat) {
            this.innerDecodingFormat = innerDecodingFormat;
        }

        public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
            return (DeserializationSchema)this.innerDecodingFormat.createRuntimeDecoder(context, producedDataType);
        }

        public ChangelogMode getChangelogMode() {
            return SOURCE_CHANGELOG_MODE;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DecodingFormatWrapper that = (DecodingFormatWrapper)obj;
            return Objects.equals(this.innerDecodingFormat, that.innerDecodingFormat);
        }

        public int hashCode() {
            return Objects.hash(this.innerDecodingFormat);
        }
    }
}

