/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.kafka.table;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.streaming.connectors.kafka.table.KafkaOptions;
import org.apache.flink.streaming.connectors.kafka.table.KafkaSinkSemantic;
import org.apache.flink.streaming.connectors.kafka.table.SinkBufferFlushMode;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.format.Format;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.formats.raw.RawFormatSerializationSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.types.RowKind;
import org.apache.inlong.sort.kafka.KafkaDynamicSink;
import org.apache.inlong.sort.kafka.partitioner.RawDataHashPartitioner;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.dirty.utils.DirtySinkFactoryUtils;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.format.DynamicSchemaFormatFactory;
import org.apache.inlong.sort.kafka.table.KafkaDynamicSource;
import org.apache.inlong.sort.kafka.table.KafkaOptions;

@Internal
public class KafkaDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    public static final String IDENTIFIER = "kafka-inlong";
    public static final String SINK_PARTITIONER_VALUE_RAW_HASH = "raw-hash";
    public static final ConfigOption<String> SINK_MULTIPLE_PARTITION_PATTERN = ConfigOptions.key((String)"sink.multiple.partition-pattern").stringType().noDefaultValue().withDescription("option 'sink.multiple.partition-pattern' used when the partitioner is raw-hash.");
    private static final Set<String> SINK_SEMANTIC_ENUMS = new HashSet<String>(Arrays.asList("at-least-once", "exactly-once", "none"));

    private static Optional<DecodingFormat<DeserializationSchema<RowData>>> getKeyDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional keyDecodingFormat = helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FORMAT);
        keyDecodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyDecodingFormat;
    }

    private static Optional<EncodingFormat<SerializationSchema<RowData>>> getKeyEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        Optional keyEncodingFormat = helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FORMAT);
        keyEncodingFormat.ifPresent(format -> {
            if (!format.getChangelogMode().containsOnly(RowKind.INSERT)) {
                throw new ValidationException(String.format("A key format should only deal with INSERT-only records. But %s has a changelog mode of %s.", helper.getOptions().get(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FORMAT), format.getChangelogMode()));
            }
        });
        return keyEncodingFormat;
    }

    private static DecodingFormat<DeserializationSchema<RowData>> getValueDecodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalDecodingFormat(DeserializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverDecodingFormat(DeserializationFormatFactory.class, org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.VALUE_FORMAT));
    }

    private static EncodingFormat<SerializationSchema<RowData>> getValueEncodingFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.discoverOptionalEncodingFormat(SerializationFormatFactory.class, FactoryUtil.FORMAT).orElseGet(() -> helper.discoverEncodingFormat(SerializationFormatFactory.class, org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.VALUE_FORMAT));
    }

    private static String getSinkMultipleFormat(FactoryUtil.TableFactoryHelper helper) {
        return helper.getOptions().getOptional(Constants.SINK_MULTIPLE_FORMAT).orElse(null);
    }

    private static void validatePKConstraints(ObjectIdentifier tableName, CatalogTable catalogTable, Format format) {
        if (catalogTable.getSchema().getPrimaryKey().isPresent() && format.getChangelogMode().containsOnly(RowKind.INSERT)) {
            Configuration options = Configuration.fromMap((Map)catalogTable.getOptions());
            String formatName = (String)options.getOptional(FactoryUtil.FORMAT).orElse(options.get(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.VALUE_FORMAT));
            throw new ValidationException(String.format("The Kafka table '%s' with '%s' format doesn't support defining PRIMARY KEY constraint on the table, because it can't guarantee the semantic of primary key.", tableName.asSummaryString(), formatName));
        }
    }

    private static void validateSinkPartitioner(ReadableConfig tableOptions) {
        tableOptions.getOptional(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_PARTITIONER).ifPresent(partitioner -> {
            if (partitioner.equals("round-robin") && tableOptions.getOptional(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FIELDS).isPresent()) {
                throw new ValidationException("Currently 'round-robin' partitioner only works when option 'key.fields' is not specified.");
            }
            if (SINK_PARTITIONER_VALUE_RAW_HASH.equals(partitioner) || "org.apache.inlong.sort.kafka.partitioner.RawDataHashPartitioner".equals(partitioner)) {
                boolean invalid;
                boolean bl = invalid = !"raw".equals(tableOptions.getOptional(FactoryUtil.FORMAT).orElse(null)) || !tableOptions.getOptional(Constants.SINK_MULTIPLE_FORMAT).isPresent() || !tableOptions.getOptional(SINK_MULTIPLE_PARTITION_PATTERN).isPresent() || ((String)tableOptions.getOptional(Constants.SINK_MULTIPLE_FORMAT).get()).isEmpty() || ((String)tableOptions.getOptional(SINK_MULTIPLE_PARTITION_PATTERN).get()).isEmpty();
                if (invalid) {
                    throw new ValidationException("Currently 'raw-hash' partitioner only works when option 'format' is 'raw' and option 'sink.multiple.format' and 'sink.multiple.partition-pattern' is specified.");
                }
            } else if (partitioner.isEmpty()) {
                throw new ValidationException(String.format("Option '%s' should be a non-empty string.", org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_PARTITIONER.key()));
            }
        });
    }

    private Optional<FlinkKafkaPartitioner<RowData>> getFlinkKafkaPartitioner(ReadableConfig tableOptions, ClassLoader classLoader) {
        if (tableOptions.getOptional(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_PARTITIONER).isPresent() && SINK_PARTITIONER_VALUE_RAW_HASH.equals(tableOptions.getOptional(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_PARTITIONER).get())) {
            RawDataHashPartitioner rawHashPartitioner = new RawDataHashPartitioner();
            rawHashPartitioner.setSinkMultipleFormat(tableOptions.getOptional(Constants.SINK_MULTIPLE_FORMAT).orElse(null));
            rawHashPartitioner.setPartitionPattern(tableOptions.getOptional(SINK_MULTIPLE_PARTITION_PATTERN).orElse(null));
            return Optional.of(rawHashPartitioner);
        }
        Optional<FlinkKafkaPartitioner<RowData>> partitioner = org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.getFlinkKafkaPartitioner(tableOptions, classLoader);
        if (partitioner.isPresent() && partitioner.get() instanceof RawDataHashPartitioner) {
            RawDataHashPartitioner rawHashPartitioner = (RawDataHashPartitioner)partitioner.get();
            rawHashPartitioner.setSinkMultipleFormat(tableOptions.getOptional(Constants.SINK_MULTIPLE_FORMAT).orElse(null));
            rawHashPartitioner.setPartitionPattern(tableOptions.getOptional(SINK_MULTIPLE_PARTITION_PATTERN).orElse(null));
        }
        return partitioner;
    }

    private void validateSinkSemantic(ReadableConfig tableOptions) {
        tableOptions.getOptional(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_SEMANTIC).ifPresent(semantic -> {
            if (!SINK_SEMANTIC_ENUMS.contains(semantic)) {
                throw new ValidationException(String.format("Unsupported value '%s' for '%s'. Supported values are ['at-least-once', 'exactly-once', 'none'].", semantic, org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_SEMANTIC.key()));
            }
        });
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.PROPS_BOOTSTRAP_SERVERS);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(FactoryUtil.FORMAT);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FORMAT);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FIELDS);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FIELDS_PREFIX);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.VALUE_FORMAT);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.VALUE_FIELDS_INCLUDE);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.TOPIC);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.TOPIC_PATTERN);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.PROPS_GROUP_ID);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SCAN_STARTUP_MODE);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SCAN_STARTUP_SPECIFIC_OFFSETS);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SCAN_TOPIC_PARTITION_DISCOVERY);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SCAN_STARTUP_TIMESTAMP_MILLIS);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_PARTITIONER);
        options.add(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SINK_SEMANTIC);
        options.add(FactoryUtil.SINK_PARALLELISM);
        options.add(KafkaOptions.KAFKA_IGNORE_ALL_CHANGELOG);
        options.add(Constants.INLONG_METRIC);
        options.add(Constants.INLONG_AUDIT);
        options.add(Constants.SINK_MULTIPLE_FORMAT);
        options.add(SINK_MULTIPLE_PARTITION_PATTERN);
        return options;
    }

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        ReadableConfig tableOptions = helper.getOptions();
        Optional<DecodingFormat<DeserializationSchema<RowData>>> keyDecodingFormat = KafkaDynamicTableFactory.getKeyDecodingFormat(helper);
        DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat = KafkaDynamicTableFactory.getValueDecodingFormat(helper);
        helper.validateExcept(new String[]{"properties.", "dirty."});
        org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.validateTableSourceOptions(tableOptions);
        KafkaDynamicTableFactory.validatePKConstraints(context.getObjectIdentifier(), (CatalogTable)context.getCatalogTable(), valueDecodingFormat);
        KafkaOptions.StartupOptions startupOptions = org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.getStartupOptions(tableOptions);
        Properties properties = org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.getKafkaProperties(context.getCatalogTable().getOptions());
        properties.setProperty("flink.partition-discovery.interval-millis", String.valueOf(tableOptions.getOptional(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.SCAN_TOPIC_PARTITION_DISCOVERY).map(Duration::toMillis).orElse(Long.MIN_VALUE)));
        DataType physicalDataType = context.getCatalogTable().getSchema().toPhysicalRowDataType();
        int[] keyProjection = org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.createKeyFormatProjection(tableOptions, physicalDataType);
        int[] valueProjection = org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.createValueFormatProjection(tableOptions, physicalDataType);
        String keyPrefix = tableOptions.getOptional(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FIELDS_PREFIX).orElse(null);
        String inlongMetric = tableOptions.getOptional(Constants.INLONG_METRIC).orElse(null);
        String auditHostAndPorts = tableOptions.getOptional(Constants.INLONG_AUDIT).orElse(null);
        DirtyOptions dirtyOptions = DirtyOptions.fromConfig(tableOptions);
        DirtySink<String> dirtySink = DirtySinkFactoryUtils.createDirtySink(context, dirtyOptions);
        return this.createKafkaTableSource(physicalDataType, (DecodingFormat<DeserializationSchema<RowData>>)((DecodingFormat)keyDecodingFormat.orElse(null)), valueDecodingFormat, keyProjection, valueProjection, keyPrefix, org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.getSourceTopics(tableOptions), org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.getSourceTopicPattern(tableOptions), properties, startupOptions.startupMode, startupOptions.specificOffsets, startupOptions.startupTimestampMillis, inlongMetric, auditHostAndPorts, dirtyOptions, dirtySink);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.autoCompleteSchemaRegistrySubject(context));
        ReadableConfig tableOptions = helper.getOptions();
        Optional<EncodingFormat<SerializationSchema<RowData>>> keyEncodingFormat = KafkaDynamicTableFactory.getKeyEncodingFormat(helper);
        EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat = KafkaDynamicTableFactory.getValueEncodingFormat(helper);
        String sinkMultipleFormat = KafkaDynamicTableFactory.getSinkMultipleFormat(helper);
        helper.validateExcept(new String[]{"properties.", "dirty."});
        KafkaDynamicTableFactory.validateSinkPartitioner(tableOptions);
        this.validateSinkSemantic(tableOptions);
        KafkaDynamicTableFactory.validatePKConstraints(context.getObjectIdentifier(), (CatalogTable)context.getCatalogTable(), valueEncodingFormat);
        DataType physicalDataType = context.getCatalogTable().getSchema().toPhysicalRowDataType();
        this.validateSinkMultipleFormatAndPhysicalDataType(physicalDataType, valueEncodingFormat, sinkMultipleFormat);
        int[] keyProjection = org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.createKeyFormatProjection(tableOptions, physicalDataType);
        int[] valueProjection = org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.createValueFormatProjection(tableOptions, physicalDataType);
        String keyPrefix = tableOptions.getOptional(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.KEY_FIELDS_PREFIX).orElse(null);
        Integer parallelism = tableOptions.getOptional(FactoryUtil.SINK_PARALLELISM).orElse(null);
        String inlongMetric = tableOptions.getOptional(Constants.INLONG_METRIC).orElse(null);
        String auditHostAndPorts = tableOptions.getOptional(Constants.INLONG_AUDIT).orElse(null);
        DirtyOptions dirtyOptions = DirtyOptions.fromConfig(tableOptions);
        DirtySink<Object> dirtySink = DirtySinkFactoryUtils.createDirtySink(context, dirtyOptions);
        boolean multipleSink = tableOptions.getOptional(Constants.SINK_MULTIPLE_FORMAT).isPresent();
        return this.createKafkaTableSink(physicalDataType, (EncodingFormat<SerializationSchema<RowData>>)((EncodingFormat)keyEncodingFormat.orElse(null)), valueEncodingFormat, keyProjection, valueProjection, keyPrefix, (String)((List)tableOptions.get(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.TOPIC)).get(0), org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.getKafkaProperties(context.getCatalogTable().getOptions()), (CatalogTable)context.getCatalogTable(), this.getFlinkKafkaPartitioner(tableOptions, context.getClassLoader()).orElse(null), org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.getSinkSemantic(tableOptions), parallelism, inlongMetric, auditHostAndPorts, sinkMultipleFormat, tableOptions.getOptional(org.apache.flink.streaming.connectors.kafka.table.KafkaOptions.TOPIC_PATTERN).orElse(null), dirtyOptions, dirtySink, multipleSink);
    }

    private void validateSinkMultipleFormatAndPhysicalDataType(DataType physicalDataType, EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, String sinkMultipleFormat) {
        if (this.multipleSink(valueEncodingFormat, sinkMultipleFormat)) {
            DynamicSchemaFormatFactory.getFormat(sinkMultipleFormat);
            Set<String> supportFormats = DynamicSchemaFormatFactory.SUPPORT_FORMATS.keySet();
            if (!supportFormats.contains(sinkMultipleFormat)) {
                throw new ValidationException(String.format("Unsupported value '%s' for '%s'. Supported values are %s.", sinkMultipleFormat, Constants.SINK_MULTIPLE_FORMAT.key(), supportFormats));
            }
            if (physicalDataType.getLogicalType() instanceof VarBinaryType) {
                throw new ValidationException("Only supports 'BYTES' or 'VARBINARY(n)' of PhysicalDataType when the option 'format' is 'raw' and option 'sink.multiple.format' is specified.");
            }
        }
    }

    private boolean multipleSink(EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, String sinkMultipleFormat) {
        return valueEncodingFormat instanceof RawFormatSerializationSchema && StringUtils.isNotBlank((CharSequence)sinkMultipleFormat);
    }

    protected KafkaDynamicSource createKafkaTableSource(DataType physicalDataType, @Nullable DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat, DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, @Nullable List<String> topics, @Nullable Pattern topicPattern, Properties properties, StartupMode startupMode, Map<KafkaTopicPartition, Long> specificStartupOffsets, long startupTimestampMillis, String inlongMetric, String auditHostAndPorts, DirtyOptions dirtyOptions, @Nullable DirtySink<String> dirtySink) {
        return new KafkaDynamicSource(physicalDataType, keyDecodingFormat, valueDecodingFormat, keyProjection, valueProjection, keyPrefix, topics, topicPattern, properties, startupMode, specificStartupOffsets, startupTimestampMillis, false, inlongMetric, auditHostAndPorts, dirtyOptions, dirtySink);
    }

    protected KafkaDynamicSink createKafkaTableSink(DataType physicalDataType, @Nullable EncodingFormat<SerializationSchema<RowData>> keyEncodingFormat, EncodingFormat<SerializationSchema<RowData>> valueEncodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, String topic, Properties properties, CatalogTable table, FlinkKafkaPartitioner<RowData> partitioner, KafkaSinkSemantic semantic, Integer parallelism, String inlongMetric, String auditHostAndPorts, @Nullable String sinkMultipleFormat, @Nullable String topicPattern, DirtyOptions dirtyOptions, @Nullable DirtySink<Object> dirtySink, boolean multipleSink) {
        return new KafkaDynamicSink(physicalDataType, physicalDataType, keyEncodingFormat, valueEncodingFormat, keyProjection, valueProjection, keyPrefix, topic, properties, table, partitioner, semantic, false, SinkBufferFlushMode.DISABLED, parallelism, inlongMetric, auditHostAndPorts, sinkMultipleFormat, topicPattern, dirtyOptions, dirtySink, multipleSink);
    }
}

