/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.kafka.table;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.header.Header;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.SourceFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.connector.source.abilities.SupportsWatermarkPushDown;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.kafka.FlinkKafkaConsumer;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.kafka.table.DynamicKafkaDeserializationSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class KafkaDynamicSource
implements ScanTableSource,
SupportsReadingMetadata,
SupportsWatermarkPushDown {
    protected DataType producedDataType;
    protected List<String> metadataKeys;
    @Nullable
    protected WatermarkStrategy<RowData> watermarkStrategy;
    private static final String VALUE_METADATA_PREFIX = "value.";
    protected final DataType physicalDataType;
    @Nullable
    protected final DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat;
    protected final DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat;
    protected final int[] keyProjection;
    protected final int[] valueProjection;
    @Nullable
    protected final String keyPrefix;
    protected final List<String> topics;
    protected final Pattern topicPattern;
    protected final Properties properties;
    protected final StartupMode startupMode;
    protected final Map<KafkaTopicPartition, Long> specificStartupOffsets;
    protected final long startupTimestampMillis;
    protected final boolean upsertMode;
    protected final String inlongMetric;
    protected final String auditHostAndPorts;
    private final DirtyOptions dirtyOptions;
    @Nullable
    private final DirtySink<String> dirtySink;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Logger LOG = LoggerFactory.getLogger(KafkaDynamicSource.class);

    public KafkaDynamicSource(DataType physicalDataType, @Nullable DecodingFormat<DeserializationSchema<RowData>> keyDecodingFormat, DecodingFormat<DeserializationSchema<RowData>> valueDecodingFormat, int[] keyProjection, int[] valueProjection, @Nullable String keyPrefix, @Nullable List<String> topics, @Nullable Pattern topicPattern, Properties properties, StartupMode startupMode, Map<KafkaTopicPartition, Long> specificStartupOffsets, long startupTimestampMillis, boolean upsertMode, String inlongMetric, String auditHostAndPorts, DirtyOptions dirtyOptions, @Nullable DirtySink<String> dirtySink) {
        this.physicalDataType = (DataType)Preconditions.checkNotNull((Object)physicalDataType, (String)"Physical data type must not be null.");
        this.keyDecodingFormat = keyDecodingFormat;
        this.valueDecodingFormat = (DecodingFormat)Preconditions.checkNotNull(valueDecodingFormat, (String)"Value decoding format must not be null.");
        this.keyProjection = (int[])Preconditions.checkNotNull((Object)keyProjection, (String)"Key projection must not be null.");
        this.valueProjection = (int[])Preconditions.checkNotNull((Object)valueProjection, (String)"Value projection must not be null.");
        this.keyPrefix = keyPrefix;
        this.producedDataType = physicalDataType;
        this.metadataKeys = Collections.emptyList();
        this.watermarkStrategy = null;
        Preconditions.checkArgument((topics != null && topicPattern == null || topics == null && topicPattern != null ? 1 : 0) != 0, (Object)"Either Topic or Topic Pattern must be set for source.");
        this.topics = topics;
        this.topicPattern = topicPattern;
        this.properties = (Properties)Preconditions.checkNotNull((Object)properties, (String)"Properties must not be null.");
        this.startupMode = (StartupMode)((Object)Preconditions.checkNotNull((Object)((Object)startupMode), (String)"Startup mode must not be null."));
        this.specificStartupOffsets = (Map)Preconditions.checkNotNull(specificStartupOffsets, (String)"Specific offsets must not be null.");
        this.startupTimestampMillis = startupTimestampMillis;
        this.upsertMode = upsertMode;
        this.inlongMetric = inlongMetric;
        this.auditHostAndPorts = auditHostAndPorts;
        this.dirtyOptions = dirtyOptions;
        this.dirtySink = dirtySink;
    }

    public ChangelogMode getChangelogMode() {
        return this.valueDecodingFormat.getChangelogMode();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext context) {
        DeserializationSchema<RowData> keyDeserialization = this.createDeserialization((DynamicTableSource.Context)context, this.keyDecodingFormat, this.keyProjection, this.keyPrefix);
        DeserializationSchema<RowData> valueDeserialization = this.createDeserialization((DynamicTableSource.Context)context, this.valueDecodingFormat, this.valueProjection, null);
        TypeInformation producedTypeInfo = context.createTypeInformation(this.producedDataType);
        FlinkKafkaConsumer<RowData> kafkaConsumer = this.createKafkaConsumer(keyDeserialization, valueDeserialization, (TypeInformation<RowData>)producedTypeInfo, this.inlongMetric, this.auditHostAndPorts);
        return SourceFunctionProvider.of(kafkaConsumer, (boolean)false);
    }

    public Map<String, DataType> listReadableMetadata() {
        LinkedHashMap<String, DataType> metadataMap = new LinkedHashMap<String, DataType>();
        this.valueDecodingFormat.listReadableMetadata().forEach((key, value) -> metadataMap.put(VALUE_METADATA_PREFIX + key, (DataType)value));
        Stream.of(ReadableMetadata.values()).forEachOrdered(m -> metadataMap.putIfAbsent(m.key, m.dataType));
        return metadataMap;
    }

    public void applyReadableMetadata(List<String> metadataKeys, DataType producedDataType) {
        List formatMetadataKeys = metadataKeys.stream().filter(k -> k.startsWith(VALUE_METADATA_PREFIX)).collect(Collectors.toList());
        ArrayList<String> connectorMetadataKeys = new ArrayList<String>(metadataKeys);
        connectorMetadataKeys.removeAll(formatMetadataKeys);
        Map formatMetadata = this.valueDecodingFormat.listReadableMetadata();
        if (formatMetadata.size() > 0) {
            List requestedFormatMetadataKeys = formatMetadataKeys.stream().map(k -> k.substring(VALUE_METADATA_PREFIX.length())).collect(Collectors.toList());
            this.valueDecodingFormat.applyReadableMetadata(requestedFormatMetadataKeys);
        }
        this.metadataKeys = connectorMetadataKeys;
        this.producedDataType = producedDataType;
    }

    public void applyWatermark(WatermarkStrategy<RowData> watermarkStrategy) {
        this.watermarkStrategy = watermarkStrategy;
    }

    public DynamicTableSource copy() {
        KafkaDynamicSource copy = new KafkaDynamicSource(this.physicalDataType, this.keyDecodingFormat, this.valueDecodingFormat, this.keyProjection, this.valueProjection, this.keyPrefix, this.topics, this.topicPattern, this.properties, this.startupMode, this.specificStartupOffsets, this.startupTimestampMillis, this.upsertMode, this.inlongMetric, this.auditHostAndPorts, this.dirtyOptions, this.dirtySink);
        copy.producedDataType = this.producedDataType;
        copy.metadataKeys = this.metadataKeys;
        copy.watermarkStrategy = this.watermarkStrategy;
        return copy;
    }

    public String asSummaryString() {
        return "Kafka table source";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaDynamicSource that = (KafkaDynamicSource)o;
        return Objects.equals(this.producedDataType, that.producedDataType) && Objects.equals(this.metadataKeys, that.metadataKeys) && Objects.equals(this.physicalDataType, that.physicalDataType) && Objects.equals(this.keyDecodingFormat, that.keyDecodingFormat) && Objects.equals(this.valueDecodingFormat, that.valueDecodingFormat) && Arrays.equals(this.keyProjection, that.keyProjection) && Arrays.equals(this.valueProjection, that.valueProjection) && Objects.equals(this.keyPrefix, that.keyPrefix) && Objects.equals(this.topics, that.topics) && Objects.equals(String.valueOf(this.topicPattern), String.valueOf(that.topicPattern)) && Objects.equals(this.properties, that.properties) && this.startupMode == that.startupMode && Objects.equals(this.specificStartupOffsets, that.specificStartupOffsets) && this.startupTimestampMillis == that.startupTimestampMillis && Objects.equals(this.upsertMode, that.upsertMode) && Objects.equals(this.watermarkStrategy, that.watermarkStrategy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.producedDataType, this.metadataKeys, this.physicalDataType, this.keyDecodingFormat, this.valueDecodingFormat, this.keyProjection, this.valueProjection, this.keyPrefix, this.topics, this.topicPattern, this.properties, this.startupMode, this.specificStartupOffsets, this.startupTimestampMillis, this.upsertMode, this.watermarkStrategy});
    }

    protected FlinkKafkaConsumer<RowData> createKafkaConsumer(DeserializationSchema<RowData> keyDeserialization, DeserializationSchema<RowData> valueDeserialization, TypeInformation<RowData> producedTypeInfo, String inlongMetric, String auditHostAndPorts) {
        DynamicKafkaDeserializationSchema.MetadataConverter[] metadataConverters = (DynamicKafkaDeserializationSchema.MetadataConverter[])this.metadataKeys.stream().map(k -> Stream.of(ReadableMetadata.values()).filter(rm -> rm.key.equals(k)).findFirst().orElseThrow(IllegalStateException::new)).map(m -> m.converter).toArray(DynamicKafkaDeserializationSchema.MetadataConverter[]::new);
        boolean hasMetadata = this.metadataKeys.size() > 0;
        int adjustedPhysicalArity = this.producedDataType.getChildren().size() - this.metadataKeys.size();
        int[] adjustedValueProjection = IntStream.concat(IntStream.of(this.valueProjection), IntStream.range(this.keyProjection.length + this.valueProjection.length, adjustedPhysicalArity)).toArray();
        DynamicKafkaDeserializationSchema kafkaDeserializer = new DynamicKafkaDeserializationSchema(adjustedPhysicalArity, keyDeserialization, this.keyProjection, valueDeserialization, adjustedValueProjection, hasMetadata, metadataConverters, producedTypeInfo, this.upsertMode, this.dirtyOptions, this.dirtySink);
        FlinkKafkaConsumer<RowData> kafkaConsumer = this.topics != null ? new FlinkKafkaConsumer<RowData>(this.topics, kafkaDeserializer, this.properties, inlongMetric, auditHostAndPorts) : new FlinkKafkaConsumer<RowData>(this.topicPattern, kafkaDeserializer, this.properties, inlongMetric, auditHostAndPorts);
        switch (this.startupMode) {
            case EARLIEST: {
                kafkaConsumer.setStartFromEarliest();
                break;
            }
            case LATEST: {
                kafkaConsumer.setStartFromLatest();
                break;
            }
            case GROUP_OFFSETS: {
                kafkaConsumer.setStartFromGroupOffsets();
                break;
            }
            case SPECIFIC_OFFSETS: {
                kafkaConsumer.setStartFromSpecificOffsets(this.specificStartupOffsets);
                break;
            }
            case TIMESTAMP: {
                kafkaConsumer.setStartFromTimestamp(this.startupTimestampMillis);
            }
        }
        kafkaConsumer.setCommitOffsetsOnCheckpoints(this.properties.getProperty("group.id") != null);
        if (this.watermarkStrategy != null) {
            kafkaConsumer.assignTimestampsAndWatermarks(this.watermarkStrategy);
        }
        return kafkaConsumer;
    }

    @Nullable
    private DeserializationSchema<RowData> createDeserialization(DynamicTableSource.Context context, @Nullable DecodingFormat<DeserializationSchema<RowData>> format, int[] projection, @Nullable String prefix) {
        if (format == null) {
            return null;
        }
        DataType physicalFormatDataType = DataTypeUtils.projectRow((DataType)this.physicalDataType, (int[])projection);
        if (prefix != null) {
            physicalFormatDataType = DataTypeUtils.stripRowPrefix((DataType)physicalFormatDataType, (String)prefix);
        }
        return (DeserializationSchema)format.createRuntimeDecoder(context, physicalFormatDataType);
    }

    static enum ReadableMetadata {
        TOPIC("topic", (DataType)DataTypes.STRING().notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return StringData.fromString((String)record.topic());
            }
        }),
        PARTITION("partition", (DataType)DataTypes.INT().notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return record.partition();
            }
        }),
        HEADERS("headers", (DataType)DataTypes.MAP((DataType)((DataType)DataTypes.STRING().nullable()), (DataType)((DataType)DataTypes.BYTES().nullable())).notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                HashMap<StringData, byte[]> map = new HashMap<StringData, byte[]>();
                for (Header header : record.headers()) {
                    map.put(StringData.fromString((String)header.key()), header.value());
                }
                return new GenericMapData(map);
            }
        }),
        LEADER_EPOCH("leader-epoch", (DataType)DataTypes.INT().nullable(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return record.leaderEpoch().orElse(null);
            }
        }),
        OFFSET("offset", (DataType)DataTypes.BIGINT().notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return record.offset();
            }
        }),
        TIMESTAMP("timestamp", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)3).notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return TimestampData.fromEpochMillis((long)record.timestamp());
            }
        }),
        HEADERS_TO_JSON_STR("headers_to_json_str", (DataType)DataTypes.STRING().nullable(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                HashMap<String, String> headerMap = new HashMap<String, String>();
                for (Header header : record.headers()) {
                    headerMap.put(header.key(), new String(header.value(), StandardCharsets.UTF_8));
                }
                try {
                    return StringData.fromString((String)MAPPER.writeValueAsString(headerMap));
                }
                catch (JsonProcessingException e) {
                    LOG.warn("Failed to parse headers to json string", (Throwable)e);
                    return null;
                }
            }
        }),
        KEY("key", (DataType)DataTypes.STRING().notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return StringData.fromBytes((byte[])((byte[])record.key()));
            }
        }),
        VALUE("value", (DataType)DataTypes.STRING().notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return StringData.fromBytes((byte[])((byte[])record.value()));
            }
        }),
        TIMESTAMP_TYPE("timestamp-type", (DataType)DataTypes.STRING().notNull(), new DynamicKafkaDeserializationSchema.MetadataConverter(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object read(ConsumerRecord<?, ?> record) {
                return StringData.fromString((String)record.timestampType().toString());
            }
        });

        final String key;
        final DataType dataType;
        final DynamicKafkaDeserializationSchema.MetadataConverter converter;

        private ReadableMetadata(String key, DataType dataType, DynamicKafkaDeserializationSchema.MetadataConverter converter) {
            this.key = key;
            this.dataType = dataType;
            this.converter = converter;
        }
    }
}

