/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.util;

import java.util.LinkedHashMap;
import java.util.Map;

public final class LabelUtils {
    private LabelUtils() {
    }

    public static Map<String, String> parseLabels(String labels) {
        return LabelUtils.parseLabels(labels, new LinkedHashMap<String, String>());
    }

    public static Map<String, String> parseLabels(String labels, Map<String, String> labelMap) {
        String[] labelArray;
        if (labelMap == null) {
            labelMap = new LinkedHashMap<String, String>();
        }
        if (labels == null || labels.length() == 0) {
            return labelMap;
        }
        for (String label : labelArray = labels.split("&")) {
            int index = label.indexOf("=");
            if (index < 1 || index == label.length() - 1) {
                throw new IllegalArgumentException("The format of labels must be like 'key1=value1&key2=value2...'");
            }
            labelMap.put(label.substring(0, index), label.substring(index + 1));
        }
        return labelMap;
    }
}

