/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.sink;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Preconditions;

public interface TableChange {

    public static final class UnknownColumnChange
    implements ColumnChange {
        private String description;

        public UnknownColumnChange(String description) {
            this.description = description;
        }

        @Override
        public String[] fieldNames() {
            return new String[0];
        }

        public String toString() {
            return this.description;
        }
    }

    public static final class DeleteColumn
    implements ColumnChange {
        @Override
        public String[] fieldNames() {
            return new String[0];
        }
    }

    public static final class AddColumn
    implements ColumnChange {
        private final String[] fieldNames;
        private final LogicalType dataType;
        private final boolean isNullable;
        private final String comment;
        private final ColumnPosition position;

        public AddColumn(String[] fieldNames, LogicalType dataType, boolean isNullable, String comment, ColumnPosition position) {
            Preconditions.checkArgument((fieldNames.length > 0 ? 1 : 0) != 0, (Object)"Invalid field name: at least one name is required");
            this.fieldNames = fieldNames;
            this.dataType = dataType;
            this.isNullable = isNullable;
            this.comment = comment;
            this.position = position;
        }

        @Override
        public String[] fieldNames() {
            return this.fieldNames;
        }

        public LogicalType dataType() {
            return this.dataType;
        }

        public boolean isNullable() {
            return this.isNullable;
        }

        @Nullable
        public String comment() {
            return this.comment;
        }

        @Nullable
        public ColumnPosition position() {
            return this.position;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AddColumn addColumn = (AddColumn)o;
            return this.isNullable == addColumn.isNullable && Arrays.equals(this.fieldNames, addColumn.fieldNames) && this.dataType.equals((Object)addColumn.dataType) && Objects.equals(this.comment, addColumn.comment) && Objects.equals(this.position, addColumn.position);
        }

        public int hashCode() {
            int result = Objects.hash(this.dataType, this.isNullable, this.comment, this.position);
            result = 31 * result + Arrays.hashCode(this.fieldNames);
            return result;
        }

        public String toString() {
            return String.format("ADD COLUMNS `%s` %s %s %s %s", this.fieldNames[this.fieldNames.length - 1], this.dataType, this.isNullable ? "" : "NOT NULL", this.comment, this.position);
        }
    }

    public static interface ColumnChange
    extends TableChange {
        public String[] fieldNames();
    }

    public static interface ColumnPosition {
        public static ColumnPosition first() {
            return First.INSTANCE;
        }

        public static ColumnPosition after(String column) {
            return new After(column);
        }
    }

    public static final class After
    implements ColumnPosition {
        private final String column;

        private After(String column) {
            assert (column != null);
            this.column = column;
        }

        public String column() {
            return this.column;
        }

        public String toString() {
            return "AFTER " + this.column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            After after = (After)o;
            return this.column.equals(after.column);
        }

        public int hashCode() {
            return Objects.hash(this.column);
        }
    }

    public static final class First
    implements ColumnPosition {
        private static final First INSTANCE = new First();

        private First() {
        }

        public String toString() {
            return "FIRST";
        }
    }
}

