/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.metric.phase;

import java.util.Map;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.MetricGroup;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.metric.MetricData;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.metric.MetricOption;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.metric.ThreadSafeCounter;

public class ReadPhaseMetricData
implements MetricData {
    private final MetricGroup metricGroup;
    private Counter readPhaseTimestamp;
    private final Map<String, String> labels;

    public ReadPhaseMetricData(MetricOption option, MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        this.labels = option.getLabels();
        ThreadSafeCounter readPhaseCounter = new ThreadSafeCounter();
        readPhaseCounter.inc(option.getReadPhase());
        this.registerMetricsForReadPhase(readPhaseCounter);
    }

    private void registerMetricsForReadPhase(Counter counter) {
        this.readPhaseTimestamp = this.registerCounter("readPhaseTimestamp", counter);
    }

    @Override
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Counter getReadPhase() {
        return this.readPhaseTimestamp;
    }

    public void outputMetrics() {
        long count;
        if (this.readPhaseTimestamp != null && (count = this.readPhaseTimestamp.getCount()) == 0L) {
            this.readPhaseTimestamp.inc(System.currentTimeMillis());
        }
    }

    public String toString() {
        return "ReadPhaseMetricData{metricGroup=" + this.metricGroup + ", labels=" + this.labels + ", readPhaseTimestamp=" + this.readPhaseTimestamp.getCount() + '}';
    }
}

