/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.format;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.types.RowKind;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.format.JsonDynamicSchemaFormat;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.format.JsonToRowDataConverters;

public class CanalJsonDynamicSchemaFormat
extends JsonDynamicSchemaFormat {
    private static final String DDL_FLAG = "ddl";
    private static final String DATA = "data";
    private static final String OLD = "old";
    private static final String PK_NAMES = "pkNames";
    private static final String SCHEMA = "sqlType";
    private static final String OP_TYPE = "type";
    private static final String OP_INSERT = "INSERT";
    private static final String OP_UPDATE = "UPDATE";
    private static final String OP_DELETE = "DELETE";

    protected CanalJsonDynamicSchemaFormat(Map<String, String> props) {
        super(props);
    }

    @Override
    public JsonNode getUpdateAfter(JsonNode root) {
        return root.get(DATA);
    }

    @Override
    public JsonNode getUpdateBefore(JsonNode root) {
        return root.get(OLD);
    }

    @Override
    public List<RowKind> opType2RowKind(String opType) {
        ArrayList<RowKind> rowKinds = new ArrayList<RowKind>();
        switch (opType) {
            case "INSERT": {
                rowKinds.add(RowKind.INSERT);
                break;
            }
            case "UPDATE": {
                rowKinds.add(RowKind.UPDATE_BEFORE);
                rowKinds.add(RowKind.UPDATE_AFTER);
                break;
            }
            case "DELETE": {
                rowKinds.add(RowKind.DELETE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported op_type: " + opType);
            }
        }
        return rowKinds;
    }

    @Override
    public String getOpType(JsonNode root) {
        JsonNode opNode = root.get(OP_TYPE);
        if (opNode == null) {
            throw new IllegalArgumentException(String.format("Error node: %s, %s is null", root, OP_TYPE));
        }
        return opNode.asText();
    }

    @Override
    public List<String> extractPrimaryKeyNames(JsonNode data) {
        JsonNode pkNamesNode = data.get(PK_NAMES);
        ArrayList<String> pkNames = new ArrayList<String>();
        if (pkNamesNode != null && pkNamesNode.isArray()) {
            for (int i = 0; i < pkNamesNode.size(); ++i) {
                pkNames.add(pkNamesNode.get(i).asText());
            }
        }
        return pkNames;
    }

    @Override
    public boolean extractDDLFlag(JsonNode data) {
        return data.has(DDL_FLAG) && data.get(DDL_FLAG).asBoolean(false);
    }

    @Override
    public RowType extractSchema(JsonNode data, List<String> pkNames) {
        JsonNode schema = data.get(SCHEMA);
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Not found schema from: %s", data));
        }
        return this.extractSchemaNode(schema, pkNames);
    }

    @Override
    public List<RowData> extractRowData(JsonNode data, RowType rowType) {
        JsonNode opNode = data.get(OP_TYPE);
        JsonNode dataNode = data.get(DATA);
        JsonNode oldNode = data.get(OLD);
        if (opNode == null || dataNode == null || !dataNode.isArray()) {
            throw new IllegalArgumentException(String.format("Error opNode: %s, or dataNode: %s", opNode, dataNode));
        }
        String op = data.get(OP_TYPE).asText();
        JsonToRowDataConverters.JsonToRowDataConverter rowDataConverter = this.rowDataConverters.createConverter((LogicalType)rowType);
        ArrayList<RowData> rowDataList = new ArrayList<RowData>();
        if (OP_INSERT.equals(op)) {
            for (JsonNode row : dataNode) {
                RowData rowData = (RowData)rowDataConverter.convert(row);
                rowData.setRowKind(RowKind.INSERT);
                rowDataList.add(rowData);
            }
        } else if (OP_UPDATE.equals(op)) {
            for (int i = 0; i < dataNode.size(); ++i) {
                GenericRowData after = (GenericRowData)rowDataConverter.convert(dataNode.get(i));
                if (oldNode != null) {
                    GenericRowData before = (GenericRowData)rowDataConverter.convert(oldNode.get(i));
                    for (int f = 0; f < rowType.getFieldCount(); ++f) {
                        if (!before.isNullAt(f) || oldNode.get(i).findValue((String)rowType.getFieldNames().get(f)) != null) continue;
                        before.setField(f, after.getField(f));
                    }
                    before.setRowKind(RowKind.UPDATE_BEFORE);
                    rowDataList.add((RowData)before);
                }
                after.setRowKind(RowKind.UPDATE_AFTER);
                rowDataList.add((RowData)after);
            }
        } else if (OP_DELETE.equals(op)) {
            for (JsonNode row : dataNode) {
                RowData rowData = (RowData)rowDataConverter.convert(row);
                rowData.setRowKind(RowKind.DELETE);
                rowDataList.add(rowData);
            }
        } else {
            throw new IllegalArgumentException("Unsupported op_type: " + op);
        }
        return rowDataList;
    }
}

