/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.kafka.partitioner;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.format.AbstractDynamicSchemaFormat;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.format.DynamicSchemaFormatFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawDataHashPartitioner<T>
extends FlinkKafkaPartitioner<T> {
    public static final String PRIMARY_KEY = "PRIMARY_KEY";
    private static final Logger LOG = LoggerFactory.getLogger(RawDataHashPartitioner.class);
    private static final long serialVersionUID = 1L;
    private String partitionPattern;
    private String sinkMultipleFormat;
    private AbstractDynamicSchemaFormat dynamicSchemaFormat;

    @Override
    public void open(int parallelInstanceId, int parallelInstances) {
        super.open(parallelInstanceId, parallelInstances);
        this.dynamicSchemaFormat = DynamicSchemaFormatFactory.getFormat(this.sinkMultipleFormat);
    }

    @Override
    public int partition(T record, byte[] key, byte[] value, String targetTopic, int[] partitions) {
        Preconditions.checkArgument((partitions != null && partitions.length > 0 ? 1 : 0) != 0, (Object)"Partitions of the target topic is empty.");
        int partition = 0;
        try {
            String partitionKey;
            if (PRIMARY_KEY.equals(this.partitionPattern)) {
                List<String> values = this.dynamicSchemaFormat.extractPrimaryKeyValues(value);
                if (values == null || values.isEmpty()) {
                    return partition;
                }
                partitionKey = StringUtils.join(values, (String)"");
            } else {
                partitionKey = this.dynamicSchemaFormat.parse(value, this.partitionPattern);
            }
            partition = partitions[(partitionKey.hashCode() & Integer.MAX_VALUE) % partitions.length];
        }
        catch (Exception e) {
            LOG.warn("Extract partition failed", (Throwable)e);
        }
        return partition;
    }

    public boolean equals(Object o) {
        return o instanceof RawDataHashPartitioner;
    }

    public int hashCode() {
        return RawDataHashPartitioner.class.hashCode();
    }

    public String getPartitionPattern() {
        return this.partitionPattern;
    }

    public void setPartitionPattern(String partitionPattern) {
        this.partitionPattern = partitionPattern;
    }

    public String getSinkMultipleFormat() {
        return this.sinkMultipleFormat;
    }

    public void setSinkMultipleFormat(String sinkMultipleFormat) {
        this.sinkMultipleFormat = sinkMultipleFormat;
    }
}

