/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.kafka;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.streaming.connectors.kafka.KafkaContextAware;
import org.apache.flink.streaming.connectors.kafka.KafkaSerializationSchema;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.formats.raw.RawFormatSerializationSchema;
import org.apache.flink.types.RowKind;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.kafka.KafkaDynamicSink;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.dirty.DirtyData;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.dirty.DirtyOptions;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.dirty.DirtyType;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.dirty.sink.DirtySink;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.format.DynamicSchemaFormatFactory;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.format.JsonDynamicSchemaFormat;
import org.apache.inlong.sort.kafka.shaded.org.apache.inlong.sort.base.metric.sub.SinkTopicMetricData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicKafkaSerializationSchema
implements KafkaSerializationSchema<RowData>,
KafkaContextAware<RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DynamicKafkaSerializationSchema.class);
    @Nullable
    private final FlinkKafkaPartitioner<RowData> partitioner;
    private final String topic;
    @Nullable
    private final SerializationSchema<RowData> keySerialization;
    private final SerializationSchema<RowData> valueSerialization;
    private final RowData.FieldGetter[] keyFieldGetters;
    private final RowData.FieldGetter[] valueFieldGetters;
    private final boolean hasMetadata;
    private final boolean upsertMode;
    private final String topicPattern;
    private final int[] metadataPositions;
    private final String sinkMultipleFormat;
    private boolean multipleSink;
    private JsonDynamicSchemaFormat jsonDynamicSchemaFormat;
    private final DirtyOptions dirtyOptions;
    @Nullable
    private final DirtySink<Object> dirtySink;
    private int[] partitions;
    private int parallelInstanceId;
    private int numParallelInstances;
    private SinkTopicMetricData metricData;

    DynamicKafkaSerializationSchema(String topic, @Nullable FlinkKafkaPartitioner<RowData> partitioner, @Nullable SerializationSchema<RowData> keySerialization, SerializationSchema<RowData> valueSerialization, RowData.FieldGetter[] keyFieldGetters, RowData.FieldGetter[] valueFieldGetters, boolean hasMetadata, int[] metadataPositions, boolean upsertMode, @Nullable String sinkMultipleFormat, @Nullable String topicPattern, DirtyOptions dirtyOptions, @Nullable DirtySink<Object> dirtySink) {
        if (upsertMode) {
            Preconditions.checkArgument((keySerialization != null && keyFieldGetters.length > 0 ? 1 : 0) != 0, (Object)"Key must be set in upsert mode for serialization schema.");
        }
        this.topic = topic;
        this.partitioner = partitioner;
        this.keySerialization = keySerialization;
        this.valueSerialization = valueSerialization;
        this.keyFieldGetters = keyFieldGetters;
        this.valueFieldGetters = valueFieldGetters;
        this.hasMetadata = hasMetadata;
        this.metadataPositions = metadataPositions;
        this.upsertMode = upsertMode;
        this.sinkMultipleFormat = sinkMultipleFormat;
        this.topicPattern = topicPattern;
        this.dirtyOptions = dirtyOptions;
        this.dirtySink = dirtySink;
    }

    public void setMetricData(SinkTopicMetricData metricData) {
        this.metricData = metricData;
    }

    static RowData createProjectedRow(RowData consumedRow, RowKind kind, RowData.FieldGetter[] fieldGetters) {
        int arity = fieldGetters.length;
        GenericRowData genericRowData = new GenericRowData(kind, arity);
        for (int fieldPos = 0; fieldPos < arity; ++fieldPos) {
            genericRowData.setField(fieldPos, fieldGetters[fieldPos].getFieldOrNull(consumedRow));
        }
        return genericRowData;
    }

    @Override
    public void open(SerializationSchema.InitializationContext context) throws Exception {
        if (this.keySerialization != null) {
            this.keySerialization.open(context);
        }
        this.valueSerialization.open(context);
        if (this.partitioner != null) {
            this.partitioner.open(this.parallelInstanceId, this.numParallelInstances);
        }
        if (this.dirtySink != null) {
            this.dirtySink.open(new Configuration());
        }
        if (this.valueSerialization instanceof RawFormatSerializationSchema && StringUtils.isNotBlank((CharSequence)this.sinkMultipleFormat)) {
            this.multipleSink = true;
            this.jsonDynamicSchemaFormat = (JsonDynamicSchemaFormat)DynamicSchemaFormatFactory.getFormat(this.sinkMultipleFormat);
        }
    }

    @Override
    public ProducerRecord<byte[], byte[]> serialize(RowData consumedRow, @Nullable Long timestamp) {
        byte[] valueSerialized;
        byte[] keySerialized;
        if (this.keySerialization == null && !this.hasMetadata) {
            byte[] valueSerialized2 = this.serializeWithDirtyHandle(consumedRow, DirtyType.VALUE_SERIALIZE_ERROR, this.valueSerialization);
            if (valueSerialized2 != null) {
                return new ProducerRecord<Object, byte[]>(this.getTargetTopic(consumedRow), this.extractPartition(consumedRow, null, valueSerialized2), null, valueSerialized2);
            }
            return null;
        }
        boolean mayDirtyData = false;
        if (this.keySerialization == null) {
            keySerialized = null;
        } else {
            RowData keyRow = DynamicKafkaSerializationSchema.createProjectedRow(consumedRow, RowKind.INSERT, this.keyFieldGetters);
            keySerialized = this.serializeWithDirtyHandle(keyRow, DirtyType.KEY_SERIALIZE_ERROR, this.keySerialization);
            mayDirtyData = keySerialized == null;
        }
        RowKind kind = consumedRow.getRowKind();
        RowData valueRow = DynamicKafkaSerializationSchema.createProjectedRow(consumedRow, kind, this.valueFieldGetters);
        if (this.upsertMode) {
            if (kind == RowKind.DELETE || kind == RowKind.UPDATE_BEFORE) {
                valueSerialized = null;
            } else {
                valueRow.setRowKind(RowKind.INSERT);
                valueSerialized = this.serializeWithDirtyHandle(valueRow, DirtyType.VALUE_SERIALIZE_ERROR, this.valueSerialization);
                mayDirtyData = mayDirtyData || valueSerialized == null;
            }
        } else {
            valueSerialized = this.serializeWithDirtyHandle(valueRow, DirtyType.VALUE_SERIALIZE_ERROR, this.valueSerialization);
            boolean bl = mayDirtyData = mayDirtyData || valueSerialized == null;
        }
        if (mayDirtyData) {
            return null;
        }
        return new ProducerRecord<byte[], byte[]>(this.getTargetTopic(consumedRow), this.extractPartition(consumedRow, keySerialized, valueSerialized), (Long)this.readMetadata(consumedRow, KafkaDynamicSink.WritableMetadata.TIMESTAMP), keySerialized, valueSerialized, (Iterable)this.readMetadata(consumedRow, KafkaDynamicSink.WritableMetadata.HEADERS));
    }

    private byte[] serializeWithDirtyHandle(RowData consumedRow, DirtyType dirtyType, SerializationSchema<RowData> serialization) {
        if (!this.dirtyOptions.ignoreDirty()) {
            return serialization.serialize((Object)consumedRow);
        }
        byte[] value = null;
        try {
            value = serialization.serialize((Object)consumedRow);
        }
        catch (Exception e) {
            LOG.error(String.format("serialize error, raw data: %s", consumedRow.toString()), (Throwable)e);
            if (this.dirtySink != null) {
                DirtyData.Builder<RowData> builder = DirtyData.builder();
                try {
                    builder.setData(consumedRow).setDirtyType(dirtyType).setLabels(this.dirtyOptions.getLabels()).setLogTag(this.dirtyOptions.getLogTag()).setDirtyMessage(e.getMessage()).setIdentifier(this.dirtyOptions.getIdentifier());
                    this.dirtySink.invoke(builder.build());
                }
                catch (Exception ex) {
                    if (!this.dirtyOptions.ignoreSideOutputErrors()) {
                        throw new RuntimeException(ex);
                    }
                    LOG.warn("Dirty sink failed", (Throwable)ex);
                }
            }
            this.metricData.invokeDirtyWithEstimate(consumedRow);
        }
        return value;
    }

    private void serializeWithDirtyHandle(Map<String, Object> baseMap, JsonNode rootNode, JsonNode dataNode, List<ProducerRecord<byte[], byte[]>> values) {
        String topic = null;
        try {
            byte[] data = this.jsonDynamicSchemaFormat.objectMapper.writeValueAsBytes(baseMap);
            topic = this.jsonDynamicSchemaFormat.parse(rootNode, this.topicPattern);
            values.add(new ProducerRecord<Object, byte[]>(topic, this.extractPartition(null, null, data), null, data));
        }
        catch (Exception e) {
            LOG.error(String.format("serialize error, raw data: %s", baseMap), (Throwable)e);
            if (!this.dirtyOptions.ignoreDirty()) {
                throw new RuntimeException(e);
            }
            if (this.dirtySink != null) {
                DirtyData.Builder<JsonNode> builder = DirtyData.builder();
                try {
                    builder.setData(dataNode).setDirtyType(DirtyType.VALUE_DESERIALIZE_ERROR).setLabels(this.jsonDynamicSchemaFormat.parse(rootNode, this.dirtyOptions.getLabels())).setLogTag(this.jsonDynamicSchemaFormat.parse(rootNode, this.dirtyOptions.getLogTag())).setDirtyMessage(e.getMessage()).setIdentifier(this.jsonDynamicSchemaFormat.parse(rootNode, this.dirtyOptions.getIdentifier()));
                    this.dirtySink.invoke(builder.build());
                }
                catch (Exception ex) {
                    if (!this.dirtyOptions.ignoreSideOutputErrors()) {
                        throw new RuntimeException(ex);
                    }
                    LOG.warn("Dirty sink failed", (Throwable)ex);
                }
            }
            this.metricData.sendOutMetrics(topic, 1L, dataNode.toString().getBytes(StandardCharsets.UTF_8).length);
        }
    }

    public List<ProducerRecord<byte[], byte[]>> serializeForList(RowData consumedRow, @Nullable Long timestamp) {
        ArrayList<ProducerRecord<byte[], byte[]>> values = new ArrayList<ProducerRecord<byte[], byte[]>>();
        if (!this.multipleSink) {
            ProducerRecord<byte[], byte[]> value = this.serialize(consumedRow, timestamp);
            if (value != null) {
                values.add(value);
            }
            return values;
        }
        String topic = null;
        try {
            JsonNode updateAfterNode;
            JsonNode rootNode = this.jsonDynamicSchemaFormat.deserialize(consumedRow.getBinary(0));
            boolean isDDL = this.jsonDynamicSchemaFormat.extractDDLFlag(rootNode);
            if (isDDL) {
                values.add(new ProducerRecord<Object, byte[]>(this.jsonDynamicSchemaFormat.parse(rootNode, this.topicPattern), this.extractPartition(consumedRow, null, consumedRow.getBinary(0)), null, consumedRow.getBinary(0)));
                return values;
            }
            JsonNode updateBeforeNode = this.jsonDynamicSchemaFormat.getUpdateBefore(rootNode);
            if (!this.splitRequired(updateBeforeNode, updateAfterNode = this.jsonDynamicSchemaFormat.getUpdateAfter(rootNode))) {
                topic = this.jsonDynamicSchemaFormat.parse(rootNode, this.topicPattern);
                values.add(new ProducerRecord<Object, byte[]>(topic, this.extractPartition(consumedRow, null, consumedRow.getBinary(0)), null, consumedRow.getBinary(0)));
            } else {
                this.split2JsonArray(rootNode, updateBeforeNode, updateAfterNode, values);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("serialize error, raw data: %s", new String(consumedRow.getBinary(0))), (Throwable)e);
            if (!this.dirtyOptions.ignoreDirty()) {
                throw new RuntimeException(e);
            }
            if (this.dirtySink != null) {
                DirtyData.Builder<String> builder = DirtyData.builder();
                try {
                    builder.setData(new String(consumedRow.getBinary(0))).setDirtyType(DirtyType.VALUE_DESERIALIZE_ERROR).setLabels(this.dirtyOptions.getLabels()).setLogTag(this.dirtyOptions.getLogTag()).setIdentifier(this.dirtyOptions.getIdentifier());
                    this.dirtySink.invoke(builder.build());
                }
                catch (Exception ex) {
                    if (!this.dirtyOptions.ignoreSideOutputErrors()) {
                        throw new RuntimeException(ex);
                    }
                    LOG.warn("Dirty sink failed", (Throwable)ex);
                }
            }
            this.metricData.sendDirtyMetrics(topic, 1L, consumedRow.getBinary(0).length);
        }
        return values;
    }

    private boolean splitRequired(JsonNode updateBeforeNode, JsonNode updateAfterNode) {
        return updateAfterNode != null && updateAfterNode.isArray() && updateAfterNode.size() > 1 || updateBeforeNode != null && updateBeforeNode.isArray() && updateBeforeNode.size() > 1;
    }

    private void split2JsonArray(JsonNode rootNode, JsonNode updateBeforeNode, JsonNode updateAfterNode, List<ProducerRecord<byte[], byte[]>> values) {
        Iterator iterator = rootNode.fields();
        LinkedHashMap<String, Object> baseMap = new LinkedHashMap<String, Object>();
        String updateBeforeKey = null;
        String updateAfterKey = null;
        while (iterator.hasNext()) {
            Map.Entry kv = (Map.Entry)iterator.next();
            if (kv.getValue() == null || !((JsonNode)kv.getValue()).equals((Object)updateBeforeNode) && !((JsonNode)kv.getValue()).equals((Object)updateAfterNode)) {
                baseMap.put((String)kv.getKey(), kv.getValue());
                continue;
            }
            if (((JsonNode)kv.getValue()).equals((Object)updateAfterNode)) {
                updateAfterKey = (String)kv.getKey();
                continue;
            }
            if (!((JsonNode)kv.getValue()).equals((Object)updateBeforeNode)) continue;
            updateBeforeKey = (String)kv.getKey();
        }
        if (updateAfterNode != null) {
            for (int i = 0; i < updateAfterNode.size(); ++i) {
                baseMap.put(updateAfterKey, Collections.singletonList(updateAfterNode.get(i)));
                if (updateBeforeNode != null && updateBeforeNode.size() > i) {
                    baseMap.put(updateBeforeKey, Collections.singletonList(updateBeforeNode.get(i)));
                } else if (updateBeforeKey != null) {
                    baseMap.remove(updateBeforeKey);
                }
                this.serializeWithDirtyHandle(baseMap, rootNode, updateAfterNode.get(i), values);
            }
        } else {
            for (int i = 0; i < updateBeforeNode.size(); ++i) {
                baseMap.put(updateBeforeKey, Collections.singletonList(updateBeforeNode.get(i)));
                this.serializeWithDirtyHandle(baseMap, rootNode, updateBeforeNode.get(i), values);
            }
        }
    }

    @Override
    public void setParallelInstanceId(int parallelInstanceId) {
        this.parallelInstanceId = parallelInstanceId;
    }

    @Override
    public void setNumParallelInstances(int numParallelInstances) {
        this.numParallelInstances = numParallelInstances;
    }

    @Override
    public void setPartitions(int[] partitions) {
        this.partitions = partitions;
    }

    @Override
    public String getTargetTopic(RowData element) {
        if (this.multipleSink) {
            try {
                return this.jsonDynamicSchemaFormat.parse(element.getBinary(0), this.topicPattern);
            }
            catch (Exception e) {
                LOG.warn("parse dynamic topic error", (Throwable)e);
            }
        }
        return this.topic;
    }

    private <T> T readMetadata(RowData consumedRow, KafkaDynamicSink.WritableMetadata metadata) {
        int pos = this.metadataPositions[metadata.ordinal()];
        if (pos < 0) {
            return null;
        }
        return (T)metadata.converter.read(consumedRow, pos);
    }

    private Integer extractPartition(RowData consumedRow, @Nullable byte[] keySerialized, byte[] valueSerialized) {
        if (this.partitioner != null) {
            return this.partitioner.partition(consumedRow, keySerialized, valueSerialized, this.topic, this.partitions);
        }
        return null;
    }

    static interface MetadataConverter
    extends Serializable {
        public Object read(RowData var1, int var2);
    }
}

