/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.UpdateFeaturesResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.ApiError;

public class UpdateFeaturesResponse
extends AbstractResponse {
    private final UpdateFeaturesResponseData data;

    public UpdateFeaturesResponse(UpdateFeaturesResponseData data) {
        this.data = data;
    }

    public UpdateFeaturesResponse(Struct struct) {
        short latestVersion = (short)(UpdateFeaturesResponseData.SCHEMAS.length - 1);
        this.data = new UpdateFeaturesResponseData(struct, latestVersion);
    }

    public UpdateFeaturesResponse(Struct struct, short version) {
        this.data = new UpdateFeaturesResponseData(struct, version);
    }

    public Map<String, ApiError> errors() {
        return this.data.results().valuesSet().stream().collect(Collectors.toMap(result -> result.feature(), result -> new ApiError(Errors.forCode(result.errorCode()), result.errorMessage())));
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.apiErrorCounts(this.errors());
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public String toString() {
        return this.data.toString();
    }

    public UpdateFeaturesResponseData data() {
        return this.data;
    }

    public static UpdateFeaturesResponse parse(ByteBuffer buffer, short version) {
        return new UpdateFeaturesResponse(ApiKeys.UPDATE_FEATURES.parseResponse(version, buffer), version);
    }

    public static UpdateFeaturesResponse createWithErrors(ApiError topLevelError, Map<String, ApiError> updateErrors, int throttleTimeMs) {
        UpdateFeaturesResponseData.UpdatableFeatureResultCollection results = new UpdateFeaturesResponseData.UpdatableFeatureResultCollection();
        for (Map.Entry<String, ApiError> updateError : updateErrors.entrySet()) {
            String feature = updateError.getKey();
            ApiError error = updateError.getValue();
            UpdateFeaturesResponseData.UpdatableFeatureResult result = new UpdateFeaturesResponseData.UpdatableFeatureResult();
            result.setFeature(feature).setErrorCode(error.error().code()).setErrorMessage(error.message());
            results.add(result);
        }
        UpdateFeaturesResponseData responseData = new UpdateFeaturesResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(topLevelError.error().code()).setErrorMessage(topLevelError.message()).setResults(results).setThrottleTimeMs(throttleTimeMs);
        return new UpdateFeaturesResponse(responseData);
    }
}

