/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class StopReplicaResponse
extends AbstractResponse {
    private final StopReplicaResponseData data;

    public StopReplicaResponse(StopReplicaResponseData data) {
        this.data = data;
    }

    public StopReplicaResponse(Struct struct, short version) {
        this.data = new StopReplicaResponseData(struct, version);
    }

    public List<StopReplicaResponseData.StopReplicaPartitionError> partitionErrors() {
        return this.data.partitionErrors();
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        if (this.data.errorCode() != Errors.NONE.code()) {
            return Collections.singletonMap(this.error(), this.data.partitionErrors().size());
        }
        return this.errorCounts(this.data.partitionErrors().stream().map(p -> Errors.forCode(p.errorCode())));
    }

    public static StopReplicaResponse parse(ByteBuffer buffer, short version) {
        return new StopReplicaResponse(ApiKeys.STOP_REPLICA.parseResponse(version, buffer), version);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public String toString() {
        return this.data.toString();
    }
}

