/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiKeys;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Errors;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Struct;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.requests.AbstractResponse;

public class HeartbeatResponse
extends AbstractResponse {
    private final HeartbeatResponseData data;

    public HeartbeatResponse(HeartbeatResponseData data) {
        this.data = data;
    }

    public HeartbeatResponse(Struct struct, short version) {
        this.data = new HeartbeatResponseData(struct, version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error());
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public static HeartbeatResponse parse(ByteBuffer buffer, short version) {
        return new HeartbeatResponse(ApiKeys.HEARTBEAT.parseResponse(version, buffer), version);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }
}

