/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.listener;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.plugin.flink.FlinkOperation;
import org.apache.inlong.manager.plugin.flink.FlinkService;
import org.apache.inlong.manager.plugin.flink.dto.FlinkInfo;
import org.apache.inlong.manager.plugin.util.FlinkUtils;
import org.apache.inlong.manager.pojo.group.InlongGroupExtInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.GroupResourceProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupSortListener
implements SortOperateListener {
    private static final Logger log = LoggerFactory.getLogger(StartupSortListener.class);

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext workflowContext) {
        ProcessForm processForm = workflowContext.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (!(processForm instanceof GroupResourceProcessForm)) {
            log.info("not add startup group listener, not GroupResourceProcessForm for groupId [{}]", (Object)groupId);
            return false;
        }
        GroupResourceProcessForm groupProcessForm = (GroupResourceProcessForm)processForm;
        if (groupProcessForm.getGroupOperateType() != GroupOperateType.INIT) {
            log.info("not add startup group listener, as the operate was not INIT for groupId [{}]", (Object)groupId);
            return false;
        }
        log.info("add startup group listener for groupId [{}]", (Object)groupId);
        return true;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        String dataflow;
        ProcessForm processForm = context.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (!(processForm instanceof GroupResourceProcessForm)) {
            String message = String.format("process form was not GroupResource for groupId [%s]", groupId);
            log.error(message);
            return ListenerResult.fail((String)message);
        }
        GroupResourceProcessForm groupResourceForm = (GroupResourceProcessForm)processForm;
        List streamInfos = groupResourceForm.getStreamInfos();
        int sinkCount = streamInfos.stream().map(s -> s.getSinkList() == null ? 0 : s.getSinkList().size()).reduce(0, Integer::sum);
        if (sinkCount == 0) {
            log.warn("not any sink configured for group {}, skip launching sort job", (Object)groupId);
            return ListenerResult.success();
        }
        InlongGroupInfo inlongGroupInfo = groupResourceForm.getGroupInfo();
        List extList = inlongGroupInfo.getExtList();
        log.info("inlong group ext info: {}", (Object)extList);
        Map<String, String> kvConf = extList.stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.getKeyName()) && StringUtils.isNotEmpty((CharSequence)v.getKeyValue())).collect(Collectors.toMap(InlongGroupExtInfo::getKeyName, InlongGroupExtInfo::getKeyValue));
        String sortExt = kvConf.get("sort.properties");
        if (StringUtils.isNotEmpty((CharSequence)sortExt)) {
            Map result = (Map)JsonUtils.OBJECT_MAPPER.convertValue((Object)JsonUtils.OBJECT_MAPPER.readTree(sortExt), (TypeReference)new TypeReference<Map<String, String>>(){});
            kvConf.putAll(result);
        }
        if (StringUtils.isEmpty((CharSequence)(dataflow = kvConf.get("dataflow")))) {
            String message = String.format("dataflow is empty for groupId [%s]", groupId);
            log.error(message);
            return ListenerResult.fail((String)message);
        }
        FlinkInfo flinkInfo = new FlinkInfo();
        String jobName = "INLONG_" + context.getProcessForm().getInlongGroupId();
        flinkInfo.setJobName(jobName);
        String sortUrl = kvConf.get("sort.url");
        flinkInfo.setEndpoint(sortUrl);
        flinkInfo.setInlongStreamInfoList(groupResourceForm.getStreamInfos());
        FlinkService flinkService = new FlinkService(flinkInfo.getEndpoint());
        FlinkOperation flinkOperation = new FlinkOperation(flinkService);
        try {
            flinkOperation.genPath(flinkInfo, dataflow);
            flinkOperation.start(flinkInfo);
            log.info("job submit success, jobId is [{}]", (Object)flinkInfo.getJobId());
        }
        catch (Exception e) {
            flinkOperation.pollJobStatus(flinkInfo);
            flinkInfo.setException(true);
            flinkInfo.setExceptionMsg(FlinkUtils.getExceptionStackMsg(e));
            flinkOperation.pollJobStatus(flinkInfo);
            String message = String.format("startup sort failed for groupId [%s] ", groupId);
            log.error(message, (Throwable)e);
            return ListenerResult.fail((String)(message + e.getMessage()));
        }
        this.saveInfo(groupId, "sort.job.id", flinkInfo.getJobId(), extList);
        flinkOperation.pollJobStatus(flinkInfo);
        return ListenerResult.success();
    }

    private void saveInfo(String inlongGroupId, String keyName, String keyValue, List<InlongGroupExtInfo> extInfoList) {
        InlongGroupExtInfo extInfo = new InlongGroupExtInfo();
        extInfo.setInlongGroupId(inlongGroupId);
        extInfo.setKeyName(keyName);
        extInfo.setKeyValue(keyValue);
        extInfoList.add(extInfo);
    }
}

