/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.listener;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.enums.TaskEvent;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.plugin.flink.FlinkOperation;
import org.apache.inlong.manager.plugin.flink.FlinkService;
import org.apache.inlong.manager.plugin.flink.dto.FlinkInfo;
import org.apache.inlong.manager.plugin.util.FlinkUtils;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.form.process.ProcessForm;
import org.apache.inlong.manager.pojo.workflow.form.process.StreamResourceProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartStreamListener
implements SortOperateListener {
    private static final Logger log = LoggerFactory.getLogger(RestartStreamListener.class);

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public boolean accept(WorkflowContext workflowContext) {
        ProcessForm processForm = workflowContext.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (!(processForm instanceof StreamResourceProcessForm)) {
            log.info("not add restart stream listener, not StreamResourceProcessForm for groupId [{}]", (Object)groupId);
            return false;
        }
        StreamResourceProcessForm streamProcessForm = (StreamResourceProcessForm)processForm;
        String streamId = streamProcessForm.getStreamInfo().getInlongStreamId();
        if (streamProcessForm.getGroupOperateType() != GroupOperateType.RESTART) {
            log.info("not add restart stream listener, as the operate was not RESTART for groupId [{}] streamId [{}]", (Object)groupId, (Object)streamId);
            return false;
        }
        log.info("add restart stream listener for groupId [{}] streamId [{}]", (Object)groupId, (Object)streamId);
        return true;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        ProcessForm processForm = context.getProcessForm();
        StreamResourceProcessForm streamResourceProcessForm = (StreamResourceProcessForm)processForm;
        InlongGroupInfo groupInfo = streamResourceProcessForm.getGroupInfo();
        List groupExtList = groupInfo.getExtList();
        log.info("inlong group :{} ext info: {}", (Object)groupInfo.getInlongGroupId(), (Object)groupExtList);
        InlongStreamInfo streamInfo = streamResourceProcessForm.getStreamInfo();
        List streamExtList = streamInfo.getExtList();
        log.info("inlong stream :{} ext info: {}", (Object)streamInfo.getInlongStreamId(), (Object)streamExtList);
        HashMap kvConf = new HashMap();
        groupExtList.forEach(groupExtInfo -> kvConf.put(groupExtInfo.getKeyName(), groupExtInfo.getKeyValue()));
        streamExtList.forEach(extInfo -> kvConf.put(extInfo.getKeyName(), extInfo.getKeyValue()));
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        String sortExt = (String)kvConf.get("sort.properties");
        if (StringUtils.isEmpty((CharSequence)sortExt)) {
            String message = String.format("restart sort failed for groupId [%s] and streamId [%s], as the sort properties is empty", groupId, streamId);
            log.error(message);
            return ListenerResult.fail((String)message);
        }
        Map result = (Map)JsonUtils.OBJECT_MAPPER.convertValue((Object)JsonUtils.OBJECT_MAPPER.readTree(sortExt), (TypeReference)new TypeReference<Map<String, String>>(){});
        kvConf.putAll(result);
        String jobId = (String)kvConf.get("sort.job.id");
        if (StringUtils.isBlank((CharSequence)jobId)) {
            String message = String.format("sort job id is empty for groupId [%s] streamId [%s]", groupId, streamId);
            return ListenerResult.fail((String)message);
        }
        String dataflow = (String)kvConf.get("dataflow");
        if (StringUtils.isEmpty((CharSequence)dataflow)) {
            String message = String.format("dataflow is empty for groupId [%s] streamId [%s]", groupId, streamId);
            log.error(message);
            return ListenerResult.fail((String)message);
        }
        FlinkInfo flinkInfo = new FlinkInfo();
        flinkInfo.setJobId(jobId);
        String jobName = "INLONG_" + context.getProcessForm().getInlongGroupId();
        flinkInfo.setJobName(jobName);
        String sortUrl = (String)kvConf.get("sort.url");
        flinkInfo.setEndpoint(sortUrl);
        FlinkService flinkService = new FlinkService(flinkInfo.getEndpoint());
        FlinkOperation flinkOperation = new FlinkOperation(flinkService);
        try {
            flinkOperation.genPath(flinkInfo, dataflow);
            flinkOperation.restart(flinkInfo);
            log.info("job restart success for [{}]", (Object)jobId);
            return ListenerResult.success();
        }
        catch (Exception e) {
            flinkInfo.setException(true);
            flinkInfo.setExceptionMsg(FlinkUtils.getExceptionStackMsg(e));
            flinkOperation.pollJobStatus(flinkInfo);
            String message = String.format("restart sort failed for groupId [%s] streamId [%s] ", groupId, streamId);
            log.error(message, (Throwable)e);
            return ListenerResult.fail((String)(message + e.getMessage()));
        }
    }
}

