/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.flink.enums;

public enum ConnectorJarType {
    MONGODB_SOURCE("mongoExtract", "mongodb-cdc"),
    MYSQL_SOURCE("mysqlExtract", "mysql-cdc"),
    KAFKA_SOURCE("kafkaExtract", "kafka"),
    ORACLE_SOURCE("oracleExtract", "oracle-cdc"),
    POSTGRES_SOURCE("postgresExtract", "postgres-cdc"),
    SQLSERVER_SOURCE("sqlserverExtract", "sqlserver-cdc"),
    PULSAR_SOURCE("pulsarExtract", "pulsar"),
    MYSQL_SINK("mysqlLoad", "jdbc"),
    KAFKA_SINK("kafkaLoad", "kafka"),
    ORACLE_SINK("oracleLoad", "jdbc"),
    POSTGRES_SINK("postgresLoad", "jdbc"),
    SQLSERVER_SINK("sqlserverLoad", "jdbc"),
    HBASE_SINK("hbaseLoad", "hbase"),
    TDSQLPOSTGRES_SINK("tdsqlPostgresLoad", "jdbc"),
    GREENPLUM_SINK("greenplumLoad", "jdbc"),
    ELASTICSEARCH_SINK("elasticsearchLoad", "elasticsearch"),
    CLICKHOUSE_SINK("clickHouseLoad", "jdbc"),
    DLCICEBERG_SINK("dlcIcebergLoad", "dlc"),
    HIVE_SINK("hiveLoad", "hive"),
    ICEBERG_SINK("icebergLoad", "iceberg"),
    HDFS_SINK("fileSystemLoad", "");

    private String sourceType;
    private String connectorType;

    private ConnectorJarType(String sourceType, String connectorType) {
        this.connectorType = connectorType;
        this.sourceType = sourceType;
    }

    public static ConnectorJarType getInstance(String type) {
        for (ConnectorJarType value : ConnectorJarType.values()) {
            if (!value.getSourceType().equals(type)) continue;
            return value;
        }
        return null;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getConnectorType() {
        return this.connectorType;
    }
}

