/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.flink;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TaskRunService {
    private static final ExecutorService executorService = new ThreadPoolExecutor(16, 32, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000));
    private static final int CORE_POOL_SIZE = 16;
    private static final int MAXIMUM_POOL_SIZE = 32;
    private static final int QUEUE_SIZE = 10000;
    private static final long KEEP_ALIVE_TIME = 0L;

    public static void execute(Runnable runnable) {
        executorService.execute(runnable);
    }

    public static Future<?> submit(Runnable runnable) {
        return executorService.submit(runnable);
    }

    public static <T> Future<T> submit(Runnable runnable, T defaultValue) {
        return executorService.submit(runnable, defaultValue);
    }

    public static <T> Future<T> submit(Callable<T> callable) {
        return executorService.submit(callable);
    }
}

