/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.listener;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.pojo.group.InlongGroupExtInfo;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.plugin.flink.FlinkOperation;
import org.apache.inlong.manager.plugin.flink.FlinkService;
import org.apache.inlong.manager.plugin.flink.dto.FlinkInfo;
import org.apache.inlong.manager.plugin.util.FlinkUtils;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuspendStreamListener
implements SortOperateListener {
    private static final Logger log = LoggerFactory.getLogger(SuspendStreamListener.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        ProcessForm processForm = context.getProcessForm();
        StreamResourceProcessForm streamResourceProcessForm = (StreamResourceProcessForm)processForm;
        InlongGroupInfo groupInfo = streamResourceProcessForm.getGroupInfo();
        List groupExtList = groupInfo.getExtList();
        log.info("inlong group :{} ext info: {}", (Object)groupInfo.getInlongGroupId(), (Object)groupExtList);
        InlongStreamInfo streamInfo = streamResourceProcessForm.getStreamInfo();
        List streamExtList = streamInfo.getExtList();
        log.info("inlong stream :{} ext info: {}", (Object)streamInfo.getInlongStreamId(), (Object)streamExtList);
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        Map<String, String> kvConf = groupExtList.stream().collect(Collectors.toMap(InlongGroupExtInfo::getKeyName, InlongGroupExtInfo::getKeyValue));
        streamExtList.stream().forEach(extInfo -> kvConf.put(extInfo.getKeyName(), extInfo.getKeyValue()));
        String sortExt = kvConf.get("sort.properties");
        if (StringUtils.isEmpty((CharSequence)sortExt)) {
            String message = String.format("suspend sort failed for groupId [%s] streamId [%s], as the sort properties is empty", groupId, streamId);
            log.error(message);
            return ListenerResult.fail((String)message);
        }
        Map result = (Map)OBJECT_MAPPER.convertValue((Object)OBJECT_MAPPER.readTree(sortExt), (TypeReference)new TypeReference<Map<String, String>>(){});
        kvConf.putAll(result);
        String jobId = kvConf.get("sort.job.id");
        if (StringUtils.isBlank((CharSequence)jobId)) {
            String message = String.format("sort job id is empty for groupId [%s] streamId [%s]", groupId, streamId);
            return ListenerResult.fail((String)message);
        }
        FlinkInfo flinkInfo = new FlinkInfo();
        flinkInfo.setJobId(jobId);
        String sortUrl = kvConf.get("sort.url");
        flinkInfo.setEndpoint(sortUrl);
        FlinkService flinkService = new FlinkService(flinkInfo.getEndpoint());
        FlinkOperation flinkOperation = new FlinkOperation(flinkService);
        try {
            flinkOperation.stop(flinkInfo);
            log.info("job suspend success for [{}]", (Object)jobId);
            return ListenerResult.success();
        }
        catch (Exception e) {
            flinkInfo.setException(true);
            flinkInfo.setExceptionMsg(FlinkUtils.getExceptionStackMsg(e));
            flinkOperation.pollJobStatus(flinkInfo);
            String message = String.format("suspend sort failed for groupId [%s] streamId[%s]", groupId, streamId);
            log.error(message, (Throwable)e);
            return ListenerResult.fail((String)(message + e.getMessage()));
        }
    }

    public boolean async() {
        return false;
    }
}

