/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.listener;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.pojo.group.InlongGroupExtInfo;
import org.apache.inlong.manager.common.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.plugin.flink.FlinkOperation;
import org.apache.inlong.manager.plugin.flink.FlinkService;
import org.apache.inlong.manager.plugin.flink.dto.FlinkInfo;
import org.apache.inlong.manager.plugin.util.FlinkUtils;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.ListenerResult;
import org.apache.inlong.manager.workflow.event.task.SortOperateListener;
import org.apache.inlong.manager.workflow.event.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupSortListener
implements SortOperateListener {
    private static final Logger log = LoggerFactory.getLogger(StartupSortListener.class);
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public TaskEvent event() {
        return TaskEvent.COMPLETE;
    }

    public ListenerResult listen(WorkflowContext context) throws Exception {
        String dataFlows;
        ProcessForm processForm = context.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (!(processForm instanceof GroupResourceProcessForm)) {
            String message = String.format("process form was not GroupResource for groupId [%s]", groupId);
            log.error(message);
            return ListenerResult.fail((String)message);
        }
        GroupResourceProcessForm groupResourceForm = (GroupResourceProcessForm)processForm;
        InlongGroupInfo inlongGroupInfo = groupResourceForm.getGroupInfo();
        List extList = inlongGroupInfo.getExtList();
        log.info("inlong group ext info: {}", (Object)extList);
        Map<String, String> kvConf = extList.stream().filter(v -> StringUtils.isNotEmpty((CharSequence)v.getKeyName()) && StringUtils.isNotEmpty((CharSequence)v.getKeyValue())).collect(Collectors.toMap(InlongGroupExtInfo::getKeyName, InlongGroupExtInfo::getKeyValue));
        String sortExt = kvConf.get("sort.properties");
        if (StringUtils.isNotEmpty((CharSequence)sortExt)) {
            Map result = (Map)OBJECT_MAPPER.convertValue((Object)OBJECT_MAPPER.readTree(sortExt), (TypeReference)new TypeReference<Map<String, String>>(){});
            kvConf.putAll(result);
        }
        if (StringUtils.isEmpty((CharSequence)(dataFlows = kvConf.get("dataFlow")))) {
            String message = String.format("dataflow is empty for groupId [%s]", groupId);
            log.error(message);
            return ListenerResult.fail((String)message);
        }
        FlinkInfo flinkInfo = new FlinkInfo();
        String jobName = "INLONG_" + context.getProcessForm().getInlongGroupId();
        flinkInfo.setJobName(jobName);
        String sortUrl = kvConf.get("sort.url");
        flinkInfo.setEndpoint(sortUrl);
        flinkInfo.setInlongStreamInfoList(groupResourceForm.getStreamInfos());
        FlinkService flinkService = new FlinkService(flinkInfo.getEndpoint());
        FlinkOperation flinkOperation = new FlinkOperation(flinkService);
        try {
            flinkOperation.genPath(flinkInfo, dataFlows);
            flinkOperation.start(flinkInfo);
            log.info("job submit success, jobId is [{}]", (Object)flinkInfo.getJobId());
        }
        catch (Exception e) {
            flinkOperation.pollJobStatus(flinkInfo);
            flinkInfo.setException(true);
            flinkInfo.setExceptionMsg(FlinkUtils.getExceptionStackMsg(e));
            flinkOperation.pollJobStatus(flinkInfo);
            String message = String.format("startup sort failed for groupId [%s] ", groupId);
            log.error(message, (Throwable)e);
            return ListenerResult.fail((String)(message + e.getMessage()));
        }
        this.saveInfo(groupId, "sort.job.id", flinkInfo.getJobId(), extList);
        flinkOperation.pollJobStatus(flinkInfo);
        return ListenerResult.success();
    }

    private void saveInfo(String inlongGroupId, String keyName, String keyValue, List<InlongGroupExtInfo> extInfoList) {
        InlongGroupExtInfo extInfo = new InlongGroupExtInfo();
        extInfo.setInlongGroupId(inlongGroupId);
        extInfo.setKeyName(keyName);
        extInfo.setKeyValue(keyValue);
        extInfoList.add(extInfo);
    }

    public boolean async() {
        return false;
    }
}

