/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.flink;

import java.io.File;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.rest.messages.job.JobDetailsInfo;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.plugin.flink.FlinkService;
import org.apache.inlong.manager.plugin.flink.IntegrationTaskRunner;
import org.apache.inlong.manager.plugin.flink.TaskRunService;
import org.apache.inlong.manager.plugin.flink.dto.FlinkInfo;
import org.apache.inlong.manager.plugin.flink.enums.TaskCommitType;
import org.apache.inlong.manager.plugin.util.FlinkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkOperation {
    private static final Logger log = LoggerFactory.getLogger(FlinkOperation.class);
    private static final String JOB_TERMINATED_MSG = "the job not found by id %s, or task already terminated or savepoint path is null";
    private static final String INLONG_MANAGER = "inlong-manager";
    private static final String INLONG_SORT = "inlong-sort";
    private static final String SORT_JAR_PATTERN = "^sort-dist.*jar$";
    private static final String SORT_PLUGIN = "sort-plugin" + File.separator + "connectors";
    private static final String CONNECTOR_JAR_PATTERN = "^sort-connector.*jar$";
    private final FlinkService flinkService;

    public FlinkOperation(FlinkService flinkService) {
        this.flinkService = flinkService;
    }

    public void start(FlinkInfo flinkInfo) throws Exception {
        String jobId = flinkInfo.getJobId();
        try {
            if (StringUtils.isEmpty((CharSequence)jobId)) {
                IntegrationTaskRunner taskRunner = new IntegrationTaskRunner(this.flinkService, flinkInfo, TaskCommitType.START_NOW.getCode());
                Future<?> future = TaskRunService.submit(taskRunner);
                future.get();
            } else {
                boolean noSavepoint;
                boolean bl = noSavepoint = this.isNullOrTerminated(jobId) || StringUtils.isEmpty((CharSequence)flinkInfo.getSavepointPath());
                if (noSavepoint) {
                    String message = String.format("restore job failed, as the job not found by id %s, or task already terminated or savepoint path is null", jobId);
                    log.error(message);
                    throw new Exception(message);
                }
                IntegrationTaskRunner taskRunner = new IntegrationTaskRunner(this.flinkService, flinkInfo, TaskCommitType.RESUME.getCode());
                Future<?> future = TaskRunService.submit(taskRunner);
                future.get();
            }
        }
        catch (Exception e) {
            log.warn("submit flink job failed for {}", (Object)flinkInfo, (Object)e);
            throw new Exception("submit flink job failed: " + e.getMessage());
        }
    }

    public void genPath(FlinkInfo flinkInfo, String dataflow) throws Exception {
        String path = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        log.info("gen path from {}", (Object)path);
        int index = path.indexOf(INLONG_MANAGER);
        if (index == -1) {
            throw new Exception("inlong-manager path not found in " + path);
        }
        String startPath = (path = path.substring(0, path.lastIndexOf(File.separator))).substring(0, index);
        String basePath = startPath + INLONG_SORT;
        File file = new File(basePath);
        if (!file.exists()) {
            String message = String.format("file path [%s] not found", basePath);
            log.error(message);
            throw new Exception(message);
        }
        String jarPath = FlinkUtils.findFile(basePath, SORT_JAR_PATTERN);
        flinkInfo.setLocalJarPath(jarPath);
        log.info("get sort jar path success, path: {}", (Object)jarPath);
        String pluginPath = startPath + SORT_PLUGIN;
        List<String> connectorPaths = FlinkUtils.listFiles(pluginPath, CONNECTOR_JAR_PATTERN, -1);
        flinkInfo.setConnectorJarPaths(connectorPaths);
        log.info("get sort connector paths success, paths: {}", connectorPaths);
        if (!FlinkUtils.writeConfigToFile(path, flinkInfo.getJobName(), dataflow)) {
            String message = String.format("write dataflow to %s failed", path);
            log.error(message + ", dataflow: {}", (Object)dataflow);
            throw new Exception(message);
        }
        flinkInfo.setLocalConfPath(path + File.separator + flinkInfo.getJobName());
    }

    public void restart(FlinkInfo flinkInfo) throws Exception {
        String jobId = flinkInfo.getJobId();
        boolean terminated = this.isNullOrTerminated(jobId);
        if (terminated) {
            String message = String.format("restart job failed, as the job not found by id %s, or task already terminated or savepoint path is null", jobId);
            log.error(message);
            throw new Exception(message);
        }
        Future<?> future = TaskRunService.submit(new IntegrationTaskRunner(this.flinkService, flinkInfo, TaskCommitType.RESTART.getCode()));
        future.get();
    }

    public void stop(FlinkInfo flinkInfo) throws Exception {
        String jobId = flinkInfo.getJobId();
        boolean terminated = this.isNullOrTerminated(jobId);
        if (terminated) {
            String message = String.format("stop job failed, as the job not found by id %s, or task already terminated or savepoint path is null", jobId);
            log.error(message);
            throw new Exception(message);
        }
        Future<?> future = TaskRunService.submit(new IntegrationTaskRunner(this.flinkService, flinkInfo, TaskCommitType.STOP.getCode()));
        future.get();
    }

    public void delete(FlinkInfo flinkInfo) throws Exception {
        String jobId = flinkInfo.getJobId();
        JobDetailsInfo jobDetailsInfo = this.flinkService.getJobDetail(jobId);
        if (jobDetailsInfo == null) {
            throw new Exception(String.format("delete job failed as the job not found for %s", jobId));
        }
        JobStatus jobStatus = jobDetailsInfo.getJobStatus();
        if (jobStatus != null && jobStatus.isTerminalState()) {
            String message = String.format("not support delete %s as the task was terminated", jobId);
            message = jobStatus.isGloballyTerminalState() ? message + " globally" : " locally";
            throw new Exception(message);
        }
        Future<?> future = TaskRunService.submit(new IntegrationTaskRunner(this.flinkService, flinkInfo, TaskCommitType.DELETE.getCode()));
        future.get();
    }

    public void pollJobStatus(FlinkInfo flinkInfo) throws Exception {
        if (flinkInfo.isException()) {
            throw new BusinessException("startup failed: " + flinkInfo.getExceptionMsg());
        }
        String jobId = flinkInfo.getJobId();
        if (StringUtils.isBlank((CharSequence)jobId)) {
            log.error("job id cannot empty for {}", (Object)flinkInfo);
            throw new Exception("job id cannot empty");
        }
        block2: while (true) {
            try {
                while (true) {
                    JobDetailsInfo jobDetailsInfo;
                    if ((jobDetailsInfo = this.flinkService.getJobDetail(jobId)) == null) {
                        log.error("job detail not found by {}", (Object)jobId);
                        throw new Exception(String.format("job detail not found by %s", jobId));
                    }
                    JobStatus jobStatus = jobDetailsInfo.getJobStatus();
                    if (jobStatus.isTerminalState()) {
                        log.error("job was terminated for {}, exception: {}", (Object)jobId, (Object)flinkInfo.getExceptionMsg());
                        throw new Exception("job was terminated for " + jobId);
                    }
                    if (jobStatus == JobStatus.RUNNING) {
                        log.info("job status is Running for {}", (Object)jobId);
                        break block2;
                    }
                    log.info("job was not Running for {}", (Object)jobId);
                    TimeUnit.SECONDS.sleep(5L);
                }
            }
            catch (Exception e) {
                log.error("poll job status error for {}, exception: ", (Object)flinkInfo, (Object)e);
                continue;
            }
            break;
        }
    }

    private boolean isNullOrTerminated(String jobId) throws Exception {
        boolean terminated;
        JobDetailsInfo jobDetailsInfo = this.flinkService.getJobDetail(jobId);
        boolean bl = terminated = jobDetailsInfo == null || jobDetailsInfo.getJobStatus() == null;
        if (terminated) {
            log.warn("job detail or job status was null for [{}]", (Object)jobId);
            return terminated;
        }
        terminated = jobDetailsInfo.getJobStatus().isTerminalState();
        log.warn("job terminated state was [{}] for [{}]", (Object)terminated, (Object)jobDetailsInfo);
        return terminated;
    }
}

