/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.eventselect;

import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuspendStreamSelector
implements EventSelector {
    private static final Logger log = LoggerFactory.getLogger(SuspendStreamSelector.class);

    public boolean accept(WorkflowContext workflowContext) {
        boolean flag;
        ProcessForm processForm = workflowContext.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (!(processForm instanceof StreamResourceProcessForm)) {
            log.info("not add suspendStream listener as StreamResourceProcessForm for groupId [{}]", (Object)groupId);
            return false;
        }
        StreamResourceProcessForm streamProcessForm = (StreamResourceProcessForm)processForm;
        String streamId = streamProcessForm.getStreamInfo().getInlongStreamId();
        boolean bl = flag = streamProcessForm.getGroupOperateType() == GroupOperateType.SUSPEND;
        if (!flag) {
            log.info("not add suspendStream listener as the operate SUSPEND for groupId [{}] and streamId [{}]", (Object)groupId, (Object)streamId);
            return false;
        }
        log.info("add suspendStream listener for groupId [{}] and streamId [{}]", (Object)groupId, (Object)streamId);
        return true;
    }
}

