/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.eventselect;

import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupStreamSelector
implements EventSelector {
    private static final Logger log = LoggerFactory.getLogger(StartupStreamSelector.class);

    public boolean accept(WorkflowContext workflowContext) {
        ProcessForm processForm = workflowContext.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (!(processForm instanceof StreamResourceProcessForm)) {
            log.info("not add startupStream listener, as the form was not StreamResourceProcessForm for groupId [{}]", (Object)groupId);
            return false;
        }
        StreamResourceProcessForm streamProcessForm = (StreamResourceProcessForm)processForm;
        boolean flag = streamProcessForm.getGroupOperateType() == GroupOperateType.INIT;
        String streamId = streamProcessForm.getStreamInfo().getInlongStreamId();
        if (!flag) {
            log.info("not add startupStream listener, as the operate was not INIT for groupId [{}] and streamId [{}]", (Object)groupId, (Object)streamId);
            return false;
        }
        log.info("add startupStream listener for groupId [{}] and streamId [{}]", (Object)groupId, (Object)streamId);
        return true;
    }
}

