/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.eventselect;

import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.pojo.workflow.form.GroupResourceProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartProcessSelector
implements EventSelector {
    private static final Logger log = LoggerFactory.getLogger(RestartProcessSelector.class);

    public boolean accept(WorkflowContext workflowContext) {
        boolean flag;
        ProcessForm processForm = workflowContext.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (!(processForm instanceof GroupResourceProcessForm)) {
            log.info("not add restartProcess listener, as the form was not GroupResourceProcessForm for groupId [{}]", (Object)groupId);
            return false;
        }
        GroupResourceProcessForm groupProcessForm = (GroupResourceProcessForm)processForm;
        boolean bl = flag = groupProcessForm.getGroupOperateType() == GroupOperateType.RESTART;
        if (!flag) {
            log.info("\"not add restartProcess listener, as the operate was not RESTART for groupId [{}]", (Object)groupId);
            return false;
        }
        log.info("add restartProcess listener for groupId [{}]", (Object)groupId);
        return true;
    }
}

