/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.eventselect;

import org.apache.inlong.manager.common.enums.GroupOperateType;
import org.apache.inlong.manager.common.pojo.workflow.form.ProcessForm;
import org.apache.inlong.manager.common.pojo.workflow.form.StreamResourceProcessForm;
import org.apache.inlong.manager.workflow.WorkflowContext;
import org.apache.inlong.manager.workflow.event.EventSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteStreamSelector
implements EventSelector {
    private static final Logger log = LoggerFactory.getLogger(DeleteStreamSelector.class);

    public boolean accept(WorkflowContext context) {
        boolean flag;
        ProcessForm processForm = context.getProcessForm();
        String groupId = processForm.getInlongGroupId();
        if (!(processForm instanceof StreamResourceProcessForm)) {
            log.info("not add deleteStream listener, as the form was not StreamResourceProcessForm for groupId [{}]", (Object)groupId);
            return false;
        }
        StreamResourceProcessForm streamResourceProcessForm = (StreamResourceProcessForm)processForm;
        String streamId = streamResourceProcessForm.getStreamInfo().getInlongStreamId();
        boolean bl = flag = streamResourceProcessForm.getGroupOperateType() == GroupOperateType.DELETE;
        if (!flag) {
            log.info("not add deleteStream listener, as the operate was not DELETE for groupId [{}] and streamId [{}]", (Object)groupId, (Object)streamId);
            return false;
        }
        log.info("add deleteStream listener for groupId [{}] and streamId [{}]", (Object)groupId, (Object)streamId);
        return true;
    }
}

