/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.util;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import ru.yandex.clickhouse.domain.ClickHouseDataType;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.ClickHouseBitmap;
import ru.yandex.clickhouse.util.ClickHouseRowBinaryStream;
import ru.yandex.clickhouse.util.Utils;

public class ClickHouseRowBinaryInputStream
implements Closeable {
    private final DataInputStream in;
    private final TimeZone timeZone;
    private final List<ClickHouseColumnInfo> columns;

    public ClickHouseRowBinaryInputStream(InputStream is, TimeZone timeZone, ClickHouseProperties properties) throws IOException {
        this(is, timeZone, properties, false);
    }

    public ClickHouseRowBinaryInputStream(InputStream is, TimeZone timeZone, ClickHouseProperties properties, boolean hasColumnInfo) throws IOException {
        this.in = new DataInputStream(is);
        this.timeZone = properties.isUseServerTimeZoneForDates() ? timeZone : TimeZone.getDefault();
        if (hasColumnInfo) {
            int count = Utils.readVarInt(this.in);
            String[][] columns = new String[count][2];
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < count; ++j) {
                    columns[j][i] = this.readString();
                }
            }
            ArrayList<ClickHouseColumnInfo> list = new ArrayList<ClickHouseColumnInfo>(count);
            for (int i = 0; i < count; ++i) {
                String[] column = columns[i];
                list.add(ClickHouseColumnInfo.parse(column[1], column[0], timeZone));
            }
            this.columns = Collections.unmodifiableList(list);
        } else {
            this.columns = Collections.emptyList();
        }
    }

    public List<ClickHouseColumnInfo> getColumns() {
        return this.columns;
    }

    public void readBytes(byte[] bytes) throws IOException {
        this.readBytes(bytes, 0, bytes.length);
    }

    public void readBytes(byte[] bytes, int offset, int length) throws IOException {
        while (length > 0) {
            int read = this.in.read(bytes, offset, length);
            if (read == -1) {
                throw new EOFException();
            }
            offset += read;
            length -= read;
        }
    }

    public int readByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public boolean readIsNull() throws IOException {
        int value = this.readByte();
        Utils.checkArgument(value, 0, 1);
        return value != 0;
    }

    public String readString() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public String readFixedString(int length) throws IOException {
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public boolean readBoolean() throws IOException {
        short value = this.readUInt8();
        Utils.checkArgument(value, 0, 1);
        return value != 0;
    }

    public short readUInt8() throws IOException {
        return (short)this.in.readUnsignedByte();
    }

    public byte readUInt8AsByte() throws IOException {
        return this.in.readByte();
    }

    public byte readInt8() throws IOException {
        return this.in.readByte();
    }

    public int readUInt16() throws IOException {
        return Utils.readUnsignedShort(this.in);
    }

    public short readUInt16AsShort() throws IOException {
        return (short)Utils.readUnsignedShort(this.in);
    }

    public short readInt16() throws IOException {
        return (short)Utils.readUnsignedShort(this.in);
    }

    public long readUInt32() throws IOException {
        return (long)Utils.readInt(this.in) & 0xFFFFFFFFL;
    }

    public int readUInt32AsInt() throws IOException {
        return Utils.readInt(this.in);
    }

    public int readInt32() throws IOException {
        return Utils.readInt(this.in);
    }

    public long readUInt64AsLong() throws IOException {
        return Utils.readLong(this.in);
    }

    public BigInteger readUInt64() throws IOException {
        return Utils.readLongAsBigInteger(this.in);
    }

    public long readInt64() throws IOException {
        return Utils.readLong(this.in);
    }

    public BigInteger readInt128() throws IOException {
        return Utils.readBigInteger(this.in, 16);
    }

    public BigInteger writeUInt128() throws IOException {
        return Utils.readBigInteger(this.in, 16);
    }

    public BigInteger writeInt256() throws IOException {
        return Utils.readBigInteger(this.in, 32);
    }

    public BigInteger writeUInt256() throws IOException {
        return Utils.readBigInteger(this.in, 32);
    }

    public Timestamp readDateTime() throws IOException {
        long value = this.readUInt32();
        return new Timestamp(TimeUnit.SECONDS.toMillis(value));
    }

    public Date readDate() throws IOException {
        int daysSinceEpoch = this.readUInt16();
        long utcMillis = (long)daysSinceEpoch * ClickHouseRowBinaryStream.MILLIS_IN_DAY;
        long localMillis = utcMillis - (long)this.timeZone.getOffset(utcMillis);
        return new Date(localMillis);
    }

    public float readFloat32() throws IOException {
        return Float.intBitsToFloat(Utils.readInt(this.in));
    }

    public double readFloat64() throws IOException {
        return Double.longBitsToDouble(Utils.readLong(this.in));
    }

    public Date[] readDateArray() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        Date[] dates = new Date[length];
        for (int i = 0; i < length; ++i) {
            dates[i] = this.readDate();
        }
        return dates;
    }

    public Timestamp[] readDateTimeArray() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        Timestamp[] dates = new Timestamp[length];
        for (int i = 0; i < length; ++i) {
            dates[i] = this.readDateTime();
        }
        return dates;
    }

    public String[] readStringArray() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        String[] strings = new String[length];
        for (int i = 0; i < length; ++i) {
            strings[i] = this.readString();
        }
        return strings;
    }

    public byte[] readInt8Array() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.readInt8();
        }
        return bytes;
    }

    public byte[] readUInt8ArrayAsByte() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.readUInt8AsByte();
        }
        return bytes;
    }

    public short[] readUInt8Array() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        short[] shorts = new short[length];
        for (int i = 0; i < length; ++i) {
            shorts[i] = this.readUInt8();
        }
        return shorts;
    }

    public short[] readInt16Array() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        short[] shorts = new short[length];
        for (int i = 0; i < length; ++i) {
            shorts[i] = this.readInt16();
        }
        return shorts;
    }

    public short[] readUInt16ArrayAsShort() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        short[] shorts = new short[length];
        for (int i = 0; i < length; ++i) {
            shorts[i] = this.readUInt16AsShort();
        }
        return shorts;
    }

    public int[] readUInt16Array() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this.readUInt16();
        }
        return ints;
    }

    public int[] readInt32Array() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this.readInt32();
        }
        return ints;
    }

    public int[] readUInt32ArrayAsInt() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this.readUInt32AsInt();
        }
        return ints;
    }

    public long[] readUInt32Array() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this.readUInt32();
        }
        return longs;
    }

    public long[] readInt64Array() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this.readInt64();
        }
        return longs;
    }

    public long[] readUInt64ArrayAsLong() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        long[] longs = new long[length];
        for (int i = 0; i < length; ++i) {
            longs[i] = this.readUInt64AsLong();
        }
        return longs;
    }

    public BigInteger[] readUInt64Array() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        BigInteger[] bigs = new BigInteger[length];
        for (int i = 0; i < length; ++i) {
            bigs[i] = this.readUInt64();
        }
        return bigs;
    }

    public float[] readFloat32Array() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        float[] floats = new float[length];
        for (int i = 0; i < length; ++i) {
            floats[i] = this.readFloat32();
        }
        return floats;
    }

    public double[] readFloat64Array() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        double[] doubles = new double[length];
        for (int i = 0; i < length; ++i) {
            doubles[i] = this.readFloat64();
        }
        return doubles;
    }

    public UUID readUUID() throws IOException {
        byte[] array = new byte[16];
        this.readBytes(array);
        ByteBuffer bb = ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN);
        return new UUID(bb.getLong(), bb.getLong());
    }

    public UUID[] readUUIDArray() throws IOException {
        int length = Utils.readUnsignedLeb128(this.in);
        UUID[] uuids = new UUID[length];
        for (int i = 0; i < length; ++i) {
            uuids[i] = this.readUUID();
        }
        return uuids;
    }

    public BigDecimal readDecimal32(int scale) throws IOException {
        int i = Utils.readInt(this.in);
        BigDecimal ten = BigDecimal.valueOf(10L);
        BigDecimal s2 = ten.pow(scale);
        return new BigDecimal(i).divide(s2);
    }

    public BigDecimal readDecimal64(int scale) throws IOException {
        long i = Utils.readLong(this.in);
        BigDecimal ten = BigDecimal.valueOf(10L);
        BigDecimal s2 = ten.pow(scale);
        return new BigDecimal(i).divide(s2);
    }

    public BigDecimal readDecimal128(int scale) throws IOException {
        byte[] r = new byte[16];
        for (int i = r.length; i > 0; --i) {
            r[i - 1] = (byte)this.in.readUnsignedByte();
        }
        BigDecimal res = new BigDecimal(new BigInteger(r), scale);
        return res;
    }

    public BigDecimal readDecimal256(int scale) throws IOException {
        byte[] r = new byte[32];
        for (int i = r.length; i > 0; --i) {
            r[i - 1] = (byte)this.in.readUnsignedByte();
        }
        BigDecimal res = new BigDecimal(new BigInteger(r), scale);
        return res;
    }

    public ClickHouseBitmap readBitmap(ClickHouseDataType innerType) throws IOException {
        return ClickHouseBitmap.deserialize(this.in, innerType);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

