/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.settings;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import ru.yandex.clickhouse.settings.ClickHouseConnectionSettings;
import ru.yandex.clickhouse.settings.ClickHouseQueryParam;
import ru.yandex.clickhouse.util.apache.StringUtils;

public class ClickHouseProperties {
    private boolean async;
    private int bufferSize;
    private int apacheBufferSize;
    private int socketTimeout;
    private int connectionTimeout;
    private int dataTransferTimeout;
    private int timeToLiveMillis;
    private int defaultMaxPerRoute;
    private int maxTotal;
    private int maxRetries;
    private String host;
    private int port;
    private boolean usePathAsDb;
    private String path;
    private boolean ssl;
    private String sslRootCertificate;
    private String sslMode;
    private int maxRedirects;
    private boolean checkForRedirects;
    private int maxCompressBufferSize;
    private boolean useServerTimeZone;
    private String useTimeZone;
    private boolean useServerTimeZoneForDates;
    private boolean useObjectsInArrays;
    private boolean useSharedCookieStore;
    private Integer maxParallelReplicas;
    private Integer maxPartitionsPerInsertBlock;
    private String totalsMode;
    private String quotaKey;
    private Integer priority;
    private String database;
    private boolean compress;
    private boolean decompress;
    private boolean extremes;
    private Integer maxThreads;
    private Integer maxExecutionTime;
    private Integer maxBlockSize;
    private Integer maxRowsToGroupBy;
    private String profile;
    private String user;
    private String password;
    private String httpAuthorization;
    private boolean distributedAggregationMemoryEfficient;
    private Long maxBytesBeforeExternalGroupBy;
    private Long maxBytesBeforeExternalSort;
    private Long maxMemoryUsage;
    private Long maxMemoryUsageForUser;
    private Long maxMemoryUsageForAllQueries;
    private Long preferredBlockSizeBytes;
    private Long maxQuerySize;
    private Long maxAstElements;
    private boolean sessionCheck;
    private String sessionId;
    private Long sessionTimeout;
    private Long insertQuorum;
    private Long insertQuorumTimeout;
    private Long selectSequentialConsistency;
    private Boolean enableOptimizePredicateExpression;
    private Long maxInsertBlockSize;
    private Boolean insertDeduplicate;
    private Boolean insertDistributedSync;
    private Boolean anyJoinDistinctRightTableKeys;
    private Boolean sendProgressInHttpHeaders;
    private Boolean waitEndOfQuery;
    private String clientName;

    public ClickHouseProperties() {
        this(new Properties());
    }

    public ClickHouseProperties(Properties info) {
        this.async = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.ASYNC);
        this.bufferSize = (Integer)this.getSetting(info, ClickHouseConnectionSettings.BUFFER_SIZE);
        this.apacheBufferSize = (Integer)this.getSetting(info, ClickHouseConnectionSettings.APACHE_BUFFER_SIZE);
        this.socketTimeout = (Integer)this.getSetting(info, ClickHouseConnectionSettings.SOCKET_TIMEOUT);
        this.connectionTimeout = (Integer)this.getSetting(info, ClickHouseConnectionSettings.CONNECTION_TIMEOUT);
        this.dataTransferTimeout = (Integer)this.getSetting(info, ClickHouseConnectionSettings.DATA_TRANSFER_TIMEOUT);
        this.timeToLiveMillis = (Integer)this.getSetting(info, ClickHouseConnectionSettings.TIME_TO_LIVE_MILLIS);
        this.defaultMaxPerRoute = (Integer)this.getSetting(info, ClickHouseConnectionSettings.DEFAULT_MAX_PER_ROUTE);
        this.maxTotal = (Integer)this.getSetting(info, ClickHouseConnectionSettings.MAX_TOTAL);
        this.maxRetries = (Integer)this.getSetting(info, ClickHouseConnectionSettings.MAX_RETRIES);
        this.maxCompressBufferSize = (Integer)this.getSetting(info, ClickHouseConnectionSettings.MAX_COMPRESS_BUFFER_SIZE);
        this.ssl = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.SSL);
        this.sslRootCertificate = (String)this.getSetting(info, ClickHouseConnectionSettings.SSL_ROOT_CERTIFICATE);
        this.sslMode = (String)this.getSetting(info, ClickHouseConnectionSettings.SSL_MODE);
        this.usePathAsDb = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.USE_PATH_AS_DB);
        this.path = (String)this.getSetting(info, ClickHouseConnectionSettings.PATH);
        this.maxRedirects = (Integer)this.getSetting(info, ClickHouseConnectionSettings.MAX_REDIRECTS);
        this.checkForRedirects = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.CHECK_FOR_REDIRECTS);
        this.useServerTimeZone = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.USE_SERVER_TIME_ZONE);
        this.useTimeZone = (String)this.getSetting(info, ClickHouseConnectionSettings.USE_TIME_ZONE);
        this.useServerTimeZoneForDates = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.USE_SERVER_TIME_ZONE_FOR_DATES);
        this.useObjectsInArrays = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.USE_OBJECTS_IN_ARRAYS);
        this.useSharedCookieStore = (Boolean)this.getSetting(info, ClickHouseConnectionSettings.USE_SHARED_COOKIE_STORE);
        this.clientName = (String)this.getSetting(info, ClickHouseConnectionSettings.CLIENT_NAME);
        this.maxParallelReplicas = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_PARALLEL_REPLICAS);
        this.maxPartitionsPerInsertBlock = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_PARTITIONS_PER_INSERT_BLOCK);
        this.totalsMode = (String)this.getSetting(info, ClickHouseQueryParam.TOTALS_MODE);
        this.quotaKey = (String)this.getSetting(info, ClickHouseQueryParam.QUOTA_KEY);
        this.priority = (Integer)this.getSetting(info, ClickHouseQueryParam.PRIORITY);
        this.database = (String)this.getSetting(info, ClickHouseQueryParam.DATABASE);
        this.compress = (Boolean)this.getSetting(info, ClickHouseQueryParam.COMPRESS);
        this.decompress = (Boolean)this.getSetting(info, ClickHouseQueryParam.DECOMPRESS);
        this.extremes = (Boolean)this.getSetting(info, ClickHouseQueryParam.EXTREMES);
        this.maxThreads = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_THREADS);
        this.maxExecutionTime = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_EXECUTION_TIME);
        this.maxBlockSize = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_BLOCK_SIZE);
        this.maxRowsToGroupBy = (Integer)this.getSetting(info, ClickHouseQueryParam.MAX_ROWS_TO_GROUP_BY);
        this.profile = (String)this.getSetting(info, ClickHouseQueryParam.PROFILE);
        this.user = (String)this.getSetting(info, ClickHouseQueryParam.USER);
        this.password = (String)this.getSetting(info, ClickHouseQueryParam.PASSWORD);
        this.httpAuthorization = (String)this.getSetting(info, ClickHouseQueryParam.AUTHORIZATION);
        this.distributedAggregationMemoryEfficient = (Boolean)this.getSetting(info, ClickHouseQueryParam.DISTRIBUTED_AGGREGATION_MEMORY_EFFICIENT);
        this.maxBytesBeforeExternalGroupBy = (Long)this.getSetting(info, ClickHouseQueryParam.MAX_BYTES_BEFORE_EXTERNAL_GROUP_BY);
        this.maxBytesBeforeExternalSort = (Long)this.getSetting(info, ClickHouseQueryParam.MAX_BYTES_BEFORE_EXTERNAL_SORT);
        this.maxMemoryUsage = (Long)this.getSetting(info, ClickHouseQueryParam.MAX_MEMORY_USAGE);
        this.maxMemoryUsageForUser = (Long)this.getSetting(info, ClickHouseQueryParam.MAX_MEMORY_USAGE_FOR_USER);
        this.maxMemoryUsageForAllQueries = (Long)this.getSetting(info, ClickHouseQueryParam.MAX_MEMORY_USAGE_FOR_ALL_QUERIES);
        this.preferredBlockSizeBytes = (Long)this.getSetting(info, ClickHouseQueryParam.PREFERRED_BLOCK_SIZE_BYTES);
        this.maxQuerySize = (Long)this.getSetting(info, ClickHouseQueryParam.MAX_QUERY_SIZE);
        this.maxAstElements = (Long)this.getSetting(info, ClickHouseQueryParam.MAX_AST_ELEMENTS);
        this.sessionCheck = (Boolean)this.getSetting(info, ClickHouseQueryParam.SESSION_CHECK);
        this.sessionId = (String)this.getSetting(info, ClickHouseQueryParam.SESSION_ID);
        this.sessionTimeout = (Long)this.getSetting(info, ClickHouseQueryParam.SESSION_TIMEOUT);
        this.insertQuorum = (Long)this.getSetting(info, ClickHouseQueryParam.INSERT_QUORUM);
        this.insertQuorumTimeout = (Long)this.getSetting(info, ClickHouseQueryParam.INSERT_QUORUM_TIMEOUT);
        this.selectSequentialConsistency = (Long)this.getSetting(info, ClickHouseQueryParam.SELECT_SEQUENTIAL_CONSISTENCY);
        this.enableOptimizePredicateExpression = (Boolean)this.getSetting(info, ClickHouseQueryParam.ENABLE_OPTIMIZE_PREDICATE_EXPRESSION);
        this.maxInsertBlockSize = (Long)this.getSetting(info, ClickHouseQueryParam.MAX_INSERT_BLOCK_SIZE);
        this.insertDeduplicate = (Boolean)this.getSetting(info, ClickHouseQueryParam.INSERT_DEDUPLICATE);
        this.insertDistributedSync = (Boolean)this.getSetting(info, ClickHouseQueryParam.INSERT_DISTRIBUTED_SYNC);
        this.anyJoinDistinctRightTableKeys = (Boolean)this.getSetting(info, ClickHouseQueryParam.ANY_JOIN_DISTINCT_RIGHT_TABLE_KEYS);
        this.sendProgressInHttpHeaders = (Boolean)this.getSetting(info, ClickHouseQueryParam.SEND_PROGRESS_IN_HTTP_HEADERS);
        this.waitEndOfQuery = (Boolean)this.getSetting(info, ClickHouseQueryParam.WAIT_END_OF_QUERY);
    }

    public Properties asProperties() {
        PropertiesBuilder ret = new PropertiesBuilder();
        ret.put(ClickHouseConnectionSettings.ASYNC.getKey(), String.valueOf(this.async));
        ret.put(ClickHouseConnectionSettings.BUFFER_SIZE.getKey(), String.valueOf(this.bufferSize));
        ret.put(ClickHouseConnectionSettings.APACHE_BUFFER_SIZE.getKey(), String.valueOf(this.apacheBufferSize));
        ret.put(ClickHouseConnectionSettings.SOCKET_TIMEOUT.getKey(), String.valueOf(this.socketTimeout));
        ret.put(ClickHouseConnectionSettings.CONNECTION_TIMEOUT.getKey(), String.valueOf(this.connectionTimeout));
        ret.put(ClickHouseConnectionSettings.DATA_TRANSFER_TIMEOUT.getKey(), String.valueOf(this.dataTransferTimeout));
        ret.put(ClickHouseConnectionSettings.TIME_TO_LIVE_MILLIS.getKey(), String.valueOf(this.timeToLiveMillis));
        ret.put(ClickHouseConnectionSettings.DEFAULT_MAX_PER_ROUTE.getKey(), String.valueOf(this.defaultMaxPerRoute));
        ret.put(ClickHouseConnectionSettings.MAX_TOTAL.getKey(), String.valueOf(this.maxTotal));
        ret.put(ClickHouseConnectionSettings.MAX_RETRIES.getKey(), String.valueOf(this.maxRetries));
        ret.put(ClickHouseConnectionSettings.MAX_COMPRESS_BUFFER_SIZE.getKey(), String.valueOf(this.maxCompressBufferSize));
        ret.put(ClickHouseConnectionSettings.SSL.getKey(), String.valueOf(this.ssl));
        ret.put(ClickHouseConnectionSettings.SSL_ROOT_CERTIFICATE.getKey(), String.valueOf(this.sslRootCertificate));
        ret.put(ClickHouseConnectionSettings.SSL_MODE.getKey(), String.valueOf(this.sslMode));
        ret.put(ClickHouseConnectionSettings.USE_PATH_AS_DB.getKey(), String.valueOf(this.usePathAsDb));
        ret.put(ClickHouseConnectionSettings.PATH.getKey(), String.valueOf(this.path));
        ret.put(ClickHouseConnectionSettings.MAX_REDIRECTS.getKey(), String.valueOf(this.maxRedirects));
        ret.put(ClickHouseConnectionSettings.CHECK_FOR_REDIRECTS.getKey(), String.valueOf(this.checkForRedirects));
        ret.put(ClickHouseConnectionSettings.USE_SERVER_TIME_ZONE.getKey(), String.valueOf(this.useServerTimeZone));
        ret.put(ClickHouseConnectionSettings.USE_TIME_ZONE.getKey(), String.valueOf(this.useTimeZone));
        ret.put(ClickHouseConnectionSettings.USE_SERVER_TIME_ZONE_FOR_DATES.getKey(), String.valueOf(this.useServerTimeZoneForDates));
        ret.put(ClickHouseConnectionSettings.USE_OBJECTS_IN_ARRAYS.getKey(), String.valueOf(this.useObjectsInArrays));
        ret.put(ClickHouseConnectionSettings.USE_SHARED_COOKIE_STORE.getKey(), String.valueOf(this.useSharedCookieStore));
        ret.put(ClickHouseConnectionSettings.CLIENT_NAME.getKey(), String.valueOf(this.clientName));
        ret.put(ClickHouseQueryParam.MAX_PARALLEL_REPLICAS.getKey(), this.maxParallelReplicas);
        ret.put(ClickHouseQueryParam.MAX_PARTITIONS_PER_INSERT_BLOCK.getKey(), this.maxPartitionsPerInsertBlock);
        ret.put(ClickHouseQueryParam.TOTALS_MODE.getKey(), this.totalsMode);
        ret.put(ClickHouseQueryParam.QUOTA_KEY.getKey(), this.quotaKey);
        ret.put(ClickHouseQueryParam.PRIORITY.getKey(), this.priority);
        ret.put(ClickHouseQueryParam.DATABASE.getKey(), this.database);
        ret.put(ClickHouseQueryParam.COMPRESS.getKey(), String.valueOf(this.compress));
        ret.put(ClickHouseQueryParam.DECOMPRESS.getKey(), String.valueOf(this.decompress));
        ret.put(ClickHouseQueryParam.EXTREMES.getKey(), String.valueOf(this.extremes));
        ret.put(ClickHouseQueryParam.MAX_THREADS.getKey(), this.maxThreads);
        ret.put(ClickHouseQueryParam.MAX_EXECUTION_TIME.getKey(), this.maxExecutionTime);
        ret.put(ClickHouseQueryParam.MAX_BLOCK_SIZE.getKey(), this.maxBlockSize);
        ret.put(ClickHouseQueryParam.MAX_ROWS_TO_GROUP_BY.getKey(), this.maxRowsToGroupBy);
        ret.put(ClickHouseQueryParam.PROFILE.getKey(), this.profile);
        ret.put(ClickHouseQueryParam.USER.getKey(), this.user);
        ret.put(ClickHouseQueryParam.PASSWORD.getKey(), this.password);
        ret.put(ClickHouseQueryParam.AUTHORIZATION.getKey(), this.httpAuthorization);
        ret.put(ClickHouseQueryParam.DISTRIBUTED_AGGREGATION_MEMORY_EFFICIENT.getKey(), String.valueOf(this.distributedAggregationMemoryEfficient));
        ret.put(ClickHouseQueryParam.MAX_BYTES_BEFORE_EXTERNAL_GROUP_BY.getKey(), this.maxBytesBeforeExternalGroupBy);
        ret.put(ClickHouseQueryParam.MAX_BYTES_BEFORE_EXTERNAL_SORT.getKey(), this.maxBytesBeforeExternalSort);
        ret.put(ClickHouseQueryParam.MAX_MEMORY_USAGE.getKey(), this.maxMemoryUsage);
        ret.put(ClickHouseQueryParam.MAX_MEMORY_USAGE_FOR_USER.getKey(), this.maxMemoryUsageForUser);
        ret.put(ClickHouseQueryParam.MAX_MEMORY_USAGE_FOR_ALL_QUERIES.getKey(), this.maxMemoryUsageForAllQueries);
        ret.put(ClickHouseQueryParam.PREFERRED_BLOCK_SIZE_BYTES.getKey(), this.preferredBlockSizeBytes);
        ret.put(ClickHouseQueryParam.MAX_QUERY_SIZE.getKey(), this.maxQuerySize);
        ret.put(ClickHouseQueryParam.MAX_AST_ELEMENTS.getKey(), this.maxAstElements);
        ret.put(ClickHouseQueryParam.SESSION_CHECK.getKey(), String.valueOf(this.sessionCheck));
        ret.put(ClickHouseQueryParam.SESSION_ID.getKey(), this.sessionId);
        ret.put(ClickHouseQueryParam.SESSION_TIMEOUT.getKey(), this.sessionTimeout);
        ret.put(ClickHouseQueryParam.INSERT_QUORUM.getKey(), this.insertQuorum);
        ret.put(ClickHouseQueryParam.INSERT_QUORUM_TIMEOUT.getKey(), this.insertQuorumTimeout);
        ret.put(ClickHouseQueryParam.SELECT_SEQUENTIAL_CONSISTENCY.getKey(), this.selectSequentialConsistency);
        ret.put(ClickHouseQueryParam.ENABLE_OPTIMIZE_PREDICATE_EXPRESSION.getKey(), this.enableOptimizePredicateExpression);
        ret.put(ClickHouseQueryParam.MAX_INSERT_BLOCK_SIZE.getKey(), this.maxInsertBlockSize);
        ret.put(ClickHouseQueryParam.INSERT_DEDUPLICATE.getKey(), this.insertDeduplicate);
        ret.put(ClickHouseQueryParam.INSERT_DISTRIBUTED_SYNC.getKey(), this.insertDistributedSync);
        ret.put(ClickHouseQueryParam.ANY_JOIN_DISTINCT_RIGHT_TABLE_KEYS.getKey(), this.anyJoinDistinctRightTableKeys);
        ret.put(ClickHouseQueryParam.SEND_PROGRESS_IN_HTTP_HEADERS.getKey(), this.sendProgressInHttpHeaders);
        ret.put(ClickHouseQueryParam.WAIT_END_OF_QUERY.getKey(), this.waitEndOfQuery);
        return ret.getProperties();
    }

    public ClickHouseProperties(ClickHouseProperties properties) {
        this.setHost(properties.host);
        this.setPort(properties.port);
        this.setAsync(properties.async);
        this.setBufferSize(properties.bufferSize);
        this.setApacheBufferSize(properties.apacheBufferSize);
        this.setSocketTimeout(properties.socketTimeout);
        this.setConnectionTimeout(properties.connectionTimeout);
        this.setDataTransferTimeout(properties.dataTransferTimeout);
        this.setTimeToLiveMillis(properties.timeToLiveMillis);
        this.setDefaultMaxPerRoute(properties.defaultMaxPerRoute);
        this.setMaxTotal(properties.maxTotal);
        this.setMaxRetries(properties.maxRetries);
        this.setMaxCompressBufferSize(properties.maxCompressBufferSize);
        this.setSsl(properties.ssl);
        this.setSslRootCertificate(properties.sslRootCertificate);
        this.setSslMode(properties.sslMode);
        this.setUsePathAsDb(properties.usePathAsDb);
        this.setPath(properties.path);
        this.setMaxRedirects(properties.maxRedirects);
        this.setCheckForRedirects(properties.checkForRedirects);
        this.setUseServerTimeZone(properties.useServerTimeZone);
        this.setUseTimeZone(properties.useTimeZone);
        this.setUseServerTimeZoneForDates(properties.useServerTimeZoneForDates);
        this.setUseObjectsInArrays(properties.useObjectsInArrays);
        this.setUseSharedCookieStore(properties.useSharedCookieStore);
        this.setClientName(properties.clientName);
        this.setMaxParallelReplicas(properties.maxParallelReplicas);
        this.setMaxPartitionsPerInsertBlock(properties.maxPartitionsPerInsertBlock);
        this.setTotalsMode(properties.totalsMode);
        this.setQuotaKey(properties.quotaKey);
        this.setPriority(properties.priority);
        this.setDatabase(properties.database);
        this.setCompress(properties.compress);
        this.setDecompress(properties.decompress);
        this.setExtremes(properties.extremes);
        this.setMaxThreads(properties.maxThreads);
        this.setMaxExecutionTime(properties.maxExecutionTime);
        this.setMaxBlockSize(properties.maxBlockSize);
        this.setMaxRowsToGroupBy(properties.maxRowsToGroupBy);
        this.setProfile(properties.profile);
        this.setUser(properties.user);
        this.setPassword(properties.password);
        this.setHttpAuthorization(properties.httpAuthorization);
        this.setDistributedAggregationMemoryEfficient(properties.distributedAggregationMemoryEfficient);
        this.setMaxBytesBeforeExternalGroupBy(properties.maxBytesBeforeExternalGroupBy);
        this.setMaxBytesBeforeExternalSort(properties.maxBytesBeforeExternalSort);
        this.setMaxMemoryUsage(properties.maxMemoryUsage);
        this.setMaxMemoryUsageForUser(properties.maxMemoryUsageForUser);
        this.setMaxMemoryUsageForAllQueries(properties.maxMemoryUsageForAllQueries);
        this.setSessionCheck(properties.sessionCheck);
        this.setSessionId(properties.sessionId);
        this.setSessionTimeout(properties.sessionTimeout);
        this.setInsertQuorum(properties.insertQuorum);
        this.setInsertQuorumTimeout(properties.insertQuorumTimeout);
        this.setSelectSequentialConsistency(properties.selectSequentialConsistency);
        this.setPreferredBlockSizeBytes(properties.preferredBlockSizeBytes);
        this.setMaxQuerySize(properties.maxQuerySize);
        this.setMaxAstElements(properties.maxAstElements);
        this.setEnableOptimizePredicateExpression(properties.enableOptimizePredicateExpression);
        this.setMaxInsertBlockSize(properties.maxInsertBlockSize);
        this.setInsertDeduplicate(properties.insertDeduplicate);
        this.setInsertDistributedSync(properties.insertDistributedSync);
        this.setAnyJoinDistinctRightTableKeys(properties.anyJoinDistinctRightTableKeys);
        this.setSendProgressInHttpHeaders(properties.sendProgressInHttpHeaders);
        this.setWaitEndOfQuery(properties.waitEndOfQuery);
    }

    public Map<ClickHouseQueryParam, String> buildQueryParams(boolean ignoreDatabase) {
        HashMap<ClickHouseQueryParam, String> params = new HashMap<ClickHouseQueryParam, String>();
        if (this.maxParallelReplicas != null) {
            params.put(ClickHouseQueryParam.MAX_PARALLEL_REPLICAS, String.valueOf(this.maxParallelReplicas));
        }
        if (this.maxPartitionsPerInsertBlock != null) {
            params.put(ClickHouseQueryParam.MAX_PARTITIONS_PER_INSERT_BLOCK, String.valueOf(this.maxPartitionsPerInsertBlock));
        }
        if (this.maxRowsToGroupBy != null) {
            params.put(ClickHouseQueryParam.MAX_ROWS_TO_GROUP_BY, String.valueOf(this.maxRowsToGroupBy));
        }
        if (this.totalsMode != null) {
            params.put(ClickHouseQueryParam.TOTALS_MODE, this.totalsMode);
        }
        if (this.quotaKey != null) {
            params.put(ClickHouseQueryParam.QUOTA_KEY, this.quotaKey);
        }
        if (this.priority != null) {
            params.put(ClickHouseQueryParam.PRIORITY, String.valueOf(this.priority));
        }
        if (!StringUtils.isBlank(this.database) && !ignoreDatabase) {
            params.put(ClickHouseQueryParam.DATABASE, this.getDatabase());
        }
        if (this.compress) {
            params.put(ClickHouseQueryParam.COMPRESS, "1");
        }
        if (this.decompress) {
            params.put(ClickHouseQueryParam.DECOMPRESS, "1");
        }
        if (this.extremes) {
            params.put(ClickHouseQueryParam.EXTREMES, "1");
        }
        if (StringUtils.isBlank(this.profile)) {
            if (this.getMaxThreads() != null) {
                params.put(ClickHouseQueryParam.MAX_THREADS, String.valueOf(this.maxThreads));
            }
            if (this.getMaxExecutionTime() != null) {
                params.put(ClickHouseQueryParam.MAX_EXECUTION_TIME, String.valueOf(this.maxExecutionTime));
            }
            if (this.getMaxBlockSize() != null) {
                params.put(ClickHouseQueryParam.MAX_BLOCK_SIZE, String.valueOf(this.getMaxBlockSize()));
            }
        } else {
            params.put(ClickHouseQueryParam.PROFILE, this.profile);
        }
        if (this.distributedAggregationMemoryEfficient) {
            params.put(ClickHouseQueryParam.DISTRIBUTED_AGGREGATION_MEMORY_EFFICIENT, "1");
        }
        if (this.maxBytesBeforeExternalGroupBy != null) {
            params.put(ClickHouseQueryParam.MAX_BYTES_BEFORE_EXTERNAL_GROUP_BY, String.valueOf(this.maxBytesBeforeExternalGroupBy));
        }
        if (this.maxBytesBeforeExternalSort != null) {
            params.put(ClickHouseQueryParam.MAX_BYTES_BEFORE_EXTERNAL_SORT, String.valueOf(this.maxBytesBeforeExternalSort));
        }
        if (this.maxMemoryUsage != null) {
            params.put(ClickHouseQueryParam.MAX_MEMORY_USAGE, String.valueOf(this.maxMemoryUsage));
        }
        if (this.maxMemoryUsageForUser != null) {
            params.put(ClickHouseQueryParam.MAX_MEMORY_USAGE_FOR_USER, String.valueOf(this.maxMemoryUsageForUser));
        }
        if (this.maxMemoryUsageForAllQueries != null) {
            params.put(ClickHouseQueryParam.MAX_MEMORY_USAGE_FOR_ALL_QUERIES, String.valueOf(this.maxMemoryUsageForAllQueries));
        }
        if (this.preferredBlockSizeBytes != null) {
            params.put(ClickHouseQueryParam.PREFERRED_BLOCK_SIZE_BYTES, String.valueOf(this.preferredBlockSizeBytes));
        }
        if (this.maxQuerySize != null) {
            params.put(ClickHouseQueryParam.MAX_QUERY_SIZE, String.valueOf(this.maxQuerySize));
        }
        if (this.maxAstElements != null) {
            params.put(ClickHouseQueryParam.MAX_AST_ELEMENTS, String.valueOf(this.maxAstElements));
        }
        if (this.sessionCheck) {
            params.put(ClickHouseQueryParam.SESSION_CHECK, "1");
        }
        if (this.sessionId != null) {
            params.put(ClickHouseQueryParam.SESSION_ID, String.valueOf(this.sessionId));
        }
        if (this.sessionTimeout != null) {
            params.put(ClickHouseQueryParam.SESSION_TIMEOUT, String.valueOf(this.sessionTimeout));
        }
        this.addQueryParam(this.insertQuorum, ClickHouseQueryParam.INSERT_QUORUM, params);
        this.addQueryParam(this.insertQuorumTimeout, ClickHouseQueryParam.INSERT_QUORUM_TIMEOUT, params);
        this.addQueryParam(this.selectSequentialConsistency, ClickHouseQueryParam.SELECT_SEQUENTIAL_CONSISTENCY, params);
        this.addQueryParam(this.maxInsertBlockSize, ClickHouseQueryParam.MAX_INSERT_BLOCK_SIZE, params);
        this.addQueryParam(this.insertDeduplicate, ClickHouseQueryParam.INSERT_DEDUPLICATE, params);
        this.addQueryParam(this.insertDistributedSync, ClickHouseQueryParam.INSERT_DISTRIBUTED_SYNC, params);
        this.addQueryParam(this.anyJoinDistinctRightTableKeys, ClickHouseQueryParam.ANY_JOIN_DISTINCT_RIGHT_TABLE_KEYS, params);
        if (this.enableOptimizePredicateExpression != null) {
            params.put(ClickHouseQueryParam.ENABLE_OPTIMIZE_PREDICATE_EXPRESSION, this.enableOptimizePredicateExpression != false ? "1" : "0");
        }
        this.addQueryParam(this.sendProgressInHttpHeaders, ClickHouseQueryParam.SEND_PROGRESS_IN_HTTP_HEADERS, params);
        this.addQueryParam(this.waitEndOfQuery, ClickHouseQueryParam.WAIT_END_OF_QUERY, params);
        return params;
    }

    private void addQueryParam(Object param, ClickHouseQueryParam definition, Map<ClickHouseQueryParam, String> params) {
        if (param != null) {
            if (definition.getClazz() == Boolean.class || definition.getClazz() == Boolean.TYPE) {
                params.put(definition, (Boolean)param != false ? "1" : "0");
            } else {
                params.put(definition, String.valueOf(param));
            }
        }
    }

    public ClickHouseProperties withCredentials(String user, String password) {
        ClickHouseProperties copy = new ClickHouseProperties(this);
        copy.setUser(user);
        copy.setPassword(password);
        return copy;
    }

    private <T> T getSetting(Properties info, ClickHouseQueryParam param) {
        return this.getSetting(info, param.getKey(), param.getDefaultValue(), param.getClazz());
    }

    private <T> T getSetting(Properties info, ClickHouseConnectionSettings settings) {
        return this.getSetting(info, settings.getKey(), settings.getDefaultValue(), settings.getClazz());
    }

    private <T> T getSetting(Properties info, String key, Object defaultValue, Class clazz) {
        String val2 = info.getProperty(key);
        if (val2 == null) {
            return (T)defaultValue;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return clazz.cast(Integer.valueOf(val2));
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return clazz.cast(Long.valueOf(val2));
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            Boolean boolValue = "1".equals(val2) || "0".equals(val2) ? Boolean.valueOf("1".equals(val2)) : Boolean.valueOf(val2);
            return clazz.cast(boolValue);
        }
        return clazz.cast(val2);
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public boolean isDecompress() {
        return this.decompress;
    }

    public void setDecompress(boolean decompress) {
        this.decompress = decompress;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(Integer maxThreads) {
        this.maxThreads = maxThreads;
    }

    public Integer getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public void setMaxBlockSize(Integer maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getApacheBufferSize() {
        return this.apacheBufferSize;
    }

    public void setApacheBufferSize(int apacheBufferSize) {
        this.apacheBufferSize = apacheBufferSize;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getDataTransferTimeout() {
        return this.dataTransferTimeout;
    }

    public void setDataTransferTimeout(int dataTransferTimeout) {
        this.dataTransferTimeout = dataTransferTimeout;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public int getTimeToLiveMillis() {
        return this.timeToLiveMillis;
    }

    public void setTimeToLiveMillis(int timeToLiveMillis) {
        this.timeToLiveMillis = timeToLiveMillis;
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public void setDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getMaxCompressBufferSize() {
        return this.maxCompressBufferSize;
    }

    public void setMaxCompressBufferSize(int maxCompressBufferSize) {
        this.maxCompressBufferSize = maxCompressBufferSize;
    }

    public boolean getSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getSslRootCertificate() {
        return this.sslRootCertificate;
    }

    public void setSslRootCertificate(String sslRootCertificate) {
        this.sslRootCertificate = sslRootCertificate;
    }

    public String getSslMode() {
        return this.sslMode;
    }

    public void setSslMode(String sslMode) {
        this.sslMode = sslMode;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public boolean isCheckForRedirects() {
        return this.checkForRedirects;
    }

    public void setCheckForRedirects(boolean checkForRedirects) {
        this.checkForRedirects = checkForRedirects;
    }

    public boolean isUseServerTimeZone() {
        return this.useServerTimeZone;
    }

    public void setUseServerTimeZone(boolean useServerTimeZone) {
        this.useServerTimeZone = useServerTimeZone;
    }

    public String getUseTimeZone() {
        return this.useTimeZone;
    }

    public void setUseTimeZone(String useTimeZone) {
        this.useTimeZone = useTimeZone;
    }

    public boolean isUseObjectsInArrays() {
        return this.useObjectsInArrays;
    }

    public void setUseObjectsInArrays(boolean useObjectsInArrays) {
        this.useObjectsInArrays = useObjectsInArrays;
    }

    public boolean isUseSharedCookieStore() {
        return this.useSharedCookieStore;
    }

    public void setUseSharedCookieStore(boolean useSharedCookieStore) {
        this.useSharedCookieStore = useSharedCookieStore;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public boolean isUseServerTimeZoneForDates() {
        return this.useServerTimeZoneForDates;
    }

    public void setUseServerTimeZoneForDates(boolean useServerTimeZoneForDates) {
        this.useServerTimeZoneForDates = useServerTimeZoneForDates;
    }

    public Integer getMaxParallelReplicas() {
        return this.maxParallelReplicas;
    }

    public void setMaxParallelReplicas(Integer maxParallelReplicas) {
        this.maxParallelReplicas = maxParallelReplicas;
    }

    public Integer getMaxPartitionsPerInsertBlock() {
        return this.maxPartitionsPerInsertBlock;
    }

    public void setMaxPartitionsPerInsertBlock(Integer maxPartitionsPerInsertBlock) {
        this.maxPartitionsPerInsertBlock = maxPartitionsPerInsertBlock;
    }

    public String getTotalsMode() {
        return this.totalsMode;
    }

    public void setTotalsMode(String totalsMode) {
        this.totalsMode = totalsMode;
    }

    public String getQuotaKey() {
        return this.quotaKey;
    }

    public void setQuotaKey(String quotaKey) {
        this.quotaKey = quotaKey;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public boolean isExtremes() {
        return this.extremes;
    }

    public void setExtremes(boolean extremes) {
        this.extremes = extremes;
    }

    public Integer getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public void setMaxExecutionTime(Integer maxExecutionTime) {
        this.maxExecutionTime = maxExecutionTime;
    }

    public Integer getMaxRowsToGroupBy() {
        return this.maxRowsToGroupBy;
    }

    public void setMaxRowsToGroupBy(Integer maxRowsToGroupBy) {
        this.maxRowsToGroupBy = maxRowsToGroupBy;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getHttpAuthorization() {
        return this.httpAuthorization;
    }

    public void setHttpAuthorization(String httpAuthorization) {
        this.httpAuthorization = httpAuthorization;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isUsePathAsDb() {
        return this.usePathAsDb;
    }

    public void setUsePathAsDb(boolean usePathAsDb) {
        this.usePathAsDb = usePathAsDb;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isDistributedAggregationMemoryEfficient() {
        return this.distributedAggregationMemoryEfficient;
    }

    public void setDistributedAggregationMemoryEfficient(boolean distributedAggregationMemoryEfficient) {
        this.distributedAggregationMemoryEfficient = distributedAggregationMemoryEfficient;
    }

    public Long getMaxBytesBeforeExternalGroupBy() {
        return this.maxBytesBeforeExternalGroupBy;
    }

    public void setMaxBytesBeforeExternalGroupBy(Long maxBytesBeforeExternalGroupBy) {
        this.maxBytesBeforeExternalGroupBy = maxBytesBeforeExternalGroupBy;
    }

    public Long getMaxBytesBeforeExternalSort() {
        return this.maxBytesBeforeExternalSort;
    }

    public void setMaxBytesBeforeExternalSort(Long maxBytesBeforeExternalSort) {
        this.maxBytesBeforeExternalSort = maxBytesBeforeExternalSort;
    }

    public Long getMaxMemoryUsage() {
        return this.maxMemoryUsage;
    }

    public void setMaxMemoryUsage(Long maxMemoryUsage) {
        this.maxMemoryUsage = maxMemoryUsage;
    }

    public Long getMaxMemoryUsageForUser() {
        return this.maxMemoryUsageForUser;
    }

    public void setMaxMemoryUsageForUser(Long maxMemoryUsageForUser) {
        this.maxMemoryUsageForUser = maxMemoryUsageForUser;
    }

    public Long getMaxMemoryUsageForAllQueries() {
        return this.maxMemoryUsageForAllQueries;
    }

    public void setMaxMemoryUsageForAllQueries(Long maxMemoryUsageForAllQueries) {
        this.maxMemoryUsageForAllQueries = maxMemoryUsageForAllQueries;
    }

    public Long getPreferredBlockSizeBytes() {
        return this.preferredBlockSizeBytes;
    }

    public void setPreferredBlockSizeBytes(Long preferredBlockSizeBytes) {
        this.preferredBlockSizeBytes = preferredBlockSizeBytes;
    }

    public Long getMaxQuerySize() {
        return this.maxQuerySize;
    }

    public void setMaxQuerySize(Long maxQuerySize) {
        this.maxQuerySize = maxQuerySize;
    }

    public void setMaxAstElements(Long maxAstElements) {
        this.maxAstElements = maxAstElements;
    }

    public Long getMaxAstElements() {
        return this.maxAstElements;
    }

    public boolean isSessionCheck() {
        return this.sessionCheck;
    }

    public void setSessionCheck(boolean sessionCheck) {
        this.sessionCheck = sessionCheck;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public Long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Long getInsertQuorum() {
        return this.insertQuorum;
    }

    public void setInsertQuorum(Long insertQuorum) {
        this.insertQuorum = insertQuorum;
    }

    public Long getInsertQuorumTimeout() {
        return this.insertQuorumTimeout;
    }

    public void setInsertQuorumTimeout(Long insertQuorumTimeout) {
        this.insertQuorumTimeout = insertQuorumTimeout;
    }

    public Long getSelectSequentialConsistency() {
        return this.selectSequentialConsistency;
    }

    public void setSelectSequentialConsistency(Long selectSequentialConsistency) {
        this.selectSequentialConsistency = selectSequentialConsistency;
    }

    public Boolean getEnableOptimizePredicateExpression() {
        return this.enableOptimizePredicateExpression;
    }

    public void setEnableOptimizePredicateExpression(Boolean enableOptimizePredicateExpression) {
        this.enableOptimizePredicateExpression = enableOptimizePredicateExpression;
    }

    public Long getMaxInsertBlockSize() {
        return this.maxInsertBlockSize;
    }

    public void setMaxInsertBlockSize(Long maxInsertBlockSize) {
        this.maxInsertBlockSize = maxInsertBlockSize;
    }

    public Boolean getInsertDeduplicate() {
        return this.insertDeduplicate;
    }

    public void setInsertDeduplicate(Boolean insertDeduplicate) {
        this.insertDeduplicate = insertDeduplicate;
    }

    public Boolean getInsertDistributedSync() {
        return this.insertDistributedSync;
    }

    public void setInsertDistributedSync(Boolean insertDistributedSync) {
        this.insertDistributedSync = insertDistributedSync;
    }

    public void setAnyJoinDistinctRightTableKeys(Boolean anyJoinDistinctRightTableKeys) {
        this.anyJoinDistinctRightTableKeys = anyJoinDistinctRightTableKeys;
    }

    public Boolean getAnyJoinDistinctRightTableKeys() {
        return this.anyJoinDistinctRightTableKeys;
    }

    public Boolean getSendProgressInHttpHeaders() {
        return this.sendProgressInHttpHeaders;
    }

    public void setSendProgressInHttpHeaders(Boolean sendProgressInHttpHeaders) {
        this.sendProgressInHttpHeaders = sendProgressInHttpHeaders;
    }

    public Boolean getWaitEndOfQuery() {
        return this.waitEndOfQuery;
    }

    public void setWaitEndOfQuery(Boolean waitEndOfQuery) {
        this.waitEndOfQuery = waitEndOfQuery;
    }

    public ClickHouseProperties merge(ClickHouseProperties second) {
        Properties properties = this.asProperties();
        for (Map.Entry<Object, Object> entry : second.asProperties().entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return new ClickHouseProperties(properties);
    }

    public ClickHouseProperties merge(Properties other) {
        Properties properties = this.asProperties();
        for (Map.Entry<Object, Object> entry : other.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        return new ClickHouseProperties(properties);
    }

    private static class PropertiesBuilder {
        private final Properties properties = new Properties();

        public void put(String key, int value) {
            this.properties.put(key, (Object)value);
        }

        public void put(String key, Integer value) {
            if (value != null) {
                this.properties.put(key, value.toString());
            }
        }

        public void put(String key, Long value) {
            if (value != null) {
                this.properties.put(key, value.toString());
            }
        }

        public void put(String key, Boolean value) {
            if (value != null) {
                this.properties.put(key, value.toString());
            }
        }

        public void put(String key, String value) {
            if (value != null) {
                this.properties.put(key, value);
            }
        }

        public Properties getProperties() {
            return this.properties;
        }
    }
}

