/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import ru.yandex.clickhouse.domain.ClickHouseDataType;
import ru.yandex.clickhouse.except.ClickHouseUnknownException;
import ru.yandex.clickhouse.response.ByteFragment;
import ru.yandex.clickhouse.response.ClickHouseColumnInfo;
import ru.yandex.clickhouse.response.parser.ClickHouseArrayParser;
import ru.yandex.clickhouse.response.parser.ClickHouseBitmapParser;
import ru.yandex.clickhouse.response.parser.ClickHouseDoubleParser;
import ru.yandex.clickhouse.response.parser.ClickHouseInstantParser;
import ru.yandex.clickhouse.response.parser.ClickHouseLocalDateParser;
import ru.yandex.clickhouse.response.parser.ClickHouseLocalDateTimeParser;
import ru.yandex.clickhouse.response.parser.ClickHouseLocalTimeParser;
import ru.yandex.clickhouse.response.parser.ClickHouseMapParser;
import ru.yandex.clickhouse.response.parser.ClickHouseOffsetDateTimeParser;
import ru.yandex.clickhouse.response.parser.ClickHouseOffsetTimeParser;
import ru.yandex.clickhouse.response.parser.ClickHouseSQLDateParser;
import ru.yandex.clickhouse.response.parser.ClickHouseSQLTimeParser;
import ru.yandex.clickhouse.response.parser.ClickHouseSQLTimestampParser;
import ru.yandex.clickhouse.response.parser.ClickHouseStringParser;
import ru.yandex.clickhouse.response.parser.ClickHouseZonedDateTimeParser;
import ru.yandex.clickhouse.util.ClickHouseBitmap;

public abstract class ClickHouseValueParser<T> {
    static Map<Class<?>, ClickHouseValueParser<?>> parsers = new HashMap();
    private static final long MILLISECONDS_A_DAY = 86400000L;

    public static long normalizeTime(ClickHouseColumnInfo info, long time) {
        if (info == null || info.getClickHouseDataType() != ClickHouseDataType.DateTime64 && info.getScale() == 0) {
            time -= time % 1000L;
        }
        return (time + 86400000L) % 86400000L;
    }

    private static <T> void register(Class<T> clazz, Function<String, T> parseFunction) {
        parsers.put(clazz, new ClickHouseValueParserFunctionWrapper(parseFunction, null, null, clazz));
    }

    private static <T> void register(Class<T> clazz, Function<String, T> parseFunction, T defaultValue) {
        parsers.put(clazz, new ClickHouseValueParserFunctionWrapper(parseFunction, defaultValue, null, clazz));
    }

    private static <T> void register(Class<T> clazz, Function<String, T> parseFunction, T defaultValue, T nanValue) {
        parsers.put(clazz, new ClickHouseValueParserFunctionWrapper(parseFunction, defaultValue, nanValue, clazz));
    }

    private static <T> void register(Class<T> clazz, ClickHouseValueParser<T> parser) {
        if (parsers.containsKey(clazz)) {
            throw new IllegalStateException("duplicate parsers for class " + clazz.getName());
        }
        parsers.put(clazz, Objects.requireNonNull(parser));
    }

    public static <T> ClickHouseValueParser<T> getParser(Class<T> clazz) throws SQLException {
        ClickHouseValueParser<?> p = parsers.get(clazz);
        if (p == null) {
            throw new ClickHouseUnknownException("No value parser for class '" + clazz.getName() + "'", null);
        }
        return p;
    }

    public static final int parseInt(ByteFragment value, ClickHouseColumnInfo columnInfo) throws SQLException {
        Integer i = ClickHouseValueParser.getParser(Integer.class).parse(value, columnInfo, null);
        return i != null ? i : 0;
    }

    public static final long parseLong(ByteFragment value, ClickHouseColumnInfo columnInfo) throws SQLException {
        Long l = ClickHouseValueParser.getParser(Long.class).parse(value, columnInfo, null);
        return l != null ? l : 0L;
    }

    public static final boolean parseBoolean(ByteFragment value, ClickHouseColumnInfo columnInfo) throws SQLException {
        Boolean b = ClickHouseValueParser.getParser(Boolean.class).parse(value, columnInfo, null);
        return b != null ? b : false;
    }

    public static final short parseShort(ByteFragment value, ClickHouseColumnInfo columnInfo) throws SQLException {
        Short s2 = ClickHouseValueParser.getParser(Short.class).parse(value, columnInfo, null);
        return s2 != null ? s2 : (short)0;
    }

    public static final double parseDouble(ByteFragment value, ClickHouseColumnInfo columnInfo) throws SQLException {
        Double d = ClickHouseValueParser.getParser(Double.class).parse(value, columnInfo, null);
        return d != null ? d : 0.0;
    }

    public static final float parseFloat(ByteFragment value, ClickHouseColumnInfo columnInfo) throws SQLException {
        Double d = ClickHouseValueParser.getParser(Double.class).parse(value, columnInfo, null);
        return d != null ? d.floatValue() : 0.0f;
    }

    public abstract T parse(ByteFragment var1, ClickHouseColumnInfo var2, TimeZone var3) throws SQLException;

    public T parseWithDefault(ByteFragment value, ClickHouseColumnInfo columnInfo, TimeZone resultTimeZone) throws SQLException {
        T t = this.parse(value, columnInfo, resultTimeZone);
        return t == null ? this.getDefaultValue() : t;
    }

    protected T getDefaultValue() {
        return null;
    }

    static {
        ClickHouseValueParser.register(Array.class, ClickHouseArrayParser.getInstance());
        ClickHouseValueParser.register(BigDecimal.class, BigDecimal::new);
        ClickHouseValueParser.register(BigInteger.class, BigInteger::new);
        ClickHouseValueParser.register(Boolean.class, s2 -> "1".equals(s2) || Boolean.parseBoolean(s2), Boolean.FALSE);
        ClickHouseValueParser.register(Date.class, ClickHouseSQLDateParser.getInstance());
        ClickHouseValueParser.register(Double.class, ClickHouseDoubleParser.getInstance());
        ClickHouseValueParser.register(Float.class, Float::valueOf, Float.valueOf(0.0f), Float.valueOf(Float.NaN));
        ClickHouseValueParser.register(Instant.class, ClickHouseInstantParser.getInstance());
        ClickHouseValueParser.register(Integer.class, Integer::decode, 0);
        ClickHouseValueParser.register(LocalDate.class, ClickHouseLocalDateParser.getInstance());
        ClickHouseValueParser.register(LocalDateTime.class, ClickHouseLocalDateTimeParser.getInstance());
        ClickHouseValueParser.register(LocalTime.class, ClickHouseLocalTimeParser.getInstance());
        ClickHouseValueParser.register(Long.class, Long::decode, 0L);
        ClickHouseValueParser.register(ClickHouseBitmap.class, ClickHouseBitmapParser.getInstance());
        ClickHouseValueParser.register(Map.class, ClickHouseMapParser.getInstance());
        ClickHouseValueParser.register(Object.class, (String s2) -> s2);
        ClickHouseValueParser.register(OffsetDateTime.class, ClickHouseOffsetDateTimeParser.getInstance());
        ClickHouseValueParser.register(OffsetTime.class, ClickHouseOffsetTimeParser.getInstance());
        ClickHouseValueParser.register(Short.class, Short::decode, (short)0);
        ClickHouseValueParser.register(String.class, ClickHouseStringParser.getInstance());
        ClickHouseValueParser.register(Time.class, ClickHouseSQLTimeParser.getInstance());
        ClickHouseValueParser.register(Timestamp.class, ClickHouseSQLTimestampParser.getInstance());
        ClickHouseValueParser.register(UUID.class, UUID::fromString);
        ClickHouseValueParser.register(ZonedDateTime.class, ClickHouseZonedDateTimeParser.getInstance());
    }

    private static final class ClickHouseValueParserFunctionWrapper<T>
    extends ClickHouseValueParser<T> {
        private final Function<String, T> f;
        private final T nanValue;
        private final T defaultValue;
        private final Class<T> clazz;

        private ClickHouseValueParserFunctionWrapper(Function<String, T> f, T defaultValue, T nanValue, Class<T> clazz) {
            this.f = Objects.requireNonNull(f);
            this.nanValue = nanValue;
            this.defaultValue = defaultValue;
            this.clazz = Objects.requireNonNull(clazz);
        }

        @Override
        public T parse(ByteFragment value, ClickHouseColumnInfo columnInfo, TimeZone resultTimeZone) throws SQLException {
            if (value.isNull() || value.isEmpty()) {
                return null;
            }
            if (this.nanValue != null && value.isNaN()) {
                return this.nanValue;
            }
            try {
                return this.f.apply(value.asString());
            }
            catch (Exception e) {
                throw new ClickHouseUnknownException("Error parsing '" + value.asString() + "' as " + this.clazz.getName(), e);
            }
        }

        @Override
        protected T getDefaultValue() {
            return this.defaultValue;
        }
    }
}

