/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ClickHouseUtil {
    private static final Map<Character, String> escapeMapping;

    public static String escape(String s2) {
        if (s2 == null) {
            return "\\N";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char ch = s2.charAt(i);
            String escaped = escapeMapping.get(Character.valueOf(ch));
            if (escaped != null) {
                sb.append(escaped);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String quoteIdentifier(String s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("Can't quote null as identifier");
        }
        StringBuilder sb = new StringBuilder(s2.length() + 2);
        sb.append('`');
        sb.append(ClickHouseUtil.escape(s2));
        sb.append('`');
        return sb.toString();
    }

    static {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf('\\'), "\\\\");
        map.put(Character.valueOf('\n'), "\\n");
        map.put(Character.valueOf('\t'), "\\t");
        map.put(Character.valueOf('\b'), "\\b");
        map.put(Character.valueOf('\f'), "\\f");
        map.put(Character.valueOf('\r'), "\\r");
        map.put(Character.valueOf('\u0000'), "\\0");
        map.put(Character.valueOf('\''), "\\'");
        map.put(Character.valueOf('`'), "\\`");
        escapeMapping = Collections.unmodifiableMap(map);
    }
}

