/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.internal;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.executor.InsertOrUpdateJdbcExecutor;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatementImpl;
import org.apache.flink.connector.jdbc.utils.JdbcUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.sort.jdbc.internal.JdbcBatchingOutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TableJdbcUpsertOutputFormat
extends JdbcBatchingOutputFormat<Tuple2<Boolean, Row>, Row, JdbcBatchStatementExecutor<Row>> {
    private static final Logger LOG = LoggerFactory.getLogger(TableJdbcUpsertOutputFormat.class);
    private final JdbcBatchingOutputFormat.StatementExecutorFactory<JdbcBatchStatementExecutor<Row>> deleteStatementExecutorFactory;
    private JdbcBatchStatementExecutor<Row> deleteExecutor;

    TableJdbcUpsertOutputFormat(JdbcConnectionProvider connectionProvider, JdbcDmlOptions dmlOptions, JdbcExecutionOptions batchOptions, String inLongMetric, String auditHostAndPorts) {
        this(connectionProvider, batchOptions, ctx -> TableJdbcUpsertOutputFormat.createUpsertRowExecutor(dmlOptions, ctx), ctx -> TableJdbcUpsertOutputFormat.createDeleteExecutor(dmlOptions, ctx), inLongMetric, auditHostAndPorts);
    }

    @VisibleForTesting
    TableJdbcUpsertOutputFormat(JdbcConnectionProvider connectionProvider, JdbcExecutionOptions batchOptions, JdbcBatchingOutputFormat.StatementExecutorFactory<JdbcBatchStatementExecutor<Row>> statementExecutorFactory, JdbcBatchingOutputFormat.StatementExecutorFactory<JdbcBatchStatementExecutor<Row>> deleteStatementExecutorFactory, String inLongMetric, String auditHostAndPorts) {
        super(connectionProvider, batchOptions, statementExecutorFactory, tuple2 -> (Row)tuple2.f1, inLongMetric, auditHostAndPorts);
        this.deleteStatementExecutorFactory = deleteStatementExecutorFactory;
    }

    private static JdbcBatchStatementExecutor<Row> createDeleteExecutor(JdbcDmlOptions dmlOptions, RuntimeContext ctx) {
        int[] pkFields = Arrays.stream(dmlOptions.getFieldNames()).mapToInt(Arrays.asList(dmlOptions.getFieldNames())::indexOf).toArray();
        int[] pkTypes = dmlOptions.getFieldTypes() == null ? null : Arrays.stream(pkFields).map(f -> dmlOptions.getFieldTypes()[f]).toArray();
        String deleteSql = FieldNamedPreparedStatementImpl.parseNamedStatement(dmlOptions.getDialect().getDeleteStatement(dmlOptions.getTableName(), dmlOptions.getFieldNames()), new HashMap<String, List<Integer>>());
        return TableJdbcUpsertOutputFormat.createKeyedRowExecutor(pkFields, pkTypes, deleteSql);
    }

    private static JdbcBatchStatementExecutor<Row> createKeyedRowExecutor(int[] pkFields, int[] pkTypes, String sql) {
        return JdbcBatchStatementExecutor.keyed(sql, TableJdbcUpsertOutputFormat.createRowKeyExtractor(pkFields), (st, record) -> JdbcUtils.setRecordToStatement(st, pkTypes, TableJdbcUpsertOutputFormat.createRowKeyExtractor(pkFields).apply((Row)record)));
    }

    private static JdbcBatchStatementExecutor<Row> createUpsertRowExecutor(JdbcDmlOptions opt, RuntimeContext ctx) {
        Preconditions.checkArgument((boolean)opt.getKeyFields().isPresent());
        int[] pkFields = Arrays.stream((Object[])opt.getKeyFields().get()).mapToInt(Arrays.asList(opt.getFieldNames())::indexOf).toArray();
        int[] pkTypes = opt.getFieldTypes() == null ? null : Arrays.stream(pkFields).map(f -> opt.getFieldTypes()[f]).toArray();
        return opt.getDialect().getUpsertStatement(opt.getTableName(), opt.getFieldNames(), opt.getKeyFields().get()).map(sql -> TableJdbcUpsertOutputFormat.createSimpleRowExecutor(TableJdbcUpsertOutputFormat.parseNamedStatement(sql), opt.getFieldTypes(), ctx.getExecutionConfig().isObjectReuseEnabled())).orElseGet(() -> new InsertOrUpdateJdbcExecutor<Row, Row, Row>(TableJdbcUpsertOutputFormat.parseNamedStatement(opt.getDialect().getRowExistsStatement(opt.getTableName(), opt.getKeyFields().get())), TableJdbcUpsertOutputFormat.parseNamedStatement(opt.getDialect().getInsertIntoStatement(opt.getTableName(), opt.getFieldNames())), TableJdbcUpsertOutputFormat.parseNamedStatement(opt.getDialect().getUpdateStatement(opt.getTableName(), opt.getFieldNames(), opt.getKeyFields().get())), TableJdbcUpsertOutputFormat.createRowJdbcStatementBuilder(pkTypes), TableJdbcUpsertOutputFormat.createRowJdbcStatementBuilder(opt.getFieldTypes()), TableJdbcUpsertOutputFormat.createRowJdbcStatementBuilder(opt.getFieldTypes()), TableJdbcUpsertOutputFormat.createRowKeyExtractor(pkFields), ctx.getExecutionConfig().isObjectReuseEnabled() ? Row::copy : Function.identity()));
    }

    private static String parseNamedStatement(String statement) {
        return FieldNamedPreparedStatementImpl.parseNamedStatement(statement, new HashMap<String, List<Integer>>());
    }

    private static Function<Row, Row> createRowKeyExtractor(int[] pkFields) {
        return row -> JdbcUtils.getPrimaryKey(row, pkFields);
    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        this.deleteExecutor = (JdbcBatchStatementExecutor)this.deleteStatementExecutorFactory.apply((JdbcBatchStatementExecutor<Row>)this.getRuntimeContext());
        try {
            this.deleteExecutor.prepareStatements(this.connectionProvider.getConnection());
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void addToBatch(Tuple2<Boolean, Row> original, Row extracted) throws SQLException {
        if (((Boolean)original.f0).booleanValue()) {
            super.addToBatch(original, extracted);
        } else {
            this.deleteExecutor.addToBatch(extracted);
        }
    }

    @Override
    public synchronized void close() {
        try {
            super.close();
        }
        finally {
            try {
                if (this.deleteExecutor != null) {
                    this.deleteExecutor.closeStatements();
                }
            }
            catch (SQLException e) {
                LOG.warn("unable to close delete statement runner", e);
            }
        }
    }

    @Override
    protected void attemptFlush() throws SQLException {
        super.attemptFlush();
        this.deleteExecutor.executeBatch();
    }

    @Override
    public void updateExecutor(boolean reconnect) throws SQLException, ClassNotFoundException {
        super.updateExecutor(reconnect);
        this.deleteExecutor.closeStatements();
        this.deleteExecutor.prepareStatements(this.connectionProvider.getConnection());
    }
}

