/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.internal;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.connector.jdbc.JdbcStatementBuilder;
import org.apache.flink.connector.jdbc.internal.AbstractJdbcOutputFormat;
import org.apache.flink.connector.jdbc.internal.connection.JdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.connection.SimpleJdbcConnectionProvider;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcOptions;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatementImpl;
import org.apache.flink.connector.jdbc.utils.JdbcUtils;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.inlong.audit.AuditImp;
import org.apache.inlong.sort.base.Constants;
import org.apache.inlong.sort.base.metric.SinkMetricData;
import org.apache.inlong.sort.jdbc.internal.TableJdbcUpsertOutputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcBatchingOutputFormat<In, JdbcIn, JdbcExec extends JdbcBatchStatementExecutor<JdbcIn>>
extends AbstractJdbcOutputFormat<In> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(JdbcBatchingOutputFormat.class);
    private final JdbcExecutionOptions executionOptions;
    private final StatementExecutorFactory<JdbcExec> statementExecutorFactory;
    private final RecordExtractor<In, JdbcIn> jdbcRecordExtractor;
    private final String inLongMetric;
    private final String auditHostAndPorts;
    private transient JdbcExec jdbcStatementExecutor;
    private transient int batchCount = 0;
    private volatile transient boolean closed = false;
    private transient ScheduledExecutorService scheduler;
    private transient ScheduledFuture<?> scheduledFuture;
    private volatile transient Exception flushException;
    private transient RuntimeContext runtimeContext;
    private SinkMetricData sinkMetricData;
    private String inLongGroupId;
    private String inLongStreamId;
    private transient AuditImp auditImp;
    private Long dataSize = 0L;
    private Long rowSize = 0L;

    public JdbcBatchingOutputFormat(@Nonnull JdbcConnectionProvider connectionProvider, @Nonnull JdbcExecutionOptions executionOptions, @Nonnull StatementExecutorFactory<JdbcExec> statementExecutorFactory, @Nonnull RecordExtractor<In, JdbcIn> recordExtractor, String inLongMetric, String auditHostAndPorts) {
        super(connectionProvider);
        this.executionOptions = (JdbcExecutionOptions)Preconditions.checkNotNull((Object)executionOptions);
        this.statementExecutorFactory = (StatementExecutorFactory)Preconditions.checkNotNull(statementExecutorFactory);
        this.jdbcRecordExtractor = (RecordExtractor)Preconditions.checkNotNull(recordExtractor);
        this.inLongMetric = inLongMetric;
        this.auditHostAndPorts = auditHostAndPorts;
    }

    public static Builder builder() {
        return new Builder();
    }

    static JdbcBatchStatementExecutor<Row> createSimpleRowExecutor(String sql, int[] fieldTypes, boolean objectReuse) {
        return JdbcBatchStatementExecutor.simple(sql, JdbcBatchingOutputFormat.createRowJdbcStatementBuilder(fieldTypes), objectReuse ? Row::copy : Function.identity());
    }

    static JdbcStatementBuilder<Row> createRowJdbcStatementBuilder(int[] types) {
        return (st, record) -> JdbcUtils.setRecordToStatement(st, types, record);
    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        super.open(taskNumber, numTasks);
        this.runtimeContext = this.getRuntimeContext();
        if (this.inLongMetric != null && !this.inLongMetric.isEmpty()) {
            String[] inLongMetricArray = this.inLongMetric.split("&");
            this.inLongGroupId = inLongMetricArray[0];
            this.inLongStreamId = inLongMetricArray[1];
            String nodeId = inLongMetricArray[2];
            this.sinkMetricData = new SinkMetricData(this.inLongGroupId, this.inLongStreamId, nodeId, this.runtimeContext.getMetricGroup());
            this.sinkMetricData.registerMetricsForDirtyBytes();
            this.sinkMetricData.registerMetricsForDirtyRecords();
            this.sinkMetricData.registerMetricsForNumBytesOut();
            this.sinkMetricData.registerMetricsForNumRecordsOut();
            this.sinkMetricData.registerMetricsForNumBytesOutPerSecond();
            this.sinkMetricData.registerMetricsForNumRecordsOutPerSecond();
        }
        if (this.auditHostAndPorts != null) {
            AuditImp.getInstance().setAuditProxy(new HashSet<String>(Arrays.asList(this.auditHostAndPorts.split("&"))));
            this.auditImp = AuditImp.getInstance();
        }
        this.jdbcStatementExecutor = this.createAndOpenStatementExecutor(this.statementExecutorFactory);
        if (this.executionOptions.getBatchIntervalMs() != 0L && this.executionOptions.getBatchSize() != 1) {
            this.scheduler = Executors.newScheduledThreadPool(1, (ThreadFactory)new ExecutorThreadFactory("jdbc-upsert-output-format"));
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
                JdbcBatchingOutputFormat jdbcBatchingOutputFormat = this;
                synchronized (jdbcBatchingOutputFormat) {
                    if (!this.closed) {
                        try {
                            this.flush();
                            if (this.sinkMetricData.getNumRecordsOut() != null) {
                                this.sinkMetricData.getNumRecordsOut().inc(this.rowSize.longValue());
                            }
                            if (this.sinkMetricData.getNumBytesOut() != null) {
                                this.sinkMetricData.getNumBytesOut().inc(this.dataSize.longValue());
                            }
                            this.resetStateAfterFlush();
                        }
                        catch (Exception e) {
                            if (this.sinkMetricData.getDirtyRecords() != null) {
                                this.sinkMetricData.getDirtyRecords().inc(this.rowSize.longValue());
                            }
                            if (this.sinkMetricData.getDirtyBytes() != null) {
                                this.sinkMetricData.getDirtyBytes().inc(this.dataSize.longValue());
                            }
                            this.resetStateAfterFlush();
                            this.flushException = e;
                        }
                    }
                }
            }, this.executionOptions.getBatchIntervalMs(), this.executionOptions.getBatchIntervalMs(), TimeUnit.MILLISECONDS);
        }
    }

    private JdbcExec createAndOpenStatementExecutor(StatementExecutorFactory<JdbcExec> statementExecutorFactory) throws IOException {
        JdbcBatchStatementExecutor exec = (JdbcBatchStatementExecutor)statementExecutorFactory.apply(this.getRuntimeContext());
        try {
            exec.prepareStatements(this.connectionProvider.getConnection());
        }
        catch (SQLException e) {
            throw new IOException("unable to open JDBC writer", e);
        }
        return (JdbcExec)exec;
    }

    private void checkFlushException() {
        if (this.flushException != null) {
            throw new RuntimeException("Writing records to JDBC failed.", this.flushException);
        }
    }

    private void outputMetricForAudit(long length) {
        if (this.auditImp != null) {
            this.auditImp.add(Constants.AUDIT_SORT_INPUT, this.inLongGroupId, this.inLongStreamId, System.currentTimeMillis(), 1L, length);
        }
    }

    public final synchronized void writeRecord(In record) throws IOException {
        this.checkFlushException();
        Long l = this.rowSize;
        Long l2 = this.rowSize = Long.valueOf(this.rowSize + 1L);
        this.dataSize = this.dataSize + (long)record.toString().getBytes(StandardCharsets.UTF_8).length;
        this.outputMetricForAudit(this.dataSize);
        try {
            this.addToBatch(record, this.jdbcRecordExtractor.apply(record));
            ++this.batchCount;
            if (this.executionOptions.getBatchSize() > 0 && this.batchCount >= this.executionOptions.getBatchSize()) {
                this.flush();
                if (this.sinkMetricData.getNumRecordsOut() != null) {
                    this.sinkMetricData.getNumRecordsOut().inc(this.rowSize.longValue());
                }
                if (this.sinkMetricData.getNumBytesOut() != null) {
                    this.sinkMetricData.getNumBytesOut().inc(this.dataSize.longValue());
                }
                this.resetStateAfterFlush();
            }
        }
        catch (Exception e) {
            if (this.sinkMetricData.getDirtyRecords() != null) {
                this.sinkMetricData.getDirtyRecords().inc(this.rowSize.longValue());
            }
            if (this.sinkMetricData.getDirtyBytes() != null) {
                this.sinkMetricData.getDirtyBytes().inc(this.dataSize.longValue());
            }
            this.resetStateAfterFlush();
            throw new IOException("Writing records to JDBC failed.", e);
        }
    }

    private void resetStateAfterFlush() {
        this.dataSize = 0L;
        this.rowSize = 0L;
    }

    protected void addToBatch(In original, JdbcIn extracted) throws SQLException {
        this.jdbcStatementExecutor.addToBatch(extracted);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.checkFlushException();
        for (int i = 0; i <= this.executionOptions.getMaxRetries(); ++i) {
            try {
                this.attemptFlush();
                this.batchCount = 0;
                break;
            }
            catch (SQLException e) {
                LOG.error("JDBC executeBatch error, retry times = {}", (Object)i, (Object)e);
                if (i >= this.executionOptions.getMaxRetries()) {
                    throw new IOException(e);
                }
                try {
                    if (!this.connectionProvider.isConnectionValid()) {
                        this.updateExecutor(true);
                    }
                }
                catch (Exception exception) {
                    LOG.error("JDBC connection is not valid, and reestablish connection failed.", exception);
                    throw new IOException("Reestablish JDBC connection failed", exception);
                }
                try {
                    Thread.sleep(1000 * i);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException("unable to flush; interrupted while doing another attempt", e);
                }
            }
        }
    }

    protected void attemptFlush() throws SQLException {
        this.jdbcStatementExecutor.executeBatch();
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
                this.scheduler.shutdown();
            }
            if (this.batchCount > 0) {
                try {
                    this.flush();
                }
                catch (Exception e) {
                    LOG.warn("Writing records to JDBC failed.", e);
                    throw new RuntimeException("Writing records to JDBC failed.", e);
                }
            }
            try {
                if (this.jdbcStatementExecutor != null) {
                    this.jdbcStatementExecutor.closeStatements();
                }
            }
            catch (SQLException e) {
                LOG.warn("Close JDBC writer failed.", e);
            }
        }
        super.close();
        this.checkFlushException();
    }

    public void updateExecutor(boolean reconnect) throws SQLException, ClassNotFoundException {
        this.jdbcStatementExecutor.closeStatements();
        this.jdbcStatementExecutor.prepareStatements(reconnect ? this.connectionProvider.reestablishConnection() : this.connectionProvider.getConnection());
    }

    public static class Builder {
        private JdbcOptions options;
        private String[] fieldNames;
        private String[] keyFields;
        private int[] fieldTypes;
        private String inLongMetric;
        private String auditHostAndPorts;
        private JdbcExecutionOptions.Builder executionOptionsBuilder = JdbcExecutionOptions.builder();

        public Builder setOptions(JdbcOptions options) {
            this.options = options;
            return this;
        }

        public Builder setFieldNames(String[] fieldNames) {
            this.fieldNames = fieldNames;
            return this;
        }

        public Builder setKeyFields(String[] keyFields) {
            this.keyFields = keyFields;
            return this;
        }

        public Builder setFieldTypes(int[] fieldTypes) {
            this.fieldTypes = fieldTypes;
            return this;
        }

        public Builder setinLongMetric(String inLongMetric) {
            this.inLongMetric = inLongMetric;
            return this;
        }

        public Builder setAuditHostAndPorts(String auditHostAndPorts) {
            this.auditHostAndPorts = auditHostAndPorts;
            return this;
        }

        public Builder setFlushMaxSize(int flushMaxSize) {
            this.executionOptionsBuilder.withBatchSize(flushMaxSize);
            return this;
        }

        public Builder setFlushIntervalMills(long flushIntervalMills) {
            this.executionOptionsBuilder.withBatchIntervalMs(flushIntervalMills);
            return this;
        }

        public Builder setMaxRetryTimes(int maxRetryTimes) {
            this.executionOptionsBuilder.withMaxRetries(maxRetryTimes);
            return this;
        }

        public JdbcBatchingOutputFormat<Tuple2<Boolean, Row>, Row, JdbcBatchStatementExecutor<Row>> build() {
            Preconditions.checkNotNull((Object)this.options, (String)"No options supplied.");
            Preconditions.checkNotNull((Object)this.fieldNames, (String)"No fieldNames supplied.");
            JdbcDmlOptions dml = ((JdbcDmlOptions.JdbcDmlOptionsBuilder)JdbcDmlOptions.builder().withTableName(this.options.getTableName()).withDialect(this.options.getDialect()).withFieldNames(this.fieldNames).withKeyFields(this.keyFields).withFieldTypes(this.fieldTypes)).build();
            if (dml.getKeyFields().isPresent() && dml.getKeyFields().get().length > 0) {
                return new TableJdbcUpsertOutputFormat(new SimpleJdbcConnectionProvider(this.options), dml, this.executionOptionsBuilder.build(), this.inLongMetric, this.auditHostAndPorts);
            }
            String sql = FieldNamedPreparedStatementImpl.parseNamedStatement(this.options.getDialect().getInsertIntoStatement(dml.getTableName(), dml.getFieldNames()), new HashMap<String, List<Integer>>());
            return new JdbcBatchingOutputFormat<Tuple2<Boolean, Row>, Row, JdbcBatchStatementExecutor<Row>>(new SimpleJdbcConnectionProvider(this.options), this.executionOptionsBuilder.build(), ctx -> JdbcBatchingOutputFormat.createSimpleRowExecutor(sql, dml.getFieldTypes(), ctx.getExecutionConfig().isObjectReuseEnabled()), tuple2 -> {
                Preconditions.checkArgument((boolean)((Boolean)tuple2.f0));
                return (Row)tuple2.f1;
            }, this.inLongMetric, this.auditHostAndPorts);
        }
    }

    public static interface StatementExecutorFactory<T extends JdbcBatchStatementExecutor<?>>
    extends Function<RuntimeContext, T>,
    Serializable {
    }

    public static interface RecordExtractor<F, T>
    extends Function<F, T>,
    Serializable {
        public static <T> RecordExtractor<T, T> identity() {
            return x -> x;
        }
    }
}

