/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.jdbc.internal;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.jdbc.internal.AbstractJdbcOutputFormat;
import org.apache.flink.runtime.state.FunctionInitializationContext;
import org.apache.flink.runtime.state.FunctionSnapshotContext;
import org.apache.flink.streaming.api.checkpoint.CheckpointedFunction;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.util.Preconditions;

@Internal
public class GenericJdbcSinkFunction<T>
extends RichSinkFunction<T>
implements CheckpointedFunction {
    private final AbstractJdbcOutputFormat<T> outputFormat;

    public GenericJdbcSinkFunction(@Nonnull AbstractJdbcOutputFormat<T> outputFormat) {
        this.outputFormat = (AbstractJdbcOutputFormat)Preconditions.checkNotNull(outputFormat);
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        RuntimeContext ctx = this.getRuntimeContext();
        this.outputFormat.setRuntimeContext(ctx);
        this.outputFormat.open(ctx.getIndexOfThisSubtask(), ctx.getNumberOfParallelSubtasks());
    }

    public void invoke(T value, SinkFunction.Context context) throws IOException {
        this.outputFormat.writeRecord(value);
    }

    public void initializeState(FunctionInitializationContext context) {
    }

    public void snapshotState(FunctionSnapshotContext context) throws Exception {
        this.outputFormat.flush();
    }

    public void close() {
        this.outputFormat.close();
    }
}

